/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.model.AccessTokenInfo;
import kd.bos.login.model.UserOrgsInfo;
import kd.bos.login.thirdauth.LoginUserAuth;
import kd.bos.login.thirdauth.UserAccount;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.HttpUtils;

public class YzjPubCloudAuth
implements LoginUserAuth {
    private static final String BOS_LOGIN = "bos-login";
    private Log logger = LogFactory.getLog(YzjPubCloudAuth.class);

    @Override
    public UserAuthResult userAuthrize(UserAccount user, Account dataCenter) {
        UserAuthResult uar = new UserAuthResult();
        uar.setSucess(false);
        String userName = user.getAccount();
        String userPassword = user.getPassword();
        String ytxzHost = System.getProperty("YTXZHost");
        String ytxzClient_ID = System.getProperty("YTXZClient_ID");
        String ytxzClient_Secret = System.getProperty("YTXZClient_Secret");
        HashMap<String, String> mpHeader = new HashMap<String, String>();
        mpHeader.put("Content-Type", "application/x-www-form-urlencoded");
        HashMap<String, String> mpBody = new HashMap<String, String>();
        mpBody.put("username", userName);
        mpBody.put("password", userPassword);
        mpBody.put("client_id", ytxzClient_ID);
        mpBody.put("client_secret", ytxzClient_Secret);
        String sURL = ytxzHost + "/" + "auth/user/access_token";
        this.logger.info("\u5f00\u59cb\u83b7\u53d6\u767b\u9646\u7528\u6237\u7684\u91d1\u8776\u4e91\u901a\u884c\u8bc1AccessToken\u3002");
        String jsonTxzAccessToken = null;
        try {
            jsonTxzAccessToken = HttpClientUtils.post((String)sURL, mpHeader, mpBody);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
        if (StringUtils.isBlank(jsonTxzAccessToken)) {
            String sResult = ResManager.loadKDString((String)"\u83b7\u53d6AccessToken\u5931\u8d25\u3002", (String)"YzjPubCloudAuth_0", (String)BOS_LOGIN, (Object[])new Object[0]);
            uar.setErrDesc(sResult);
            return uar;
        }
        AccessTokenInfo ati = null;
        try {
            ati = JSONUtils.cast(jsonTxzAccessToken, AccessTokenInfo.class, true);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
        if (ati == null) {
            uar.setErrDesc(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u4e91\u901a\u4fe1\u8bc1AccessToken\u5931\u8d25\u3002", (String)"YzjPubCloudAuth_1", (String)BOS_LOGIN, (Object[])new Object[0]));
            return uar;
        }
        if (ati.getData() == null || ati.getErrcode() != 0) {
            uar.setErrDesc(ati.getDescription_cn());
            return uar;
        }
        this.logger.info("\u83b7\u53d6\u767b\u9646\u7528\u6237\u7684\u4e91\u901a\u884c\u8bc1AccessToken\u6210\u529f\u3002");
        this.logger.info("\u5f00\u59cb\u83b7\u53d6\u767b\u9646\u7528\u6237\u7684\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708\u3002");
        String sAccessToken = ati.getData().getAccess_token();
        sURL = ytxzHost + "/" + "passport/user/orgs" + "?access_token=" + sAccessToken;
        String jsonTxzUserOrgs = HttpUtils.request((String)sURL, (String)"GET", null);
        if (StringUtils.isBlank(jsonTxzUserOrgs)) {
            uar.setErrDesc(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u7684\u5de5\u4f5c\u5708\u3002", (String)"YzjPubCloudAuth_3", (String)BOS_LOGIN, (Object[])new Object[0]));
            return uar;
        }
        UserOrgsInfo orgsInfo = null;
        try {
            orgsInfo = JSONUtils.cast(jsonTxzUserOrgs, UserOrgsInfo.class, true);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
        if (orgsInfo == null || orgsInfo.getData() == null || orgsInfo.getErrcode() != 0 || orgsInfo.getData().isEmpty()) {
            uar.setErrDesc(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u7684\u5de5\u4f5c\u5708\u3002", (String)"YzjPubCloudAuth_3", (String)BOS_LOGIN, (Object[])new Object[0]));
            return uar;
        }
        ArrayList<Long> sEids = new ArrayList<Long>();
        for (UserOrgsInfo.Data data : orgsInfo.getData()) {
            sEids.add(Long.parseLong(data.getEid()));
        }
        String cacheType = CacheLoginData.getType4YzjUserTenantList((String)String.valueOf(ati.getData().getUid()));
        HashMap<String, String> mpYzjKey = new HashMap<String, String>();
        mpYzjKey.put("EidList", ((Object)sEids).toString());
        CacheLoginData.setAttributes((String)cacheType, mpYzjKey);
        uar.setUserType(UserProperType.YunzhijiaUId);
        uar.setUser(ati.getData().getUid());
        uar.setJoinedEids(sEids);
        uar.setSucess(true);
        this.logger.info("\u83b7\u53d6\u767b\u9646\u7528\u6237\u7684\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708API\u6210\u529f\u3002");
        return uar;
    }
}

