/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.user;

import java.util.Base64;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.cache.LoginCacheService;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.session.service.DBUtils;
import kd.bos.util.StringUtils;

public class DefaultParameterService {
    private static final String DEFAULT_TYPE = "1";
    private static Log logger = LogFactory.getLog(DefaultParameterService.class);
    private static LoginCacheService loginCacheService = new LoginCacheService();
    private static final Integer TIME_EXPIRE = 600;

    public static String getDefaultValueByKey(String key) {
        return DefaultParameterService.getDefaultValueByKey(key, DEFAULT_TYPE);
    }

    public static String getDefaultValueByKey(String key, String type) {
        String returnValue = null;
        String realKey = DefaultParameterService.getKey(type, key);
        returnValue = loginCacheService.get(realKey);
        if (StringUtils.isEmpty((String)returnValue) && RequestContext.get() != null && RequestContext.get().getAccountId() != null && StringUtils.isNotEmpty((String)(returnValue = DefaultParameterService.getDefaultParamsConfig(AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId()), key)))) {
            loginCacheService.put(DefaultParameterService.getKey(type, key), returnValue, TIME_EXPIRE.intValue());
        }
        return returnValue;
    }

    private static void initAllDefault() {
        try {
            StringBuilder sql = new StringBuilder("select fid, fparam_key,fparam_value, fparam_type  from T_BAS_DEFAULT_PARAMS ");
            ResultSetHandler rsh = rs -> {
                while (rs.next()) {
                    loginCacheService.put(DefaultParameterService.getKey(rs.getString("fparam_type"), DefaultParameterService.decode(rs.getString("fparam_key"))), DefaultParameterService.decode(rs.getString("fparam_value")), TIME_EXPIRE.intValue());
                }
                return null;
            };
            Account account = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
            DBUtils.query((Account)account, (DBRoute)DBRoute.basedata, (String)sql.toString(), null, (ResultSetHandler)rsh);
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
    }

    private static String getKey(String type, String key) {
        return type + "_bos_svc_" + key;
    }

    private static String decode(String data) {
        String result = "";
        if (StringUtils.isNotEmpty((String)data)) {
            result = new StringBuilder(data).reverse().toString();
            try {
                result = new String(Base64.getDecoder().decode(result));
            }
            catch (Exception e) {
                result = data;
            }
        }
        return result;
    }

    public static String getDefaultParamsConfig(Account account, String paramKey) {
        StringBuilder sql = new StringBuilder("select fid, fparam_key,fparam_value, fparam_type  from T_BAS_DEFAULT_PARAMS where fparam_key = ? or fparam_key = ? ");
        Object[] params = new Object[]{paramKey, DefaultParameterService.encode(paramKey)};
        Object paramValue = DBUtils.query((Account)account, (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, rs -> {
            String val = "";
            while (rs.next()) {
                val = DefaultParameterService.decode(rs.getString("fparam_value"));
            }
            return val;
        });
        return ObjectUtils.isEmpty((Object)paramValue) ? "" : paramValue.toString();
    }

    private static String encode(String data) {
        String result = "";
        if (StringUtils.isNotEmpty((String)data)) {
            try {
                result = new String(Base64.getEncoder().encode(data.getBytes()));
                result = new StringBuilder(result).reverse().toString();
            }
            catch (Exception e) {
                result = data;
            }
        }
        return result;
    }

    public static void updateDefaultParamsConfig(Account account, String fkey, String paramValue) {
        StringBuilder sql = new StringBuilder("update T_BAS_DEFAULT_PARAMS set fparam_value = ? where fparam_key = ? ");
        Object[] params = new Object[]{paramValue, fkey};
        DBUtils.execute((Account)account, (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params);
        String realKey = DefaultParameterService.getKey(DEFAULT_TYPE, fkey);
        loginCacheService.remove(realKey);
    }

    static {
        DefaultParameterService.initAllDefault();
    }
}

