/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.user;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.IpUtils;
import org.bouncycastle.util.IPAddress;

public class IpControlService {
    private static Log logger = LogFactory.getLog(IpControlService.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> verifyIp(Account currentCenter, long userId, String clientIp) {
        HashMap<String, Object> hashMap;
        Connection conn;
        ResultSet rs;
        PreparedStatement pstmt;
        HashMap<String, Object> result;
        block8: {
            result = new HashMap<String, Object>(8);
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
            pstmt = null;
            rs = null;
            conn = null;
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            String sql = " select fip from t_sec_ipcontrol t where fenable = '1' and (fuserid = ? or t.fdepartmentid in (select fdptid from T_SEC_USERPOSITION t where fid = ?)) ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, userId);
            pstmt.setLong(2, userId);
            rs = pstmt.executeQuery();
            StringBuilder stringBuilder = new StringBuilder();
            while (rs.next()) {
                stringBuilder.append(rs.getString(1)).append(",");
            }
            String[] clientIps = clientIp.split(",");
            if (null != clientIps && clientIps.length > 0) {
                clientIp = clientIps[0];
            }
            if (stringBuilder == null || stringBuilder.length() <= 0 || !IPAddress.isValid((String)clientIp)) break block8;
            String[] ips = stringBuilder.toString().split(",");
            logger.info("fip3=" + stringBuilder.toString() + "&clientIp=" + clientIp);
            if (IpUtils.judgeIpInRange(clientIp, ips).booleanValue()) break block8;
            result.put("success", false);
            HashMap<String, Object> hashMap2 = result;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return hashMap2;
        }
        try {
            result.put("success", true);
            hashMap = result;
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return hashMap;
    }
}

