/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.user;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class LicenseService {
    private static final String DAYS = "days";
    private static Log logger = LogFactory.getLog(LicenseService.class);
    private static final String OVER_TIME = "overTime";
    private static final String MSG = "msg";
    private static final String BOS_LOGIN = "bos-login";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasYZJLicense(Account currentCenter) {
        boolean hasRight = false;
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
        if (dataBaseProperties == null) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int total;
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            String sql = "";
            boolean index = true;
            int numbers = 2;
            sql = "SELECT ftotalcount from t_lic_licensedetail where fgroupid = 103;";
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next() && (total = rs.getInt("ftotalcount")) > 0) {
                hasRight = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return hasRight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<Map<String, Object>> validateLicDate(String accountIdParameter, String tenantNo) {
        List<Map<String, Object>> list;
        block13: {
            Lang lang = LoginLangUtils.getLang();
            list = new ArrayList<Map<String, Object>>(8);
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                HashMap<String, Object> mpData;
                Account currentAccount = LoginAccountFactory.createInstanceByCustom(accountIdParameter, tenantNo).getAccount();
                Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                String sql = " SELECT lic.fexpdate FROM T_LIC_LICENSE lic  ";
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                long systemTime = System.currentTimeMillis();
                boolean hasLic = false;
                while (rs.next()) {
                    hasLic = true;
                    mpData = new HashMap<String, Object>(8);
                    Timestamp expDate = rs.getTimestamp("fexpdate");
                    boolean flag = false;
                    long expTime = ((Date)expDate).getTime();
                    if (systemTime > expTime) {
                        flag = true;
                        mpData.put(OVER_TIME, true);
                        mpData.put(MSG, ResManager.loadKDString((String)"\u8bb8\u53ef\u5df2\u5230\u671f\uff0c\u8bf7\u53ca\u65f6\u8d2d\u4e70\u3002\u671f\u95f4\u53ef\u6b63\u5e38\u767b\u5f55\uff0c\u4f46\u65e0\u6cd5\u4f7f\u7528\u53d7\u8bb8\u53ef\u63a7\u5236\u7684\u529f\u80fd\u3002", (String)"ResetPasswordAction_40", (String)BOS_LOGIN, (Object[])new Object[0]));
                        mpData.put(DAYS, 0);
                    } else {
                        mpData.put(OVER_TIME, true);
                        Date preExpDate = LicenseService.getPreDate(expDate);
                        long preTime = preExpDate.getTime();
                        if (systemTime > preTime) {
                            flag = true;
                            int days = LicenseService.differentDays(new Date(systemTime), expDate);
                            String msg = String.format(ResManager.loadKDString((String)"\u8bb8\u53ef\u8fd8\u6709%s\u5929\u5230\u671f\uff0c\u8bf7\u53ca\u65f6\u7eed\u8d39\u3002", (String)"ResetPasswordAction_41", (String)BOS_LOGIN, (Object[])new Object[0]), days);
                            mpData.put(MSG, msg);
                            if (days == 0) {
                                mpData.put(MSG, ResManager.loadKDString((String)"\u8bb8\u53ef\u4eca\u5929\u5230\u671f\uff0c\u8bf7\u53ca\u65f6\u7eed\u8d39\u3002", (String)"ResetPasswordAction_43", (String)BOS_LOGIN, (Object[])new Object[0]));
                            }
                            mpData.put(DAYS, days);
                        }
                    }
                    if (!flag) continue;
                    list = LicenseService.getLicenseList(list, mpData);
                }
                if (!hasLic) {
                    mpData = new HashMap(8);
                    mpData.put(OVER_TIME, false);
                    mpData.put(MSG, ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u8bb8\u53ef\uff0c\u8bf7\u8d2d\u4e70\u5e76\u540c\u6b65\u8bb8\u53ef\u3002", (String)"ResetPasswordAction_39", (String)BOS_LOGIN, (Object[])new Object[0]));
                    mpData.put(DAYS, 0);
                    list.add(mpData);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            }
            catch (SQLException e) {
                logger.error((Throwable)e);
            }
            catch (Exception e2) {
                logger.error((Throwable)e2);
                break block13;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SQLUtils.cleanup(rs, stmt, conn);
            }
        }
        return list;
    }

    private static List<Map<String, Object>> getLicenseList(List<Map<String, Object>> list, Map<String, Object> mpData) {
        for (int i = 0; i <= 1; ++i) {
            String format;
            HashMap<String, Object> data = new HashMap<String, Object>(8);
            if (i == 0) {
                format = String.format(ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u661f\u701a%s", (String)"LoginUtils_25", (String)BOS_LOGIN, (Object[])new Object[0]), mpData.get(MSG));
                data.put(MSG, format);
            } else {
                format = String.format(ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79%s", (String)"LoginUtils_8", (String)BOS_LOGIN, (Object[])new Object[0]), mpData.get(MSG));
                data.put(MSG, format);
            }
            data.put(DAYS, mpData.get(DAYS));
            data.put(OVER_TIME, mpData.get(OVER_TIME));
            list.add(data);
        }
        return list;
    }

    private static Date getPreDate(Date holdDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(holdDate);
        ((Calendar)calendar).add(5, -30);
        Date utilDate = calendar.getTime();
        return new Date(utilDate.getTime());
    }

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public static List<Map<String, Object>> getProductList(Account currentAccount) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        Map productInfo = LicenseServiceHelper.getProductInfo();
        if (productInfo != null && productInfo.size() > 0) {
            HashMap map = new HashMap();
            map.put("prod_inst_code", productInfo.get("prodInstCode"));
            map.put("clientId", "");
            map.put("clientSecret", "");
            result.add(map);
        }
        return result;
    }
}

