/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.user;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.util.PasswordEncryptUtil;

public class MCLoginUserService {
    private static Log logger = LogFactory.getLog(MCLoginUserService.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> proveErpUserPassword(Account currentAccount, String userNo, String password) {
        HashMap<String, String> mpResult = new HashMap<String, String>();
        mpResult.put("success", "0");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String encreptPasswod = password;
        try {
            String dbPassword;
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = "select * from t_mc_user where FNumber=?  and fenable='1'";
            stmt = conn.prepareStatement(sql);
            int index = 1;
            stmt.setString(index++, userNo);
            rs = stmt.executeQuery();
            if (rs.next() && PasswordEncryptUtil.authenticate((String)(dbPassword = rs.getString("fpassword")), (String)password)) {
                mpResult.put("fphone", rs.getString("FPhone"));
                mpResult.put("ftruename", rs.getString("fTrueName"));
                mpResult.put("fuid", rs.getString("fid"));
                mpResult.put("success", "1");
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return mpResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getUserInfo(Account currentAccount, String userNo) {
        HashMap<String, String> mpResult = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = "select * from t_mc_user where FNumber=? ";
            stmt = conn.prepareStatement(sql);
            int index = 1;
            stmt.setString(index++, userNo);
            rs = stmt.executeQuery();
            if (rs.next()) {
                mpResult = new HashMap<String, String>();
                mpResult.put("ftruename", rs.getString("fTrueName"));
                mpResult.put("fid", rs.getString("fid"));
                mpResult.put("success", "1");
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return mpResult;
    }
}

