/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.user;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.emun.TipTypeEnum;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.user.LanguageService;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.account.LoginAccount;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.DisCardUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.collections.CollectionUtils;

public class PrivacyPolicyService {
    private static final String ERRORCODE = "errorcode";
    private static final String ENTITY_USER_PRIVACY_RECORD = "bos_user_privacy_record";
    private static final String PROPERTY_FID = "id";
    private static final String PROPERTY_USER = "userid";
    private static final String PROPERTY_PRIVACYPOLICYID = "privacypolicyid";
    private static final String PROPERTY_OPTIME = "optime";
    private static final String PROPERTY_CLIENTTYPE = "clienttype";
    private static final String PROPERTY_COUNTRY = "country";
    private static final String PROPERTY_LOCALEID = "localeid";
    private static final String PROPERTY_OPTYPE = "optype";
    public static final String PRIVACY_POLICY_KEY = "privacy_policy";
    private static final Integer PRIVACY_POLICY_KEY_EXPIRE_TIME = 30;
    public static final String PROPERTY_SYNSTATUS = "synstatus";
    private static Log log = LogFactory.getLog(PrivacyPolicyService.class);
    private static ThreadPool pool = ThreadPools.newCachedThreadPool((String)"synToResourceCloud", (int)0, (int)2);

    public static void signPrivacyPolicy(HttpServletRequest servletRequest, String userId) {
        try {
            if (PrivacyPolicyService.enablePrivacy()) {
                Map<String, Object> privacyResult;
                LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty());
                Account currentCenter = loginAccount.getAccount();
                Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
                ArrayList<DynamicObject> userPrivacyList = new ArrayList<DynamicObject>(2);
                Map<String, Object> userAgreementResult = PrivacyPolicyService.getPrivacyPolicyResult("1", lang.name(), currentCenter);
                if (userAgreementResult.size() > 0 && userAgreementResult.get(PROPERTY_FID) != null) {
                    userPrivacyList.add(PrivacyPolicyService.wrapData(servletRequest, userId, (Long)userAgreementResult.get(PROPERTY_FID)));
                }
                if ((privacyResult = PrivacyPolicyService.getPrivacyPolicyResult("2", lang.name(), currentCenter)).size() > 0 && privacyResult.get(PROPERTY_FID) != null) {
                    userPrivacyList.add(PrivacyPolicyService.wrapData(servletRequest, userId, (Long)privacyResult.get(PROPERTY_FID)));
                }
                if (userPrivacyList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])userPrivacyList.toArray(new DynamicObject[userPrivacyList.size()]));
                    ArrayList<Map<String, Object>> synList = new ArrayList<Map<String, Object>>(2);
                    privacyResult.put("opFlag", "1");
                    privacyResult.put("userId", userId);
                    synList.add(privacyResult);
                    userAgreementResult.put("opFlag", "1");
                    userAgreementResult.put("userId", userId);
                    synList.add(userAgreementResult);
                    PrivacyPolicyService.synToResourceCloud(synList);
                }
            }
        }
        catch (Exception e) {
            log.info(e.toString());
        }
    }

    private static DynamicObject wrapData(HttpServletRequest servletRequest, String userId, Long privacyPolicyId) {
        DynamicObject userPrivacy = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_USER_PRIVACY_RECORD);
        userPrivacy.set(PROPERTY_USER, (Object)Long.parseLong(userId));
        userPrivacy.set(PROPERTY_OPTIME, (Object)new Date());
        userPrivacy.set(PROPERTY_PRIVACYPOLICYID, (Object)privacyPolicyId);
        userPrivacy.set(PROPERTY_CLIENTTYPE, (Object)AgentUtil.getLoginClientEnumType(servletRequest));
        userPrivacy.set(PROPERTY_LOCALEID, (Object)LoginLangUtils.getLoginLanguage(servletRequest).name());
        userPrivacy.set("opflag", (Object)"1");
        userPrivacy.set(PROPERTY_SYNSTATUS, (Object)"1");
        return userPrivacy;
    }

    @Deprecated
    private static Long getPrivacyPolicy(String type, String language) {
        Long privacyPolicyId = null;
        return privacyPolicyId;
    }

    public static boolean enablePrivacy() {
        String type;
        String enable = SystemPropertyUtils.getProptyByTenant("kingdeeprivacy_enable", RequestContext.get().getTenantId());
        if (StringUtils.isEmpty(enable) && (StringUtils.isEmpty(type = LicenseServiceHelper.getPubTenantType()) || "false".equals(type))) {
            return false;
        }
        if ("false".equals(enable)) {
            return Boolean.parseBoolean(enable);
        }
        return true;
    }

    private static List<Map<String, Object>> getLatestUserPrivacy(Long userId, Long privacyId) {
        ArrayList<Map<String, Object>> privacyPolicyIdList = new ArrayList<Map<String, Object>>(8);
        try {
            DynamicObject[] privacyArray;
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
            qFilterList.add(new QFilter("userid.id", "=", (Object)userId));
            qFilterList.add(new QFilter("opflag", "=", (Object)"1"));
            if (privacyId != null) {
                qFilterList.add(new QFilter("privacypolicyid.id", "=", (Object)privacyId));
            }
            for (DynamicObject data : privacyArray = BusinessDataServiceHelper.load((String)ENTITY_USER_PRIVACY_RECORD, (String)"id,privacypolicyid.id,opflag", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"optime desc")) {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put(PROPERTY_PRIVACYPOLICYID, data.getLong("privacypolicyid.id"));
                map.put("opflag", data.get("opflag"));
                privacyPolicyIdList.add(map);
            }
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        return privacyPolicyIdList;
    }

    public static Map<String, Object> checkNeedSignPrivacy(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Account currentCenter, String userId, Lang lang, UserAuthResult uar, String randomCode) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(ERRORCODE, "0");
        if (PrivacyPolicyService.enablePrivacy() && StringUtils.isNotEmpty(userId)) {
            Map<String, Object> privacyPolicyResult = PrivacyPolicyService.getPrivacyPolicyResult("1", LoginLangUtils.getLang().name(), currentCenter);
            List<Object> privacyRecordList = new ArrayList(8);
            if (!privacyPolicyResult.isEmpty() && privacyPolicyResult.get(PROPERTY_FID) != null && (privacyRecordList = PrivacyPolicyService.getLatestUserPrivacy(Long.parseLong(userId), (Long)privacyPolicyResult.get(PROPERTY_FID))).size() <= 0) {
                result.put("contentInnerHTML", privacyPolicyResult);
                result.put(ERRORCODE, TipTypeEnum.SIGNPRIVACY.getCode());
            }
            if (!(privacyPolicyResult = PrivacyPolicyService.getPrivacyPolicyResult("2", LoginLangUtils.getLang().name(), currentCenter)).isEmpty() && privacyPolicyResult.get(PROPERTY_FID) != null && (privacyRecordList = PrivacyPolicyService.getLatestUserPrivacy(Long.parseLong(userId), (Long)privacyPolicyResult.get(PROPERTY_FID))).size() <= 0) {
                result.put("contentInnerHTML", privacyPolicyResult);
                result.put(ERRORCODE, TipTypeEnum.SIGNPRIVACY.getCode());
            }
            String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
            CacheLoginData.setAttribute((String)PRIVACY_POLICY_KEY, (String)(currentCenter.getAccountId() + "-" + userName), (String)(userName + "," + uar.getUser() + "," + uar.getUserType().toString() + "," + userId + "," + randomCode), (int)PRIVACY_POLICY_KEY_EXPIRE_TIME);
            result.put("randomCode", randomCode);
            result.put("iframeUrl", "kingdee/svc/privacyPolicy/document.html");
        }
        return result;
    }

    public static void reSignPrivacyPolicy(HttpServletRequest servletRequest, String userId) {
        try {
            Map<String, Object> policyResult;
            LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty());
            Account currentCenter = loginAccount.getAccount();
            ArrayList<DynamicObject> userPrivacyList = new ArrayList<DynamicObject>(2);
            ArrayList<Map<String, Object>> synList = new ArrayList<Map<String, Object>>(2);
            Map<String, Object> privacyPolicyResult = PrivacyPolicyService.getPrivacyPolicyResult("1", LoginLangUtils.getLang().name(), currentCenter);
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(userId), (String)"bos_user");
            String name = user.getString("name");
            String trueName = null;
            if (!ObjectUtils.isEmpty((Object)name)) {
                trueName = name.toString();
            }
            List<Object> privacyRecordList = new ArrayList(8);
            if (!privacyPolicyResult.isEmpty() && privacyPolicyResult.get(PROPERTY_FID) != null && (privacyRecordList = PrivacyPolicyService.getLatestUserPrivacy(Long.parseLong(userId), (Long)privacyPolicyResult.get(PROPERTY_FID))).size() <= 0) {
                DynamicObject userPrivacy = PrivacyPolicyService.wrapData(servletRequest, userId, (Long)privacyPolicyResult.get(PROPERTY_FID));
                userPrivacyList.add(userPrivacy);
                privacyPolicyResult.put("userId", userId);
                privacyPolicyResult.put("opFlag", "1");
                privacyPolicyResult.put("trueName", PrivacyPolicyService.getSHA256Hash(trueName));
                privacyPolicyResult.put("signature", PrivacyPolicyService.getSHA256Hash(userId + "mewikuytreolkghdjyo986358ngjei"));
                synList.add(privacyPolicyResult);
            }
            if (!(policyResult = PrivacyPolicyService.getPrivacyPolicyResult("2", LoginLangUtils.getLang().name(), currentCenter)).isEmpty() && policyResult.get(PROPERTY_FID) != null && (privacyRecordList = PrivacyPolicyService.getLatestUserPrivacy(Long.parseLong(userId), (Long)policyResult.get(PROPERTY_FID))).size() <= 0) {
                DynamicObject userPrivacy = PrivacyPolicyService.wrapData(servletRequest, userId, (Long)policyResult.get(PROPERTY_FID));
                userPrivacyList.add(userPrivacy);
                policyResult.put("userId", userId);
                policyResult.put("opFlag", "1");
                policyResult.put("trueName", PrivacyPolicyService.getSHA256Hash(trueName));
                policyResult.put("signature", PrivacyPolicyService.getSHA256Hash(userId + "mewikuytreolkghdjyo986358ngjei"));
                synList.add(policyResult);
            }
            if (!CollectionUtils.isEmpty(userPrivacyList)) {
                SaveServiceHelper.save((DynamicObject[])userPrivacyList.toArray(new DynamicObject[userPrivacyList.size()]));
                PrivacyPolicyService.synToResourceCloud(synList);
            }
        }
        catch (Exception e) {
            log.info(e.toString());
        }
    }

    private static Map<String, Object> getPrivacyPolicyResult(String type, String language, Account currentCenter) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        try {
            DynamicObject[] privacyPolicyArray;
            Lang lang = LanguageService.getDefaultLang(currentCenter);
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
            qFilterList.add(new QFilter("type", "=", (Object)type));
            qFilterList.add(new QFilter("status", "=", (Object)"1"));
            qFilterList.add(new QFilter("locale.number", "in", (Object)new String[]{language, lang.name(), "zh_CN"}).or(new QFilter("locale", "=", (Object)0)));
            for (DynamicObject dynamicObject : privacyPolicyArray = BusinessDataServiceHelper.load((String)"bos_privacy_policy", (String)"id,locale.number,country.number,content_tag,type,version", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]))) {
                String localeNumber = dynamicObject.getString("locale.number");
                if (!language.equals(localeNumber) && result.get(PROPERTY_FID) != null) continue;
                result.put("type", type);
                result.put("version", dynamicObject.getString("version"));
                result.put("language", localeNumber);
                String countryNumber = dynamicObject.getString("country.number");
                result.put(PROPERTY_COUNTRY, countryNumber);
                result.put("content", dynamicObject.getString("content_tag"));
                if (language.equals(localeNumber)) {
                    result.put(PROPERTY_FID, dynamicObject.getLong(PROPERTY_FID));
                    return result;
                }
                if (lang != null && lang.name().equals(localeNumber)) {
                    result.put(PROPERTY_FID, dynamicObject.getLong(PROPERTY_FID));
                }
                if (!StringUtils.isEmpty(localeNumber)) continue;
                result.put(PROPERTY_FID, dynamicObject.getLong(PROPERTY_FID));
            }
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        return result;
    }

    private static void synToResourceCloud(final List<Map<String, Object>> synList) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Map map : synList) {
                        Map result;
                        Map body;
                        HashMap header;
                        String url = DefaultParameterService.getDefaultValueByKey("privacy_policy_url") + "/kapi/v2/kdec/kdec_legal_center/legalPrivacyPolicy/savePrivacyPolicyRecord";
                        String data = HttpClientUtils.postAppJson((String)url, header = new HashMap(2), (Map)(body = PrivacyPolicyService.wrapBodyData(map)));
                        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)data) || (result = (Map)JSONUtils.cast((String)data, HashMap.class)) == null || "true".equals(String.valueOf(result.get("status")))) continue;
                        log.info(data);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, RequestContext.get());
    }

    private static Map<String, Object> wrapBodyData(Map<String, Object> map) throws IOException {
        HashMap<String, Object> body = new HashMap<String, Object>(2);
        map.put("tenantId", RequestContext.get().getTenantId());
        map.put("productVersion", "7.0.1");
        body.put("privacyPolicyRecordDto", map);
        return body;
    }

    private static String getSHA256Hash(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] messageDigest = md.digest(data.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : messageDigest) {
                hexString.append(String.format("%02X", b));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            DisCardUtil.discard();
            return "";
        }
    }
}

