/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.user;

import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.LicenseService;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.TransferUtil;
import kd.bos.login.utils.ValidationUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;

public class UserService {
    private static Log logger = LogFactory.getLog(UserService.class);
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";
    private static final String PROD_INST_CODE = "prod_inst_code";
    private static final String SIGNITURE_STR = "&signiture=";
    private static final String TIMESTAMP_STR = "&timestamp=";
    private static final String PROD_INST_CODE_STR = "&prod_inst_code=";
    private static final String ERRCODE = "errcode";
    private static final String UID_STR = "&uid=";
    private static final String DESCRIPTION_CN = "description_cn";
    private static final String V_CODE_TIME = "vCodeTime";
    private static final String CLIENT_ID_STR = "?client_id=";

    public static Map<String, Object> getActiveCode(Account currentCenter, String account) {
        HashMap<String, Object> obj = new HashMap<String, Object>(8);
        boolean success = false;
        StringBuilder url = new StringBuilder(LoginUtils.getBaseUrl()).append("clouderp/account/vcode");
        int reSendTime = 60;
        String randomCode = UUID.randomUUID().toString();
        try {
            Object clientSecret;
            Map<String, String> paramMap = LoginUserService.getUserInfo(currentCenter, account);
            if (paramMap == null || paramMap.isEmpty()) {
                obj.put(SUCCESS, false);
                obj.put(ERROR, ResManager.loadKDString((String)"\u8be5\u7528\u6237\u672a\u6ce8\u518c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResetPasswordAction_9", (String)"bos-login", (Object[])new Object[0]));
                return obj;
            }
            List<Map<String, Object>> productList = LicenseService.getProductList(currentCenter);
            if (productList.isEmpty()) {
                obj.put(SUCCESS, false);
                obj.put(ERROR, ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u9519\u8bef\u3002", (String)"ResetPasswordAction_18", (String)"bos-login", (Object[])new Object[0]));
                return obj;
            }
            String usertype = paramMap.get("usertype");
            String is_remove_network = null;
            is_remove_network = StringUtils.isEmpty((String)usertype) || usertype.equals("1") || usertype.equals("7") ? "0" : "1";
            Map<String, Object> product = productList.get(0);
            Object prodInstId = product.get(PROD_INST_CODE);
            Object clientId = product.get("clientId");
            if (ObjectUtils.isEmpty((Object)clientId)) {
                clientId = LoginUtils.getCloudClientId();
            }
            if (ObjectUtils.isEmpty((Object)(clientSecret = product.get("clientSecret")))) {
                clientSecret = LoginUtils.getClientSecret();
            }
            String uid = "0";
            long timeMillis = System.currentTimeMillis();
            StringBuilder s = new StringBuilder();
            s.append(clientId).append(clientSecret).append(uid).append(prodInstId).append(account).append(timeMillis);
            String erpAccount = paramMap.get("username");
            String name = paramMap.get("truename");
            if (StringUtils.isEmpty((String)name)) {
                name = account;
            }
            if (StringUtils.isEmpty((String)erpAccount)) {
                erpAccount = account;
            }
            boolean isEmail = ValidationUtils.isEmail(account);
            String signiture = TransferUtil.sha1(s.toString());
            if (isEmail) {
                url.append(CLIENT_ID_STR).append(clientId).append(UID_STR).append(uid).append("&erp_account=").append(URLEncoder.encode(erpAccount, "utf-8")).append("&name=").append(URLEncoder.encode(name, "utf-8")).append(PROD_INST_CODE_STR).append(prodInstId).append(TIMESTAMP_STR).append(timeMillis).append("&email=").append(account).append("&is_remove_network=").append(is_remove_network).append(SIGNITURE_STR).append(signiture);
            } else {
                url.append(CLIENT_ID_STR).append(clientId).append(UID_STR).append(uid).append("&erp_account=").append(URLEncoder.encode(erpAccount, "utf-8")).append("&name=").append(URLEncoder.encode(name, "utf-8")).append(PROD_INST_CODE_STR).append(prodInstId).append(TIMESTAMP_STR).append(timeMillis).append("&phone=").append(account).append("&is_remove_network=").append(is_remove_network).append(SIGNITURE_STR).append(signiture);
            }
            String returnValue = HttpClientUtils.get((String)url.toString());
            if (returnValue != null && returnValue.length() > 0) {
                Map map = (Map)JSONObject.parseObject((String)returnValue, Map.class);
                if (map.get(ERRCODE) != null && "0".equals(String.valueOf(map.get(ERRCODE)))) {
                    Map data;
                    success = true;
                    Map map2 = data = null != map.get("data") ? (Map)map.get("data") : null;
                    if (null != data) {
                        reSendTime = null != data.get("resend_in") ? Integer.parseInt(String.valueOf(data.get("resend_in"))) : reSendTime;
                    }
                } else if (map.get(ERRCODE) != null && "4006".equals(String.valueOf(map.get(ERRCODE)))) {
                    obj.put(ERROR, ResManager.loadKDString((String)"\u7cfb\u7edf\u672a\u6ce8\u518c\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u540c\u6b65\u8bb8\u53ef\u3002", (String)"ResetPasswordAction_80", (String)"bos-login", (Object[])new Object[0]));
                    obj.put("errorCode", map.get(ERRCODE));
                } else {
                    obj.put(ERROR, map.get(DESCRIPTION_CN));
                    obj.put("errorCode", map.get(ERRCODE));
                }
            }
        }
        catch (Exception e) {
            logger.error("getActiveCode error == " + e);
        }
        obj.put(SUCCESS, success);
        obj.put(V_CODE_TIME, reSendTime * 1000);
        return obj;
    }

    public static Map<String, Object> verifyCloudCode(Account currentCenter, String account, String vcode) {
        Map<String, Object> result = new HashMap<String, Object>();
        StringBuilder url = new StringBuilder(LoginUtils.getBaseUrl()).append("clouderp/account/vcode/verifying");
        try {
            Map<String, String> paramMap = LoginUserService.getUserInfo(currentCenter, account);
            if (paramMap == null) {
                result.put(SUCCESS, false);
                result.put(ERROR, ResManager.loadKDString((String)"\u8be5\u7528\u6237\u672a\u6ce8\u518c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResetPasswordAction_9", (String)"bos-login", (Object[])new Object[0]));
                return result;
            }
            String uid = "0";
            List<Map<String, Object>> productList = LicenseService.getProductList(currentCenter);
            Map<String, Object> product = productList.get(0);
            Object clientId = product.get("clientId");
            Object clientSecret = product.get("clientSecret");
            Object prodInstId = product.get(PROD_INST_CODE);
            if (ObjectUtils.isEmpty((Object)clientId)) {
                clientId = LoginUtils.getCloudClientId();
            }
            if (ObjectUtils.isEmpty((Object)clientSecret)) {
                clientSecret = LoginUtils.getClientSecret();
            }
            String phone = paramMap.get("phone");
            StringBuilder s = new StringBuilder();
            long timeMillis = System.currentTimeMillis();
            s.append(clientId).append(clientSecret).append(uid).append(prodInstId).append(phone).append(vcode).append(timeMillis);
            String signiture = TransferUtil.sha1(s.toString());
            boolean isEmail = ValidationUtils.isEmail(phone);
            if (isEmail) {
                url.append(CLIENT_ID_STR).append(LoginUtils.getCloudClientId()).append(UID_STR).append(uid).append(PROD_INST_CODE_STR).append(prodInstId).append("&vcode=").append(vcode).append(TIMESTAMP_STR).append(timeMillis).append("&email=").append(phone).append(SIGNITURE_STR).append(signiture);
            } else {
                url.append(CLIENT_ID_STR).append(LoginUtils.getCloudClientId()).append(UID_STR).append(uid).append(PROD_INST_CODE_STR).append(prodInstId).append("&vcode=").append(vcode).append(TIMESTAMP_STR).append(timeMillis).append("&phone=").append(phone).append(SIGNITURE_STR).append(signiture);
            }
            String returnValue = HttpClientUtils.get((String)url.toString());
            logger.info("verifyCloudCode : returnValue = " + returnValue);
            if (returnValue != null && returnValue.length() > 0) {
                result = (Map)JSONObject.parseObject((String)returnValue, Map.class);
            }
        }
        catch (Exception e) {
            logger.error("verifyCode error == " + e);
        }
        return result;
    }
}

