/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.util.RevProxyUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AgentUtil {
    private static final String USER_AGENT = "USER-AGENT";
    private static List<String> browserList = new ArrayList<String>();
    private static String PC = "0";
    private static String MOBILE = "1";

    private AgentUtil() {
    }

    public static boolean isMobile(HttpServletRequest request) {
        return MOBILE.equals(AgentUtil.getClienyId(request));
    }

    public static String getClienyId(HttpServletRequest request) {
        String clientId = PC;
        if (request != null && request.getHeader(USER_AGENT) != null) {
            String userAgent = request.getHeader(USER_AGENT).toLowerCase(Locale.ENGLISH);
            if (AgentUtil.isMobile(userAgent, browserList)) {
                clientId = MOBILE;
            } else {
                String[] customArray;
                String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
                String customAgent = SystemPropertyUtils.getProptyByTenant("custom_mobile_browser_agent", tenantId);
                if (StringUtils.isNotEmpty(customAgent) && AgentUtil.isMobile(userAgent, Arrays.asList(customArray = customAgent.trim().split(",")))) {
                    clientId = MOBILE;
                }
            }
        }
        return clientId;
    }

    private static boolean isMobile(String userAgent, List<String> bList) {
        boolean isMobile = false;
        if (userAgent != null && bList != null && bList.size() > 0) {
            for (int i = 0; i < bList.size(); ++i) {
                if (!userAgent.contains(bList.get(i))) continue;
                isMobile = true;
                break;
            }
        }
        return isMobile;
    }

    @SdkInternal
    public static LoginClientEnum getLoginClientEnumType(HttpServletRequest request) {
        LoginClientEnum returnType = LoginClientEnum.WEB;
        if (MOBILE.equals(AgentUtil.getClienyId(request))) {
            returnType = LoginClientEnum.MOBILE;
        }
        return returnType;
    }

    public static boolean getLoginIsByPhone(HttpServletRequest request) {
        String userAgent = request.getHeader(USER_AGENT);
        if (userAgent == null) {
            return false;
        }
        userAgent = userAgent.replaceAll("(^|;|\\s*)deviceName\\s*:[^;]*(;|$)", ";");
        return (userAgent = userAgent.toLowerCase(Locale.ENGLISH)).contains("iphone") || userAgent.contains("android");
    }

    static {
        browserList.add("android");
        browserList.add("iphone");
        browserList.add("ipad");
        browserList.add("ipod");
        browserList.add("nokia");
        browserList.add("samsung");
        browserList.add("midp-2");
        browserList.add("cldc1.1");
        browserList.add("symbianos");
        browserList.add("maui");
        browserList.add("untrusted/1.0");
        browserList.add("windows ce");
        browserList.add("blackberry");
        browserList.add("ucweb");
        browserList.add("brew");
        browserList.add("j2me");
        browserList.add("yulong");
        browserList.add("coolpad");
        browserList.add("tianyu");
        browserList.add("ty-");
        browserList.add("k-touch");
        browserList.add("haier");
        browserList.add("dopod");
        browserList.add("lenovo");
        browserList.add("mobile");
        browserList.add("huaqin");
        browserList.add("aigo-");
        browserList.add("ctc/1.0");
        browserList.add("ctc/2.0");
        browserList.add("cmcc");
        browserList.add("daxian");
        browserList.add("mot-");
        browserList.add("sonyericsson");
        browserList.add("gionee");
        browserList.add("htc");
        browserList.add("zte");
        browserList.add("huawei");
        browserList.add("webos");
        browserList.add("gobrowser");
        browserList.add("iemobile");
        browserList.add("wap2.0");
        browserList.add("ucbrowser");
        browserList.add("mi 6 build");
        browserList.add("vivo");
        browserList.add("symbianos");
        browserList.add("nokia5700");
    }
}

