/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SecurityUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static Log logger = LogFactory.getLog(HttpClientUtils.class);

    public static String post(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        String data = "";
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpClientParams.setCookiePolicy((HttpParams)client.getParams(), (String)"compatibility");
        HttpPost post = new HttpPost(url);
        try {
            HttpResponse response;
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (body != null && body.size() != 0) {
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(body.size());
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    params.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
                post.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = response.getEntity();
                Header header2 = httpEntity.getContentEncoding();
                if (header2 != null && ("gzip".equalsIgnoreCase(header2.getValue()) || "x-gzip".equalsIgnoreCase(header2.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(httpEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpClientUtils.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)httpEntity);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFormData(String url, Map<String, String> headers, List<FormDataEntity> formDatas) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpPost httppost = new HttpPost(url);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httppost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            InputStream in = null;
            try {
                MultipartEntity reqEntity = new MultipartEntity();
                if (formDatas != null && !formDatas.isEmpty()) {
                    for (FormDataEntity e : formDatas) {
                        in = e.getValueInputStream();
                        if (in != null) {
                            reqEntity.addPart(e.getKey(), (ContentBody)new InputStreamBody(in, e.getFileName()));
                            continue;
                        }
                        reqEntity.addPart(e.getKey(), (ContentBody)new StringBody(e.getValueString()));
                    }
                }
                httppost.setEntity((HttpEntity)reqEntity);
                HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    HttpEntity resEntity = response.getEntity();
                    String result = EntityUtils.toString((HttpEntity)resEntity);
                    EntityUtils.consume((HttpEntity)resEntity);
                    String string = result;
                    return string;
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                    }
                }
            }
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHTMLContent(InputStream in) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File download(String url, String filePath) {
        File file = null;
        if (filePath != null) {
            InputStream inputStream = null;
            FileOutputStream fileout = null;
            try {
                DefaultHttpClient client = new DefaultHttpClient();
                HttpGet httpget = new HttpGet(url);
                HttpResponse response = client.execute((HttpUriRequest)httpget);
                HttpEntity entity = response.getEntity();
                inputStream = entity.getContent();
                file = new File(SecurityUtils.normalize(filePath));
                if (!file.exists() && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                fileout = new FileOutputStream(file);
                byte[] buffer = new byte[2048];
                int ch = 0;
                while ((ch = inputStream.read(buffer)) != -1) {
                    fileout.write(buffer, 0, ch);
                }
                inputStream.close();
                fileout.flush();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                }
                if (fileout != null) {
                    try {
                        fileout.close();
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                }
            }
        }
        return file;
    }

    public static class FormDataEntity {
        private String key;
        private String valueString;
        private InputStream valueInputStream;
        private String fileName;

        public FormDataEntity(String key, String value) {
            this.key = key;
            this.valueString = value;
        }

        public FormDataEntity(String key, InputStream value, String fileName) {
            this.key = key;
            this.valueInputStream = value;
            this.fileName = fileName;
        }

        public String getKey() {
            return this.key;
        }

        public String getValueString() {
            return this.valueString;
        }

        public InputStream getValueInputStream() {
            return this.valueInputStream;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

