/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;
import org.apache.log4j.Logger;

public class HttpUtils {
    private static final String UTF_8 = "UTF-8";
    private static Logger logger = Logger.getLogger(HttpUtils.class);

    public static String request(String url) {
        return HttpUtils.request(url, "GET");
    }

    public static String request(String url, boolean replaceSpace) {
        return HttpUtils.request(url, "GET", null, replaceSpace);
    }

    public static String request(String url, String requestType) {
        return HttpUtils.request(url, requestType, null);
    }

    public static String request(String url, String requestType, Map<String, String> header) {
        return HttpUtils.request(url, requestType, header, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String url, String requestType, Map<String, String> header, boolean replaceSpace) {
        if (StringUtils.isEmpty(url)) {
            throw new IllegalArgumentException("request url can't be null");
        }
        StringBuilder sb = new StringBuilder();
        BufferedInputStream reader = null;
        try {
            InputStream raw;
            URL httpUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
            connection.setRequestMethod(requestType.toUpperCase());
            if (header != null) {
                for (Map.Entry<String, String> item : header.entrySet()) {
                    connection.setRequestProperty(item.getKey(), item.getValue());
                }
            }
            if (connection != null && (raw = connection.getInputStream()) != null) {
                reader = new BufferedInputStream(raw);
                byte[] buffer = new byte[1024];
                String encoding = connection.getContentEncoding();
                if (StringUtils.isEmpty(encoding)) {
                    encoding = UTF_8;
                } else {
                    boolean support = Charset.isSupported(encoding);
                    if (!support) {
                        encoding = UTF_8;
                    }
                }
                Charset charset = Charset.forName(encoding);
                int size = 0;
                while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                    if (size <= 0) continue;
                    sb.append(new String(buffer, 0, size, charset));
                }
                String result = sb.toString();
                String string = replaceSpace && result.indexOf(10) != -1 ? result.replaceAll("\\s*|\t|\r|\n", StringUtils.getEmpty()) : result;
                return string;
            }
        }
        catch (IOException e) {
            logger.error((Object)"request\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error((Object)"\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return StringUtils.getEmpty();
    }

    public static String post(String url) {
        return HttpUtils.request(url, "POST");
    }

    public static String post(String url, Map<String, String> header) {
        return HttpUtils.request(url, "POST", header);
    }

    public static String post(String url, Map<String, String> header, String argument) {
        return HttpUtils.post(url, header, argument, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> header, String argument, boolean replaceSpace) {
        if (StringUtils.isEmpty(url)) {
            throw new IllegalArgumentException("post url can't be null");
        }
        StringBuilder sb = new StringBuilder();
        OutputStream write = null;
        BufferedInputStream reader = null;
        try {
            InputStream raw;
            URL httpUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
            connection.setRequestMethod("POST");
            if (header != null) {
                for (Map.Entry<String, String> item : header.entrySet()) {
                    connection.setRequestProperty(item.getKey(), item.getValue());
                }
            }
            if (StringUtils.isNotEmpty(argument)) {
                connection.setDoOutput(true);
                write = connection.getOutputStream();
                if (write != null) {
                    write.write(argument.getBytes(UTF_8));
                }
            }
            if (connection != null && (raw = connection.getInputStream()) != null) {
                reader = new BufferedInputStream(raw);
                byte[] buffer = new byte[1024];
                String encoding = connection.getContentEncoding();
                if (StringUtils.isEmpty(encoding)) {
                    encoding = UTF_8;
                } else {
                    boolean support = Charset.isSupported(encoding);
                    if (!support) {
                        encoding = UTF_8;
                    }
                }
                Charset charset = Charset.forName(encoding);
                int size = 0;
                while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                    if (size <= 0) continue;
                    sb.append(new String(buffer, 0, size, charset));
                }
                String result = sb.toString();
                String string = replaceSpace && result.indexOf(10) != -1 ? result.replaceAll("\\s*|\t|\r|\n", StringUtils.getEmpty()) : result;
                return string;
            }
        }
        catch (IOException e) {
            logger.error((Object)"post\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (write != null) {
                try {
                    write.close();
                }
                catch (IOException e) {
                    logger.error((Object)"post output close\u5f02\u5e38", (Throwable)e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error((Object)"post output close\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return StringUtils.getEmpty();
    }

    public static void webAlert(HttpServletResponse response, String sMsg) {
        try {
            response.setHeader("Content-type", "text/html;charset=UTF-8");
            response.setCharacterEncoding(UTF_8);
            PrintWriter writer = response.getWriter();
            writer.write("<html><body>" + sMsg + "</body></html>");
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            logger.error((Object)"webAlert", (Throwable)ex);
        }
    }

    public static void webAlertNoHeader(HttpServletResponse response, String sMsg) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8");){
            writer.write("<html><body>" + sMsg + "</body></html>");
            writer.flush();
        }
        catch (IOException ex) {
            logger.error((Object)"webAlertNoHeader", (Throwable)ex);
        }
    }

    public static void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        String requestType = request.getHeader("x-requested-with");
        String isAjax = request.getHeader("ajax");
        if ("XMLHttpRequest".equals(requestType) || "true".equals(isAjax)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("errorcode", 0);
            map.put("RedirectURL", url);
            String result = JSONUtils.toString(map);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
        } else if (LoginUtils.isSelfEnvironment(url, request, response)) {
            response.sendRedirect(url);
        }
    }

    public static String getBody(HttpServletRequest request) {
        String returnBody = "";
        if (request != null) {
            try {
                int read;
                int e = request.getContentLength();
                byte[] bytes = new byte[e];
                int left = bytes.length;
                int begin = 0;
                while ((read = request.getInputStream().read(bytes, begin, left)) >= 0) {
                    begin += read;
                    if ((left -= read) != 0) continue;
                }
                returnBody = new String(bytes, UTF_8);
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.apiIO, new Object[]{e.getMessage()});
            }
        }
        return returnBody;
    }
}

