/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.login.utils.StringUtils;

public class JWTUtils {
    private static final String JWT_SUBJECT = "kdjwt";
    private static final String JWT_ID = "kd";

    public static String generateJWTByMapParameters(Map<String, String> parameters, String key, long expireTime) {
        String jwtString = "";
        if (parameters != null && parameters.size() > 0 && StringUtils.isNotEmpty(key)) {
            Algorithm algorithm = Algorithm.HMAC256((String)key);
            JWTCreator.Builder builder = JWT.create().withSubject(JWT_SUBJECT).withIssuer(JWT_ID).withIssuedAt(new Date()).withExpiresAt(new Date(expireTime));
            for (String parameter : parameters.keySet()) {
                builder = builder.withClaim(parameter, parameters.get(parameter));
            }
            jwtString = builder.sign(algorithm);
        }
        return jwtString;
    }

    public static String generateRSAJWTByMapParameters(Map<String, String> parameters, Key key, long expireTime) {
        String jwtString = "";
        if (parameters != null && parameters.size() > 0 && key != null) {
            Algorithm algorithm = Algorithm.RSA512(null, (RSAPrivateKey)((RSAPrivateKey)key));
            JWTCreator.Builder builder = JWT.create().withSubject(JWT_SUBJECT).withIssuer(JWT_ID).withIssuedAt(new Date()).withExpiresAt(new Date(expireTime));
            for (String parameter : parameters.keySet()) {
                builder = builder.withClaim(parameter, parameters.get(parameter));
            }
            jwtString = builder.sign(algorithm);
        }
        return jwtString;
    }

    public static Map<String, String> getJWTClaimsByPublicKey(Key key, String jwtString) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (key != null && StringUtils.isNotEmpty(jwtString)) {
            Algorithm algorithm = Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)key), null);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(new String[]{JWT_ID}).build();
            DecodedJWT jwt = verifier.verify(jwtString);
            for (String ckey : jwt.getClaims().keySet()) {
                returnMap.put(ckey, jwt.getClaim(ckey).asString());
            }
        }
        return returnMap;
    }

    public static Map<String, String> getJWTClaimsByKey(String key, String jwtString) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (key != null && StringUtils.isNotEmpty(jwtString)) {
            Algorithm algorithm = Algorithm.HMAC256((String)key);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(new String[]{JWT_ID}).build();
            DecodedJWT jwt = verifier.verify(jwtString);
            for (String ckey : jwt.getClaims().keySet()) {
                returnMap.put(ckey, jwt.getClaim(ckey).asString());
            }
        }
        return returnMap;
    }
}

