/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public class LoginAccountUtils {
    public static Log logger = LogFactory.getLog(LoginAccountUtils.class);

    public static List<Account> getAccounts(HttpServletRequest request) {
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        List centerList = AccountUtils.getAllAccounts((String)tenantAlias);
        if (centerList == null || centerList.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> clientCenterList = LoginAccountUtils.getClientCenterList(request);
        if (!clientCenterList.isEmpty()) {
            return centerList.stream().filter(v -> clientCenterList.contains(v.getAccountId())).collect(Collectors.toList());
        }
        String url = LoginAccountUtils.removeHttpFromURL(LoginAccountUtils.getDomainContext(request, tenantAlias));
        if (url == null) {
            return centerList;
        }
        for (int i = 0; i < centerList.size(); ++i) {
            Account account = (Account)centerList.get(i);
            if (!StringUtils.isNotBlank((CharSequence)account.getDocDomain()) || url.startsWith(account.getDocDomain())) continue;
            centerList.remove(i);
        }
        return centerList;
    }

    public static List<Account> getAccountsFromNg(HttpServletRequest request) {
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        List centerList = AccountUtils.getAllAccounts((String)tenantAlias);
        if (centerList == null || centerList.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> clientCenterList = LoginAccountUtils.getClientCenterList(request);
        if (!clientCenterList.isEmpty()) {
            return centerList.stream().filter(v -> clientCenterList.contains(v.getAccountId())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static String removeHttpFromURL(String url) {
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            if (url.trim().toLowerCase(Locale.ENGLISH).startsWith("http://")) {
                return url.substring(7, url.trim().length());
            }
            if (url.trim().toLowerCase(Locale.ENGLISH).startsWith("https://")) {
                return url.substring(8, url.trim().length());
            }
        }
        return "";
    }

    private static String getDomainContext(HttpServletRequest request, String tenantAlias) {
        String returnValue = request.getHeader("clientDomain");
        if (StringUtils.isEmpty((CharSequence)returnValue)) {
            returnValue = UrlService.getDomainContextUrlByTenantCode((String)tenantAlias);
        }
        return returnValue;
    }

    private static List<String> getClientCenterList(HttpServletRequest request) {
        String centerHeader = request.getHeader("client_account_ids");
        if (StringUtils.isBlank((CharSequence)centerHeader)) {
            return Collections.emptyList();
        }
        return Arrays.asList(centerHeader.split(","));
    }

    public static Account getAccountByParam(HttpServletRequest request, String tenantId) {
        try {
            String accountIdParameter = request.getParameter("accountId");
            if (StringUtils.isNotBlank((CharSequence)accountIdParameter)) {
                Account account = AccountUtils.getCorrectAccount((String)accountIdParameter, (String)tenantId);
                return account;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return null;
    }
}

