/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.util.Map;
import kd.bos.dc.api.model.Account;
import kd.bos.login.user.ConfigureationService;
import kd.bos.login.utils.LocalCacheUtils;
import kd.bos.login.utils.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ParametersUtils {
    private static final String COMMON_PARAMETERS = "_commonparameters";
    private static final String USER_KEYS = "_USER_";

    public static String getCommonStringParameters(Account currentCenter, String key) {
        String returnValue = null;
        Map<String, Object> yzjMap = ParametersUtils.getCommonParameters(currentCenter);
        if (yzjMap != null && yzjMap.get(key) instanceof String) {
            returnValue = (String)yzjMap.get(key);
        }
        return returnValue;
    }

    @SdkInternal
    public static Map<String, Object> getCommonParameters(Account currentCenter) {
        Map<String, Object> yzjMap = null;
        Object listObj = LocalCacheUtils.get(currentCenter.getAccountId() + COMMON_PARAMETERS);
        if (listObj != null) {
            yzjMap = (Map<String, Object>)listObj;
        } else {
            yzjMap = ConfigureationService.getCommonParameters(currentCenter);
            LocalCacheUtils.put(currentCenter.getAccountId() + COMMON_PARAMETERS, yzjMap);
        }
        return yzjMap;
    }

    public static String getCommonParameters(Account currentCenter, String key) {
        Map<String, Object> commonParameters = ParametersUtils.getCommonParameters(currentCenter);
        if (commonParameters != null && commonParameters.get(key) != null) {
            return String.valueOf(commonParameters.get(key));
        }
        return null;
    }

    public static boolean getBooleanParameters(Account currentCenter, String key) {
        String param = ParametersUtils.getCommonParameters(currentCenter, key);
        return Boolean.parseBoolean(param) || "1".equals(param);
    }

    public static Map<String, String> getUserInfoBykey(Account currentCenter, String userKey) {
        Object listObj;
        Map returnMap = null;
        if (currentCenter != null && StringUtils.isNotEmpty(userKey) && (listObj = LocalCacheUtils.get(ParametersUtils.getUserCacheKey(currentCenter, userKey))) != null) {
            returnMap = (Map)listObj;
        }
        return returnMap;
    }

    private static String getUserCacheKey(Account currentCenter, String userKey) {
        return currentCenter.getAccountId() + USER_KEYS + userKey;
    }

    public static void putUserInfoBykey(Account currentCenter, String userKey, Map<String, String> map) {
        LocalCacheUtils.put(ParametersUtils.getUserCacheKey(currentCenter, userKey), map);
    }

    public static void removeUserInfoBykey(Account currentCenter, String userKey) {
        LocalCacheUtils.remove(ParametersUtils.getUserCacheKey(currentCenter, userKey));
    }
}

