/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

@SdkPublic
public class RSAUtils {
    private static final String BOS_LOGIN = "bos-login";
    private static final String RSA_UTILS_1 = "RSAUtils_1";
    private static final String RSA_UTILS_2 = "RSAUtils_2";
    private static final String RSA_UTILS_9 = "RSAUtils_9";
    private static final String RSA_ECB_PCKCS1_PADDING = "RSA/ECB/PKCS1Padding";
    private static final String RSA_ECB_OAEP_PADDING = "RSA/ECB/OAEPPadding";
    private static final Logger logger = Logger.getLogger(RSAUtils.class);
    private static final ErrorCode ENCRYPT_Exception = RSAUtils.bosException("EncryptException", "%s");
    private static ThreadLocal<Boolean> OAEPContext = new ThreadLocal();
    private static Provider provider = new BouncyCastleProvider();

    private static final ErrorCode bosException(String errorCode, String message) {
        return new ErrorCode("bos." + errorCode, message);
    }

    public static void setOAEP(Boolean isTrue) {
        OAEPContext.set(isTrue);
    }

    public static boolean isOAEP() {
        boolean isOAEP = false;
        if (OAEPContext.get() != null) {
            isOAEP = OAEPContext.get();
        }
        return isOAEP;
    }

    public static KeyPair generateKeyPair() {
        try {
            SecureRandom random = new SecureRandom();
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", provider);
            Integer length = 2048;
            if (RequestContext.get() != null) {
                length = SystemPropertyUtils.getInteger(RequestContext.get().getTenantId(), "rsa_generatekeypair_length", length);
            }
            generator.initialize(length, random);
            return generator.generateKeyPair();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u751f\u6210keypair\u9519\u8bef ", (String)"RSAUtils_0", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static String generateBase64PublicKey(KeyPair keyPair) throws KDException {
        if (keyPair == null) {
            throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570KeyPair\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)RSA_UTILS_1, (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        return new String(Base64.encodeBase64((byte[])publicKey.getEncoded()));
    }

    public static String generateBase64Key(byte[] keys) throws KDException {
        if (keys == null) {
            throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570keys\u4e0d\u80fd\u4e3a\u7a7a", (String)RSA_UTILS_2, (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        return new String(Base64.encodeBase64((byte[])keys));
    }

    public static String decryptBase64(String string, KeyPair keyPair) {
        return new String(RSAUtils.decryptByPrivateKey(keyPair, Base64.decodeBase64((byte[])string.getBytes())));
    }

    private static byte[] decryptByPrivateKey(KeyPair keyPair, byte[] byteArray) {
        try {
            if (keyPair == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570KeyPair\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)RSA_UTILS_1, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSAUtils.getRSAPadding(), provider);
            PrivateKey privateKey = keyPair.getPrivate();
            cipher.init(2, privateKey);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"decryptByPrivateKey\u9519\u8bef", (String)"RSAUtils_3", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    private static String getRSAPadding() {
        if (RSAUtils.isOAEP()) {
            return RSA_ECB_OAEP_PADDING;
        }
        return RSA_ECB_PCKCS1_PADDING;
    }

    public static byte[] decryptByKey(Key keys, byte[] byteArray) {
        try {
            if (keys == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570keys\u4e0d\u80fd\u4e3a\u7a7a", (String)RSA_UTILS_2, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSAUtils.getRSAPadding(), provider);
            cipher.init(2, keys);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"decryptByKey\u9519\u8bef", (String)"RSAUtils_4", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    private static byte[] decryptByPrivateKey(byte[] keys, byte[] byteArray) {
        try {
            if (keys == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570keys\u4e0d\u80fd\u4e3a\u7a7a", (String)RSA_UTILS_2, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSAUtils.getRSAPadding(), provider);
            PrivateKey privateKey = RSAUtils.getPrivateKey(keys);
            cipher.init(2, privateKey);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"decryptByPrivateKey\u9519\u8bef", (String)"RSAUtils_3", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static byte[] encryptByPublickKey(KeyPair keyPair, byte[] byteArray) {
        try {
            if (keyPair == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570KeyPair\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)RSA_UTILS_1, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSAUtils.getRSAPadding(), provider);
            PublicKey publicKey = keyPair.getPublic();
            cipher.init(1, publicKey);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"encryptByPublickKey\u9519\u8bef", (String)"RSAUtils_5", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static byte[] encryptByPrivateKey(KeyPair keyPair, byte[] byteArray) {
        try {
            if (keyPair == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570KeyPair\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)RSA_UTILS_1, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSAUtils.getRSAPadding(), provider);
            PrivateKey privateKey = keyPair.getPrivate();
            cipher.init(1, privateKey);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"encryptByPrivateKey\u9519\u8bef", (String)"RSAUtils_6", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static byte[] encryptByKey(Key keys, byte[] byteArray) {
        try {
            if (keys == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570keys\u4e0d\u80fd\u4e3a\u7a7a", (String)RSA_UTILS_2, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSAUtils.getRSAPadding(), provider);
            cipher.init(1, keys);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"encryptByKey\u9519\u8bef", (String)"RSAUtils_7", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static byte[] encryptByPrivateKey(byte[] keys, byte[] byteArray) {
        try {
            if (keys == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570keys\u4e0d\u80fd\u4e3a\u7a7a", (String)RSA_UTILS_2, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSAUtils.getRSAPadding(), provider);
            cipher.init(1, RSAUtils.getPrivateKey(keys));
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"encryptByprivateKey\u9519\u8bef", (String)"RSAUtils_8", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PublicKey getPublicKey(String key) throws KDException {
        try {
            if (key == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a", (String)RSA_UTILS_9, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            byte[] keyBytes = key.getBytes();
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"getPublicKey\u9519\u8bef", (String)"RSAUtils_10", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PublicKey getPublicKey(byte[] keyBytes) throws KDException {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"getPublicKey\u9519\u8bef", (String)"RSAUtils_10", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PublicKey getPublicKeyBase64(String key) throws KDException {
        try {
            if (key == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a", (String)RSA_UTILS_9, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            byte[] keyBytes = Base64.decodeBase64((String)key);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"getPublicKeyBase64\u9519\u8bef", (String)"RSAUtils_11", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PrivateKey getPrivateKey(String key) throws KDException {
        try {
            byte[] keyBytes = Base64.decodeBase64((String)key);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"getPrivateKey\u9519\u8bef", (String)"RSAUtils_12", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PrivateKey getPrivateKey(byte[] keyBytes) throws KDException {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"getPrivateKey\u9519\u8bef", (String)"RSAUtils_12", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PrivateKey getPrivateKeyBase64(String key) throws KDException {
        PrivateKey privateKey = null;
        try {
            if (key == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a", (String)RSA_UTILS_9, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            byte[] keyBytes = Base64.decodeBase64((String)key);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"getPrivateKeyBase64\u9519\u8bef", (String)"RSAUtils_13", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static byte[] decryptByKey(Key keys, byte[] byteArray, String rsaPadding) {
        try {
            if (keys == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570keys\u4e0d\u80fd\u4e3a\u7a7a", (String)RSA_UTILS_2, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSAUtils.getRSAPadding(rsaPadding), provider);
            cipher.init(2, keys);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{ResManager.loadKDString((String)"decryptByKey\u9519\u8bef", (String)"RSAUtils_4", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    private static String getRSAPadding(String rsaPadding) {
        if ("oaep".equals(rsaPadding)) {
            return RSA_ECB_OAEP_PADDING;
        }
        return RSA_ECB_PCKCS1_PADDING;
    }

    static {
        Security.addProvider(provider);
    }
}

