/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.HtmlUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.io.FilenameUtils;

public class SecurityUtils {
    private static Log logger = LogFactory.getLog(SecurityUtils.class);

    public static boolean isOrgString(String orgIds) {
        boolean isCorrect = true;
        if (StringUtils.isNotEmpty((String)orgIds)) {
            String[] orgList = orgIds.split(",");
            for (int i = 0; i < orgList.length; ++i) {
                if (StringUtils.isNumeric((String)orgList[i])) continue;
                isCorrect = false;
            }
        }
        return isCorrect;
    }

    public static boolean containsSqlInjection(String obj) {
        boolean isInjected = false;
        if (StringUtils.isNotEmpty((String)obj)) {
            Pattern pattern = Pattern.compile("\\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|;|\\+|'|%)");
            Matcher matcher = pattern.matcher(obj);
            isInjected = matcher.find();
        }
        return isInjected;
    }

    public static String htmlEncode(String htmlStr) {
        String[] arr = "&@<@>@\"@'@/".split("@");
        String[] code = "&amp;@&lt;@&gt;@&quot;@&#x27;@&#x2F;".split("@");
        String returnValue = htmlStr;
        try {
            if (StringUtils.isNotEmpty((String)htmlStr)) {
                for (int i = 0; i < arr.length; ++i) {
                    returnValue = returnValue.replaceAll(arr[i], code[i]);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return returnValue;
    }

    public static String normalize(String fileName) {
        String returnString = fileName;
        if (fileName != null) {
            returnString = fileName.replace("../", "#");
            returnString = returnString.replace("..\\", "#");
        }
        returnString = FilenameUtils.normalize((String)returnString);
        return returnString;
    }

    public static boolean checkXss(String param) {
        String filterCharacter = "javascript,vbscript";
        String[] filterArray = filterCharacter.split(",");
        if (StringUtils.isNotEmpty((String)param)) {
            for (String character : filterArray) {
                if (!param.toLowerCase(Locale.ENGLISH).startsWith(character)) continue;
                return true;
            }
        }
        return false;
    }

    public static String replaceCrlf(String value) {
        String result = value;
        String[] crlfStr = "\n,\r,%0A".split(",");
        if (StringUtils.isEmpty((String)value)) {
            return result;
        }
        for (int i = 0; i < crlfStr.length; ++i) {
            result = result.replaceAll(crlfStr[i], " ");
        }
        return result;
    }

    public static void checkCsrf(HttpServletRequest request, HttpServletResponse response, String msg) throws IOException {
        if (request.getRequestURI().endsWith(".do")) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("RedirectURL", "index.html");
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSONUtils.toString(map));
        } else {
            LoginUtils.outputString(response, HtmlUtils.getCsrfHtml(request, response, msg));
        }
    }
}

