/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.sdk.annotation.SdkInternal;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.prng.SP800SecureRandom;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;

public class StringUtils {
    private static Log logger = LogFactory.getLog(StringUtils.class);
    private static String[] fbsArr = new String[]{"\"", "'", "&", "<", ">"};
    private static String[] randomNumberArr = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static String[] randomWordArr = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String ALGORITHM_RANDOM = "NativePRNGNonBlocking";

    @SdkInternal
    public static boolean isEmpty(String string) {
        return StringUtils.isNull(string) || StringUtils.isBlank(string);
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isEmpty(string) && !"null".equalsIgnoreCase(string);
    }

    public static String getEmpty() {
        return "";
    }

    public static String getDefualtEmptyString(String param) {
        String returnValue = "";
        if (param != null) {
            returnValue = param;
        }
        return returnValue;
    }

    public static boolean isNull(String string) {
        return string == null;
    }

    public static boolean isNotNull(String string) {
        return !StringUtils.isNull(string);
    }

    public static boolean isBlank(String string) {
        return StringUtils.isNotNull(string) && string.trim().length() == 0;
    }

    public static String trim(String string) {
        if (StringUtils.isNull(string)) {
            return StringUtils.getEmpty();
        }
        return string.trim();
    }

    private static String randomWord(boolean randomIndicator, int min, int max) {
        return kd.bos.util.StringUtils.randomWord((int)min);
    }

    public static String randomWord(int min) {
        return StringUtils.randomWord(false, min, min);
    }

    private static String randomNumber(boolean randomIndicator, int min, int max) {
        return kd.bos.util.StringUtils.randomNumber((int)min);
    }

    public static String randomNumber(int min) {
        return StringUtils.randomNumber(false, min, min);
    }

    public static boolean getBooleanValue(String value) {
        boolean returnValue = false;
        if (Constants.YES.equals(value)) {
            returnValue = true;
        } else if ("true".equalsIgnoreCase(value)) {
            returnValue = true;
        }
        return returnValue;
    }

    public static String getStringValue(Object StringObj) {
        String returnString = null;
        if (StringObj instanceof String) {
            returnString = (String)StringObj;
        } else if (StringObj != null) {
            returnString = String.valueOf(StringObj);
        }
        return returnString;
    }

    public static String getStringValue(Object StringObj, String defaultValue) {
        String returnString = defaultValue;
        if (StringObj instanceof String) {
            returnString = (String)StringObj;
        } else if (StringObj != null) {
            returnString = String.valueOf(StringObj);
        }
        return returnString;
    }

    public static String escapeExprSpecialWord(String keyword) {
        if (StringUtils.isNotEmpty(keyword)) {
            keyword = keyword.replace("&", "&amp");
            String[] stringArray = fbsArr;
            int n = stringArray.length;
            block12: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "\"": {
                        keyword = keyword.replace(key, "&quot");
                        continue block12;
                    }
                    case "'": {
                        keyword = keyword.replace(key, "&apos");
                        continue block12;
                    }
                    case "<": {
                        keyword = keyword.replace(key, "&lt");
                        continue block12;
                    }
                    case ">": {
                        keyword = keyword.replace(key, "&gt");
                        continue block12;
                    }
                }
            }
        }
        return keyword;
    }

    public static String getPathString(String path) {
        String returnString = path;
        if (!StringUtils.isEmpty(path) && !path.endsWith("/")) {
            returnString = returnString + "/";
        }
        return returnString;
    }

    public static String getTrimedBlank(String value) {
        String returnVal = value;
        if (StringUtils.isNotEmpty(value)) {
            returnVal = value.trim();
        }
        return returnVal;
    }

    public static SecureRandom getRandom() {
        String blockSecureRandom = "";
        if (RequestContext.get() != null) {
            blockSecureRandom = SystemPropertyUtils.getProptyByTenant("enable_block_securerandom", RequestContext.get().getTenantId());
        }
        if ("true".equalsIgnoreCase(blockSecureRandom)) {
            return StringUtils.getBlockSecureRandom();
        }
        return StringUtils.getSecureRandom();
    }

    private static SecureRandom getBlockSecureRandom() {
        try {
            SecureRandom blockSecureRandom = SecureRandom.getInstanceStrong();
            if (null == blockSecureRandom) {
                return StringUtils.getSecureRandom();
            }
            AESEngine cipher = new AESEngine();
            boolean predictionResistant = true;
            int keySizeInBits = 256;
            int entropyBitsRequired = 384;
            boolean reSeedOnEachRequest = false;
            byte[] nonce = new byte[32];
            blockSecureRandom.nextBytes(nonce);
            SP800SecureRandom random = new SP800SecureRandomBuilder(blockSecureRandom, true).setEntropyBitsRequired(384).buildCTR((BlockCipher)cipher, 256, nonce, false);
            random.nextInt();
            return random;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return StringUtils.getSecureRandom();
        }
    }

    private static SecureRandom getSecureRandom() {
        SecureRandom secRandom = null;
        try {
            secRandom = SecureRandom.getInstance(ALGORITHM_RANDOM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (secRandom == null) {
            secRandom = new SecureRandom();
        }
        return secRandom;
    }
}

