/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;

public class ValidationUtils {
    private static Log logger = LogFactory.getLog(ValidationUtils.class);

    public static boolean isPhone(String phone) {
        boolean isPhone = ValidationUtils.isChinaMobile(phone);
        if (!isPhone) {
            isPhone = ValidationUtils.isGloalMobile(phone);
        }
        return isPhone;
    }

    private static boolean isGloalMobile(String phone) {
        String regex = "^(\\d{1,6})\\-\\d{6,20}$";
        boolean isPhone = false;
        if (StringUtils.isNotEmpty(phone)) {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(phone);
            isPhone = m.matches();
        }
        return isPhone;
    }

    private static boolean isChinaMobile(String phone) {
        String regex = "^((13[0-9])|(14[0-9])|(15([0-9]))|(16[0-9])|(17[0-9])|(18[0-9])|(19[0-9]))\\d{8}$";
        boolean isPhone = false;
        if (phone != null && phone.length() == 11) {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(phone);
            isPhone = m.matches();
        }
        return isPhone;
    }

    public static boolean isEmail(String email) {
        boolean isEmail = false;
        if (email != null && email.contains("@")) {
            isEmail = true;
        }
        return isEmail;
    }
}

