/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.login.utils.StringUtils;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKUtils {
    private static final String ERROR = "error";
    private static final String ZK_UTILS_0 = "ZKUtils_0";
    private static final String BOS_LOGIN = "bos-login";
    private static final String UTF_8 = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(ZKUtils.class);

    public static void setZkData(String zkUrl, String key, String value) {
        try {
            if (StringUtils.isEmpty(zkUrl) || StringUtils.isEmpty(key)) {
                throw new KDException(new ErrorCode(ERROR, ResManager.loadKDString((String)"zkUrl\u548ckey\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)ZK_UTILS_0, (String)BOS_LOGIN, (Object[])new Object[0])), new Object[0]);
            }
            CuratorFramework zkClient = ZKFactory.getZKClient((String)zkUrl);
            if (zkClient.checkExists().forPath(key) == null) {
                ((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value == null ? null : value.getBytes(UTF_8));
            } else {
                zkClient.setData().forPath(key, value == null ? null : value.getBytes(UTF_8));
            }
        }
        catch (Exception e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
    }

    public static String getZkData(String zkUrl, String key) {
        try {
            if (StringUtils.isEmpty(zkUrl) || StringUtils.isEmpty(key)) {
                throw new KDException(new ErrorCode(ERROR, ResManager.loadKDString((String)"zkUrl\u548ckey\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)ZK_UTILS_0, (String)BOS_LOGIN, (Object[])new Object[0])), new Object[]{ResManager.loadKDString((String)"zkUrl\u548ckey\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)ZK_UTILS_0, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            CuratorFramework zkClient = ZKFactory.getZKClient((String)zkUrl);
            byte[] bytes = (byte[])zkClient.getData().forPath(key);
            return new String(bytes, UTF_8);
        }
        catch (Exception e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
    }

    public static void deleteZkKey(String zkUrl, String key) {
        try {
            if (StringUtils.isEmpty(zkUrl) || StringUtils.isEmpty(key)) {
                throw new KDException(new ErrorCode(ERROR, ResManager.loadKDString((String)"zkUrl\u548ckey\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)ZK_UTILS_0, (String)BOS_LOGIN, (Object[])new Object[0])), new Object[]{ResManager.loadKDString((String)"zkUrl\u548ckey\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)ZK_UTILS_0, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            CuratorFramework zkClient = ZKFactory.getZKClient((String)zkUrl);
            zkClient.delete().deletingChildrenIfNeeded().forPath(key);
        }
        catch (Exception e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
    }
}

