/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils.account;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.api.ApiRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public interface LoginAccount {
    public Account getAccount();

    public String getAccountId();

    public String getTenantId();

    public static class EidAccount
    extends AbstractLoginAccount {
        private String eid;

        public EidAccount(String eid) {
            super(null);
            this.eid = eid;
        }

        @Override
        public Account getAccount() {
            return AccountUtils.getAccountByEid((String)this.eid);
        }

        @Override
        public String getAccountId() {
            throw new RuntimeException("unrealized method!");
        }

        @Override
        protected String getTenantId0() {
            return null;
        }
    }

    public static class CustomAccount
    extends AbstractLoginAccount {
        private HttpServletRequest request;
        private String accountId;
        private boolean isCurEnvTenant;

        public CustomAccount(String accountId) {
            super(null);
            this.accountId = accountId;
            this.isCurEnvTenant = true;
        }

        public CustomAccount(String accountId, String tenantId) {
            super(tenantId);
            this.accountId = accountId;
        }

        public CustomAccount(String accountId, HttpServletRequest request) {
            super("");
            this.accountId = accountId;
            this.request = request;
        }

        @Override
        public String getAccountId() {
            return this.accountId;
        }

        @Override
        public Account getAccount() {
            if (this.isCurEnvTenant) {
                return AccountUtils.getAccountById((String)this.getAccountId());
            }
            return super.getAccount();
        }

        @Override
        protected String getTenantId0() {
            if (this.request == null) {
                throw new RuntimeException("Invalid parameter, 'CustomAccount' request is null.");
            }
            return RevProxyUtil.getTenantId((HttpServletRequest)this.request);
        }
    }

    public static class SessionAccount
    extends AbstractLoginAccount {
        private Map<String, String> sessionInfoMap;

        public SessionAccount(Map<String, String> sessionInfoMap, String tenantId) {
            super(tenantId);
            this.sessionInfoMap = sessionInfoMap;
        }

        public SessionAccount(SessionInfo sessionInfo, String tenantId) {
            this(sessionInfo.toMap(), tenantId);
        }

        public SessionAccount(String sessionId, String tenantId) {
            super(tenantId);
            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
            this.sessionInfoMap = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "accountId"});
        }

        @Override
        public String getAccountId() {
            return this.sessionInfoMap.get("accountId");
        }

        @Override
        public String getTenantId0() {
            return this.sessionInfoMap.get("tenantId");
        }
    }

    public static class RequestContextAccount
    extends AbstractLoginAccount {
        public RequestContextAccount(String tenantId) {
            super(tenantId);
        }

        @Override
        public String getAccountId() {
            return RequestContext.get().getAccountId();
        }

        @Override
        public String getTenantId0() {
            return RequestContext.get().getTenantId();
        }
    }

    public static class PostHttpRequestAccount
    extends HttpRequestAccount {
        private HttpServletResponse response;
        private Supplier<Boolean> checkFunc;

        public PostHttpRequestAccount(HttpServletRequest request, HttpServletResponse response, Supplier<Boolean> checkFunc) {
            super(request, "");
            this.response = response;
            this.checkFunc = checkFunc;
        }

        @Override
        public String getAccountId() {
            String accountId = super.getAccountId();
            if (StringUtils.isEmpty((CharSequence)accountId)) {
                accountId = this.getAccountIdWithPostData(this.request, this.response, this.checkFunc);
            }
            return accountId;
        }

        private String getAccountIdWithPostData(HttpServletRequest request, HttpServletResponse response, Supplier<Boolean> checkFunc) {
            if ("post".equalsIgnoreCase(request.getMethod()) && checkFunc.get().booleanValue() && !LoginUtils.isMultipart(request)) {
                ApiRequestContext ctx = ApiRequestContext.get();
                if (ctx == null) {
                    ApiRequestContext.initThreadLocal((HttpServletRequest)request, (HttpServletResponse)response);
                    ctx = ApiRequestContext.get();
                }
                try {
                    Map mapReq = (Map)ctx.getPostData(HashMap.class);
                    if (mapReq != null) {
                        return (String)mapReq.get("accountId");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return "";
        }
    }

    public static class HttpRequestAccount
    extends AbstractLoginAccount {
        protected HttpServletRequest request;
        protected boolean isLogin = false;

        public HttpRequestAccount(HttpServletRequest request, String tenantId) {
            super(tenantId);
            this.request = request;
        }

        public HttpRequestAccount(HttpServletRequest request, String tenantId, boolean isLogin) {
            super(tenantId);
            this.request = request;
            this.isLogin = isLogin;
        }

        @Override
        public String getAccountId() {
            String accountIdParameter = LoginUtils.getParamerter(this.request, "kdcdc");
            if (StringUtils.isEmpty((CharSequence)accountIdParameter)) {
                accountIdParameter = LoginUtils.getParamerter(this.request, "accountId");
            }
            if (StringUtils.isEmpty((CharSequence)accountIdParameter)) {
                accountIdParameter = LoginUtils.getParamerter(this.request, StringUtils.lowerCase((String)"accountId"));
            }
            if (StringUtils.isEmpty((CharSequence)accountIdParameter) && this.isLogin) {
                accountIdParameter = this.getSingleAccountIdFromNg();
            }
            return accountIdParameter;
        }

        private String getSingleAccountIdFromNg() {
            List<String> clientCenterList = this.getClientCenterList(this.request);
            if (clientCenterList.size() > 0) {
                return clientCenterList.get(0);
            }
            return null;
        }

        private List<String> getClientCenterList(HttpServletRequest request) {
            String centerHeader = request.getHeader("client_account_ids");
            if (StringUtils.isBlank((CharSequence)centerHeader)) {
                return Collections.emptyList();
            }
            return Arrays.asList(centerHeader.split(","));
        }

        @Override
        protected String getTenantId0() {
            return RevProxyUtil.getTenantCode((HttpServletRequest)this.request);
        }
    }

    public static class DefaultAccount
    extends AbstractLoginAccount {
        private HttpServletRequest request;
        private boolean isCurEnvTenant;

        public DefaultAccount() {
            super(null);
            this.isCurEnvTenant = true;
        }

        public DefaultAccount(HttpServletRequest request, String tenantId) {
            super(tenantId);
            this.request = request;
        }

        @Override
        public String getAccountId() {
            return "";
        }

        @Override
        protected String getTenantId0() {
            return RevProxyUtil.getTenantCode((HttpServletRequest)this.request);
        }

        public List<Account> getAccounts() {
            if (this.isCurEnvTenant) {
                return AccountUtils.getAllAccountsOfCurrentEnv();
            }
            return this.getNginxAccountsByTenant(this.getTenantId());
        }

        private List<Account> getNginxAccountsByTenant(String tenantAlias) {
            List centerList = AccountUtils.getAllAccounts((String)tenantAlias);
            if (centerList == null || centerList.isEmpty()) {
                return Collections.emptyList();
            }
            List<String> clientCenterList = this.getClientCenterList(this.request);
            if (!clientCenterList.isEmpty()) {
                return centerList.stream().filter(v -> clientCenterList.contains(v.getAccountId())).collect(Collectors.toList());
            }
            String url = this.removeHttpFromURL(this.getDomainContext(this.request, tenantAlias));
            if (url == null) {
                return centerList;
            }
            for (int i = 0; i < centerList.size(); ++i) {
                Account account = (Account)centerList.get(i);
                if (!StringUtils.isNotBlank((CharSequence)account.getDocDomain()) || url.startsWith(account.getDocDomain())) continue;
                centerList.remove(i);
            }
            return centerList;
        }

        private String removeHttpFromURL(String url) {
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                if (url.trim().toLowerCase(Locale.ENGLISH).startsWith("http://")) {
                    return url.substring(7, url.trim().length());
                }
                if (url.trim().toLowerCase(Locale.ENGLISH).startsWith("https://")) {
                    return url.substring(8, url.trim().length());
                }
            }
            return "";
        }

        private String getDomainContext(HttpServletRequest request, String tenantAlias) {
            String returnValue = request.getHeader("clientDomain");
            if (StringUtils.isEmpty((CharSequence)returnValue)) {
                returnValue = UrlService.getDomainContextUrlByTenantCode((String)tenantAlias);
            }
            return returnValue;
        }

        private List<String> getClientCenterList(HttpServletRequest request) {
            String centerHeader = request.getHeader("client_account_ids");
            if (StringUtils.isBlank((CharSequence)centerHeader)) {
                return Collections.emptyList();
            }
            return Arrays.asList(centerHeader.split(","));
        }
    }

    public static abstract class AbstractLoginAccount
    implements LoginAccount {
        protected String tenantId;

        public AbstractLoginAccount(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public Account getAccount() {
            return AccountUtils.getCorrectAccount((String)this.getAccountId(), (String)this.getTenantId());
        }

        @Override
        public String getTenantId() {
            String tenantIdTmp = StringUtils.isEmpty((CharSequence)this.tenantId) ? this.getTenantId0() : this.tenantId;
            return StringUtils.isEmpty((CharSequence)tenantIdTmp) ? "" : tenantIdTmp;
        }

        protected abstract String getTenantId0();
    }
}

