/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils.account;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.login.utils.account.LoginAccount;
import kd.bos.session.SessionInfo;

public class LoginAccountFactory {
    public static LoginAccount.DefaultAccount createInstanceByDefault(HttpServletRequest request) {
        return new LoginAccount.DefaultAccount(request, "");
    }

    public static LoginAccount.DefaultAccount createInstanceByDefault(String tenantId) {
        return new LoginAccount.DefaultAccount(null, tenantId);
    }

    public static LoginAccount.DefaultAccount createInstanceByDefault() {
        return new LoginAccount.DefaultAccount();
    }

    public static LoginAccount createInstanceByHttpRequest(HttpServletRequest request, Optional<String> tenantId) {
        return new LoginAccount.HttpRequestAccount(request, tenantId.orElse(""));
    }

    public static LoginAccount createInstanceByHttpRequest(HttpServletRequest request, Optional<String> tenantId, boolean isLogin) {
        return new LoginAccount.HttpRequestAccount(request, tenantId.orElse(""), isLogin);
    }

    public static LoginAccount createInstanceByPostRequest(HttpServletRequest request, HttpServletResponse response, Optional<Supplier<Boolean>> checkFunc) {
        return new LoginAccount.PostHttpRequestAccount(request, response, checkFunc.orElseGet(() -> () -> true));
    }

    public static LoginAccount createInstanceByRequestContext(Optional<String> tenantId) {
        return new LoginAccount.RequestContextAccount(tenantId.orElse(""));
    }

    public static LoginAccount createInstanceBySession(SessionInfo sessionInfo, Optional<String> tenantId) {
        return new LoginAccount.SessionAccount(sessionInfo, tenantId.orElse(""));
    }

    public static LoginAccount createInstanceBySession(Map<String, String> sessionInfoMap, Optional<String> tenantId) {
        return new LoginAccount.SessionAccount(sessionInfoMap, tenantId.orElse(""));
    }

    public static LoginAccount createInstanceBySession(String sessionId, Optional<String> tenantId) {
        return new LoginAccount.SessionAccount(sessionId, tenantId.orElse(""));
    }

    public static LoginAccount.CustomAccount createInstanceByCustom(String accountId) {
        return new LoginAccount.CustomAccount(accountId);
    }

    public static LoginAccount.CustomAccount createInstanceByCustom(String accountId, String tenantId) {
        return new LoginAccount.CustomAccount(accountId, tenantId);
    }

    public static LoginAccount.CustomAccount createInstanceByCustom(String accountId, HttpServletRequest request) {
        return new LoginAccount.CustomAccount(accountId, request);
    }

    public static LoginAccount.EidAccount createInstanceByEid(String eid) {
        return new LoginAccount.EidAccount(eid);
    }
}

