/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.yunzhijia;

import com.alibaba.fastjson.JSONObject;
import com.yunzhijia.OAuth1.OAuth;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.ConfigureationService;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.DESUtilsEncrypter;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.yunzhijia.AcqInfo;
import kd.bos.login.yunzhijia.YZJSpecialContext;
import kd.bos.login.yunzhijia.YZJSpeicalObj;
import kd.bos.login.yunzhijia.lightapp.YunzhijiaTicketService;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;

public class YZJSpecialUtils {
    private static final String LOGGER_GET_YZJ_HOST = "yzjHost=";
    private static final String GET_YZJ_APP_ID = "YZJAppID=";
    private static final String BOS_LOGIN = "bos-login";
    private static final String SUCCESS = "success";
    private static final String LOGGER_PARAMS = "params=";
    private static final String LOGGER_RESULT = "result=";
    private static final String ACCESS_TOKEN = "?accessToken=";
    private static final String SSO_TOKEN = "ssoToken";
    private static final String OAUTH_TOKEN = "oauth_token";
    private static final String CODE = "code";
    private static final String OAUTH_TOKEN_SECRET = "oauth_token_secret";
    private static Log logger = LogFactory.getLog(YZJSpecialUtils.class);
    private static String GET_SYS_ACCESS_TOKEN_URL = "gateway/oauth2/getSysAccessToken";
    private static String GET_OBTAINOAUTH2SECRET_URL = "gateway/opencloud/kdonline/obtainoauth2secret?accessToken=";
    private static String GET_SSO_TOKEN = "gateway/jwt/getSSOToken";
    private static String GET_VISIT_PERMIT = "gateway/jwt/visitPermit";
    private static String GET_ACQCODE_URL = "opencloud/kdonline/acqcode";
    private static String GET_ACQSSOINFO_URL = "opencloud/kdonline/acqssoinfo";
    private static String GET_WEBLOGIN_TOKEN_URL = "snsapi/oauth/weblogin_token";
    private static String GET_PERSON_URL = "gateway/opendata-control/data/getperson";

    private static String getDescription() {
        return ResManager.loadKDString((String)"\u4e0b\u6e38\u7cfb\u7edf\u8fde\u63a5\u4e0d\u6210\u529f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"YZJSpecialUtils_11", (String)BOS_LOGIN, (Object[])new Object[0]);
    }

    private static String getOperationPathDesc() {
        return ResManager.loadKDString((String)"\u64cd\u4f5c\u8def\u5f84\uff1a\u516c\u5171\u8bbe\u7f6e-\u53c2\u6570\u914d\u7f6e-\u7cfb\u7edf\u53c2\u6570-\u7b2c\u4e09\u65b9\u53c2\u6570\u3002", (String)"YZJSpecialUtils_12", (String)BOS_LOGIN, (Object[])new Object[0]);
    }

    public static String getWebLoginToken(Account currentCenter, String eid, String oid) {
        String loginToken = "";
        AcqInfo acqInfo = YZJSpecialUtils.getAcqssoinfo(currentCenter, eid, oid);
        if (acqInfo == null || acqInfo.getToken() == null || acqInfo.getTokenSecret() == null) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u4fe1\u606f\u5931\u8d25\u3002", (String)"YZJSpecialUtils_0", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        String yzjHost = YZJSpecialUtils.getYZJHost(currentCenter);
        logger.info(LOGGER_GET_YZJ_HOST + yzjHost);
        String consumerKey = YZJSpecialUtils.getConsumerKey(currentCenter);
        String consumerSecret = YZJSpecialUtils.getConsumerSecret(currentCenter);
        if (kd.bos.util.StringUtils.isEmpty((String)consumerKey) || kd.bos.util.StringUtils.isEmpty((String)consumerSecret)) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ea7\u54c1\u7aefAPPKEY\u548c\u4ea7\u54c1\u7aefAPPSECRET\u3002", (String)"YZJSpecialUtils_4", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        String oauthToken = acqInfo.getToken();
        String oauthTokenSecret = acqInfo.getTokenSecret();
        String method = "GET";
        String url = yzjHost + GET_WEBLOGIN_TOKEN_URL;
        OAuth oAuth = new OAuth(consumerKey, consumerSecret);
        String responseString = oAuth.generateAuthorizationHeader(method, url, null, oauthToken, oauthTokenSecret);
        try {
            Map data;
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Authorization", responseString);
            String response = HttpClientUtils.get((String)url, headerMap, null);
            if (kd.bos.util.StringUtils.isNotEmpty((String)response)) {
                data = (Map)JSONUtils.cast((String)response, HashMap.class);
                if (data == null || !Boolean.parseBoolean((String)data.get(SUCCESS)) || data.get("lgtk") == null) {
                    logger.info("getWebLoginToken response =" + response);
                    if (data != null) {
                        throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4ea7\u54c1\u7aefAPPKEY\u548c\u4ea7\u54c1\u7aefAPPSECRET\u3002%s", (String)"YZJSpecialUtils_16", (String)BOS_LOGIN, (Object[])new Object[]{YZJSpecialUtils.getOperationPathDesc()})});
                    }
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u4e3a\u7a7a\u3002", (String)"YZJSpecialUtils_1", (String)BOS_LOGIN, (Object[])new Object[0])});
                }
            } else {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u4e3a\u7a7a\u3002", (String)"YZJSpecialUtils_1", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            loginToken = (String)data.get("lgtk");
        }
        catch (IOException e) {
            logger.info("getWebLoginToken error", (Object)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4ea7\u54c1\u7aefAPPKEY\u548c\u4ea7\u54c1\u7aefAPPSECRET\u3002%s", (String)"YZJSpecialUtils_16", (String)BOS_LOGIN, (Object[])new Object[]{YZJSpecialUtils.getOperationPathDesc()})});
        }
        return loginToken;
    }

    public static AcqInfo getAcqssoinfo(Account currentCenter, String eid, String oid) {
        AcqInfo acqInfo;
        block8: {
            acqInfo = new AcqInfo();
            String code = YZJSpecialUtils.getAcqCode(currentCenter, eid, oid);
            String yzjHost = YZJSpecialUtils.getYZJHost(currentCenter);
            logger.info(LOGGER_GET_YZJ_HOST + yzjHost);
            HashMap<String, String> mpJson = new HashMap<String, String>();
            mpJson.put("eid", eid);
            mpJson.put("oid", oid);
            mpJson.put(CODE, code);
            mpJson.put("clientId", YZJSpecialUtils.getYZJClientId(currentCenter));
            if (kd.bos.util.StringUtils.isEmpty((String)oid)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u5148\u540c\u6b65\u4e91\u4e4b\u5bb6\u4eba\u5458\u3002", (String)"YZJSpecialUtils_15", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            try {
                String result = HttpClientUtils.post((String)(yzjHost + GET_ACQSSOINFO_URL), null, mpJson);
                Map data = (Map)JSONUtils.cast((String)result, HashMap.class);
                if (data != null) {
                    if (((Boolean)data.get(SUCCESS)).booleanValue() && data.get("data") != null) {
                        Map map = (Map)data.get("data");
                        for (Map.Entry entry : map.entrySet()) {
                            if (OAUTH_TOKEN_SECRET.equals(entry.getKey())) {
                                acqInfo.setTokenSecret((String)entry.getValue());
                            }
                            if (!OAUTH_TOKEN.equals(entry.getKey())) continue;
                            acqInfo.setToken((String)entry.getValue());
                        }
                    }
                    if (!((Boolean)data.get(SUCCESS)).booleanValue()) {
                        logger.info("getAcqssoinfo data:" + result);
                        throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4eba\u5458\u662f\u5426\u5df2\u540c\u6b65\u4e91\u4e4b\u5bb6\u3002", (String)"YZJSpecialUtils_3", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                    break block8;
                }
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u4e3a\u7a7a\u3002", (String)"YZJSpecialUtils_1", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            catch (IOException e) {
                logger.info("getAcqssoinfo error", (Object)e);
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4e91\u4e4b\u5bb6\u7f51\u5173\u5730\u5740\u662f\u5426\u53ef\u7528\u3002", (String)"YZJSpecialUtils_2", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
        }
        return acqInfo;
    }

    public static String getAcqcodeEncryptBody(String eid, String oid, String secret) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("eid", (Object)eid);
        jsonObject.put("oid", (Object)oid);
        jsonObject.put("timestamp", (Object)(System.currentTimeMillis() + ""));
        jsonObject.put("resGroupSecret", (Object)secret);
        Base64.Encoder encoder = Base64.getEncoder();
        String exchangeBody = null;
        try {
            DESUtilsEncrypter des = (DESUtilsEncrypter)BeanUtils.getBean("kd.bos.login.utils.DESUtilsEncrypterImpl");
            exchangeBody = new String(encoder.encode(des.encrypt(jsonObject.toJSONString().getBytes(), eid.concat("$").concat("kingdeeonline"))));
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
        return exchangeBody;
    }

    public static String getAcqCode(Account currentCenter, String eid, String oid) {
        String acqCode;
        block5: {
            acqCode = "";
            String aSecret = YZJSpecialUtils.getObtainoauth2secret(currentCenter, eid);
            String encrytedBody = YZJSpecialUtils.getAcqcodeEncryptBody(eid, oid, aSecret);
            String yzjHost = YZJSpecialUtils.getYZJHost(currentCenter);
            HashMap<String, String> mpJson = new HashMap<String, String>();
            mpJson.put("eid", eid);
            mpJson.put("encryptBody", encrytedBody);
            try {
                String result = HttpClientUtils.post((String)(yzjHost + GET_ACQCODE_URL), null, mpJson);
                Map data = (Map)JSONUtils.cast((String)result, HashMap.class);
                if (data != null) {
                    if (((Boolean)data.get(SUCCESS)).booleanValue()) {
                        Map map;
                        if (data.get("data") != null && (map = (Map)data.get("data")).get(CODE) != null) {
                            acqCode = (String)map.get(CODE);
                        }
                        break block5;
                    }
                    logger.info("getAcqCode data:" + result);
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4eba\u5458\u662f\u5426\u5df2\u540c\u6b65\u4e91\u4e4b\u5bb6\u3002", (String)"YZJSpecialUtils_3", (String)BOS_LOGIN, (Object[])new Object[0])});
                }
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u4e3a\u7a7a\u3002", (String)"YZJSpecialUtils_1", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            catch (IOException e) {
                logger.info("getAcqCode error", (Object)e);
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4e91\u4e4b\u5bb6\u7f51\u5173\u5730\u5740\u662f\u5426\u53ef\u7528\u3002", (String)"YZJSpecialUtils_2", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
        }
        return acqCode;
    }

    public static String getObtainoauth2secret(Account currentCenter, String eid) {
        String oSecret;
        block6: {
            oSecret = "";
            String accessToken = YZJSpecialUtils.getSysAccessToken(currentCenter);
            String yzjHost = YZJSpecialUtils.getYZJHost(currentCenter);
            logger.info(LOGGER_GET_YZJ_HOST + yzjHost);
            String yzjAppID = YZJSpecialUtils.getYZJAppID(currentCenter);
            logger.info(GET_YZJ_APP_ID + yzjAppID);
            HashMap<String, String> mpJson = new HashMap<String, String>();
            mpJson.put("appId", yzjAppID);
            mpJson.put("eid", eid);
            if (kd.bos.util.StringUtils.isEmpty((String)eid)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5de5\u4f5c\u5708EID\u3002", (String)"YZJSpecialUtils_8", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            try {
                String result = HttpClientUtils.post((String)(yzjHost + GET_OBTAINOAUTH2SECRET_URL + accessToken), null, mpJson);
                Map data = (Map)JSONUtils.cast((String)result, HashMap.class);
                if (data != null) {
                    if (((Boolean)data.get(SUCCESS)).booleanValue()) {
                        if (data.get("data") == null) break block6;
                        List list = (List)data.get("data");
                        for (Map map : list) {
                            String alias = YZJSpecialUtils.getAlias(map.get("alias"));
                            if (!"groupsecret_resource_openimport_r".equals(alias) && !"groupsecret_resource_openimport_rw".equals(alias) || map.get("secret") == null) continue;
                            oSecret = (String)map.get("secret");
                            break block6;
                        }
                        break block6;
                    }
                    logger.info("getObtainoauth2secret data:" + result);
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5de5\u4f5c\u5708EID\u3002", (String)"YZJSpecialUtils_14", (String)BOS_LOGIN, (Object[])new Object[0])});
                }
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u4e3a\u7a7a\u3002", (String)"YZJSpecialUtils_1", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            catch (IOException e) {
                logger.info("getObtainoauth2secret error", (Object)e);
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4e91\u4e4b\u5bb6\u7f51\u5173\u5730\u5740\u662f\u5426\u53ef\u7528\u3002", (String)"YZJSpecialUtils_2", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
        }
        return oSecret;
    }

    private static String getAlias(Object object) {
        String returnV = null;
        if (object != null) {
            String alias = (String)object;
            alias = alias.replaceAll("\\[", "");
            returnV = alias = alias.replaceAll("\\]", "");
        }
        return returnV;
    }

    public static String getSysAccessToken(Account currentCenter) throws KDException {
        return YZJSpecialUtils.getSysAccessToken(currentCenter, "");
    }

    public static String getSysAccessToken(Account currentCenter, String scope) {
        String accessToken;
        block6: {
            accessToken = "";
            String yzjHost = YZJSpecialUtils.getYZJHost(currentCenter);
            logger.info(LOGGER_GET_YZJ_HOST + yzjHost);
            String yzjAppID = YZJSpecialUtils.getYZJAppID(currentCenter);
            logger.info(GET_YZJ_APP_ID + yzjAppID);
            String yzjAppSecret = YZJSpecialUtils.getYZJAppSecret(currentCenter);
            HashMap<String, Object> mpJson = new HashMap<String, Object>();
            mpJson.put("appId", yzjAppID);
            mpJson.put("appSecret", yzjAppSecret);
            String[] scopes = new String[]{"opencloud_sys"};
            if (kd.bos.util.StringUtils.isNotEmpty((String)scope)) {
                scopes = new String[]{scope};
            }
            mpJson.put("scopes", scopes);
            try {
                String result = HttpClientUtils.postAppJson((String)(yzjHost + GET_SYS_ACCESS_TOKEN_URL), null, mpJson);
                Map data = (Map)JSONUtils.cast((String)result, HashMap.class);
                if (data != null) {
                    if (((Boolean)data.get(SUCCESS)).booleanValue()) {
                        Map dataMap;
                        if (data.get("data") != null && (dataMap = (Map)data.get("data")).get("accessToken") != null) {
                            accessToken = (String)dataMap.get("accessToken");
                        }
                        break block6;
                    }
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff1a\u8bf7\u68c0\u67e5\u3010\u7f51\u5173\u7cfb\u7edf\u7ea7APPSECRET\u3011\uff0c%s\u3002", (String)"YZJSpecialUtils_7", (String)BOS_LOGIN, (Object[])new Object[]{YZJSpecialUtils.getOperationPathDesc()})});
                }
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u4e3a\u7a7a\u3002", (String)"YZJSpecialUtils_1", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            catch (IOException e) {
                logger.info("getSysAccessToken error", (Object)e);
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4e91\u4e4b\u5bb6\u7f51\u5173\u5730\u5740\u662f\u5426\u53ef\u7528\u3002", (String)"YZJSpecialUtils_2", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
        }
        return accessToken;
    }

    public static String visitPermit(Account currentCenter, String openId) {
        String permitData;
        block4: {
            permitData = "";
            String yzjHost = YZJSpecialUtils.getYZJHost(currentCenter);
            String ssoToken = YZJSpecialUtils.getSSOToken(currentCenter, openId);
            HashMap<String, Object> body = new HashMap<String, Object>(8);
            body.put(SSO_TOKEN, ssoToken);
            body.put("ssoType", "context");
            body.put("scopes", new String[]{"clowflow_read", "attendance_write"});
            try {
                String result = HttpClientUtils.postAppJson((String)(yzjHost + GET_VISIT_PERMIT), null, body);
                Map data = (Map)JSONUtils.cast((String)result, HashMap.class);
                if (data != null) {
                    Map dataMap;
                    if (((Boolean)data.get(SUCCESS)).booleanValue() && data.get("data") != null && (dataMap = (Map)data.get("data")).get("permitData") != null) {
                        permitData = (String)dataMap.get("permitData");
                    }
                    break block4;
                }
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{YZJSpecialUtils.getDescription()});
            }
            catch (IOException e) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{YZJSpecialUtils.getDescription()});
            }
        }
        return permitData;
    }

    public static String getSSOToken(Account currentCenter, String openId) {
        String ssoToken;
        block5: {
            String yzjHost = YZJSpecialUtils.getYZJHost(currentCenter);
            String sysAccessToken = YZJSpecialUtils.getSysAccessToken(currentCenter, "sso_auth");
            HashMap<String, String> mpJson = new HashMap<String, String>();
            mpJson.put("sysAccessToken", sysAccessToken);
            Map<String, Object> yzjMap = ParametersUtils.getCommonParameters(currentCenter);
            if (yzjMap != null) {
                mpJson.put("ssoSecret", yzjMap.get("team_work_sso_secret") != null ? String.valueOf(yzjMap.get("team_work_sso_secret")) : "");
            }
            mpJson.put("clientId", YZJSpecialUtils.getYZJClientId(currentCenter));
            mpJson.put("eid", YZJSpecialUtils.getYZJEid(currentCenter));
            mpJson.put("oid", openId);
            ssoToken = "";
            try {
                String jsonPara = JSONUtils.toString(mpJson);
                String result = HttpClientUtils.postAppJson((String)(yzjHost + GET_SSO_TOKEN + ACCESS_TOKEN + sysAccessToken), null, mpJson);
                Map data = (Map)JSONUtils.cast((String)result, HashMap.class);
                if (data != null) {
                    Map dataMap;
                    if (((Boolean)data.get(SUCCESS)).booleanValue() && data.get("data") != null && (dataMap = (Map)data.get("data")).get(SSO_TOKEN) != null) {
                        ssoToken = (String)dataMap.get(SSO_TOKEN);
                    }
                    break block5;
                }
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{YZJSpecialUtils.getDescription()});
            }
            catch (IOException e) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{YZJSpecialUtils.getDescription()});
            }
        }
        return ssoToken;
    }

    public static String getSSOToken(Account currentCenter, Map<String, Object> params) {
        String ssoToken;
        block5: {
            String yzjHost = YZJSpecialUtils.getYZJHost(currentCenter);
            String sysAccessToken = YZJSpecialUtils.getSysAccessToken(currentCenter, "sso_auth");
            params.put("ssoSecret", "anonymous");
            ssoToken = "";
            try {
                String jsonPara = JSONUtils.toString(params);
                String result = HttpClientUtils.postAppJson((String)(yzjHost + GET_SSO_TOKEN + ACCESS_TOKEN + sysAccessToken), null, params);
                Map data = (Map)JSONUtils.cast((String)result, HashMap.class);
                if (data != null) {
                    if (((Boolean)data.get(SUCCESS)).booleanValue()) {
                        Map dataMap;
                        if (data.get("data") != null && (dataMap = (Map)data.get("data")).get(SSO_TOKEN) != null) {
                            ssoToken = (String)dataMap.get(SSO_TOKEN);
                        }
                        break block5;
                    }
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format("%s:%s", String.valueOf(data.get("error")), String.valueOf(data.get("errorCode")))});
                }
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4eba\u5458\u662f\u5426\u5df2\u540c\u6b65\u4e91\u4e4b\u5bb6\u3002", (String)"YZJSpecialUtils_3", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            catch (IOException e) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u7cfb\u7edf\u7ea7accessToken\u5931\u8d25\u3002", (String)"YZJSpecialUtils_5", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
        }
        return ssoToken;
    }

    private static boolean getBoolean(Object object) {
        boolean returnBoolan = false;
        if (object != null) {
            if (object instanceof Boolean) {
                returnBoolan = (Boolean)object;
            } else if (object instanceof String) {
                returnBoolan = Boolean.parseBoolean((String)object);
            }
        }
        return returnBoolan;
    }

    public static boolean isYZJSpecialVersion(Account currentCenter) {
        boolean isYZJSpecialVersion = false;
        Map<String, Object> yzjMap = ParametersUtils.getCommonParameters(currentCenter);
        if (yzjMap != null) {
            isYZJSpecialVersion = yzjMap.get("isyzjspecialversion") != null ? YZJSpecialUtils.getBoolean(yzjMap.get("isyzjspecialversion")) : false;
            YZJSpeicalObj sObject = new YZJSpeicalObj();
            String yzjHost = StringUtils.getStringValue(yzjMap.get("syunzhijiaapphost"));
            sObject.setHost(yzjHost);
            String consumerKey = StringUtils.getStringValue(yzjMap.get("sconsumerkey"));
            sObject.setConsumerKey(consumerKey);
            String consumeSecret = StringUtils.getStringValue(yzjMap.get("sconsumersecret"));
            sObject.setConsumerSecret(consumeSecret);
            String yzjApp = StringUtils.getStringValue(yzjMap.get("syzjappid"));
            sObject.setAppID(yzjApp);
            String yzjAppSecret = StringUtils.getStringValue(yzjMap.get("syzjappsecret"));
            sObject.setSecret(yzjAppSecret);
            String clientId = StringUtils.getStringValue(yzjMap.get("yzj_clientid"));
            sObject.setClientId(clientId);
            String eid = StringUtils.getStringValue(yzjMap.get("eid"));
            sObject.setEid(eid);
            logger.info("getYZJEID=" + eid);
            YZJSpecialContext.setSpecailObject(sObject);
        }
        return isYZJSpecialVersion;
    }

    public static boolean hasYZJSpecialVersion(Account currentCenter) {
        boolean hasYZJSpecialVersion = YZJSpecialUtils.isYZJSpecialVersion(currentCenter);
        if (YZJSpecialContext.getSpecailObject() != null) {
            String yzjHost = YZJSpecialContext.getSpecailObject().getHost();
            if (kd.bos.util.StringUtils.isEmpty((String)yzjHost)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e91\u4e4b\u5bb6\u7f51\u5173\uff0c%s", (String)"YZJSpecialUtils_10", (String)BOS_LOGIN, (Object[])new Object[]{YZJSpecialUtils.getOperationPathDesc()})});
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)YZJSpecialContext.getSpecailObject().getAppID())) {
                hasYZJSpecialVersion = true;
            }
        }
        return hasYZJSpecialVersion;
    }

    public static String getYZJAppUrl(Account currentCenter, String baseUrl, String appid, Map<String, String> data) {
        String returnUrl = "";
        String eid = YZJSpecialUtils.getYZJEid(currentCenter);
        String openId = "";
        if (RequestContext.get() != null) {
            openId = RequestContext.get().getUserOpenId();
        }
        String lkToken = YZJSpecialUtils.getWebLoginToken(currentCenter, eid, openId);
        returnUrl = YZJSpecialUtils.getYZJHost(currentCenter) + "connect-widget/cosmic_lapp_redirect.html?lgtk=" + lkToken + "&appId=" + appid + "&toEid=" + eid;
        return returnUrl;
    }

    public static String getYZJMessageUrl(Account currentCenter) {
        String returnUrl = "";
        String eid = YZJSpecialUtils.getYZJEid(currentCenter);
        String openId = "";
        if (RequestContext.get() != null) {
            openId = RequestContext.get().getUserOpenId();
        }
        String lkToken = YZJSpecialUtils.getWebLoginToken(currentCenter, eid, openId);
        returnUrl = YZJSpecialUtils.getYZJHost(currentCenter) + "xiaoxi/" + "connect-widget/cosmic_lapp_redirect.html?lgtk=" + lkToken;
        return returnUrl;
    }

    private static String getYZJAppID(Account currentCenter) {
        String YZJAppID = null;
        if (YZJSpecialContext.getSpecailObject() != null) {
            YZJAppID = YZJSpecialContext.getSpecailObject().getAppID();
        }
        if (kd.bos.util.StringUtils.isEmpty(YZJAppID) || null == YZJAppID) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7f51\u5173\u7cfb\u7edf\u7ea7APPID\u3002%s", (String)"YZJSpecialUtils_6", (String)BOS_LOGIN, (Object[])new Object[]{YZJSpecialUtils.getOperationPathDesc()})});
        }
        return YZJAppID.trim();
    }

    private static String getYZJAppSecret(Account currentCenter) {
        String YZJAppSecret = null;
        if (YZJSpecialContext.getSpecailObject() != null) {
            YZJAppSecret = YZJSpecialContext.getSpecailObject().getSecret();
        }
        if (kd.bos.util.StringUtils.isEmpty(YZJAppSecret) || null == YZJAppSecret) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7f51\u5173\u7cfb\u7edf\u7ea7APPSECRET\u3002%s", (String)"YZJSpecialUtils_13", (String)BOS_LOGIN, (Object[])new Object[]{YZJSpecialUtils.getOperationPathDesc()})});
        }
        return YZJAppSecret.trim();
    }

    private static String getYZJClientId(Account currentCenter) {
        String clientId = "10203";
        if (YZJSpecialContext.getSpecailObject() != null) {
            clientId = YZJSpecialContext.getSpecailObject().getClientId();
        }
        if (kd.bos.util.StringUtils.isEmpty((String)clientId) && currentCenter != null) {
            clientId = System.getProperty(currentCenter.getTenantId() + "_yzj_client_id");
        }
        if (kd.bos.util.StringUtils.isEmpty((String)clientId)) {
            clientId = System.getProperty("yzj_client_id");
        }
        if (kd.bos.util.StringUtils.isEmpty((String)clientId)) {
            clientId = "10203";
        }
        logger.info("\u83b7\u53d6YZJclientId=" + clientId);
        return clientId;
    }

    public static String getYZJEid(Account currentCenter) {
        String eid = "";
        if (kd.bos.util.StringUtils.isEmpty((String)eid)) {
            Map<String, Object> yzjMap;
            if (YZJSpecialContext.getSpecailObject() != null) {
                eid = YZJSpecialContext.getSpecailObject().getEid();
            }
            if (kd.bos.util.StringUtils.isEmpty((String)eid) && (yzjMap = ParametersUtils.getCommonParameters(currentCenter)) != null) {
                eid = String.valueOf(yzjMap.get("eid"));
            }
        }
        if (kd.bos.util.StringUtils.isEmpty((String)eid)) {
            eid = currentCenter.getEid();
        }
        logger.info("\u83b7\u53d6YZJEID=" + eid);
        return eid;
    }

    public static String getYZJHost(Account currentCenter) {
        String yzjHost = null;
        if (YZJSpecialContext.getSpecailObject() != null) {
            yzjHost = YZJSpecialContext.getSpecailObject().getHost();
        }
        if (kd.bos.util.StringUtils.isEmpty(yzjHost) || null == yzjHost) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e91\u4e4b\u5bb6\u7f51\u5173\uff0c%s", (String)"YZJSpecialUtils_10", (String)BOS_LOGIN, (Object[])new Object[]{YZJSpecialUtils.getOperationPathDesc()})});
        }
        if (!(yzjHost = yzjHost.trim()).endsWith("/")) {
            yzjHost = yzjHost + "/";
        }
        return yzjHost;
    }

    private static String getConsumerSecret(Account currentCenter) {
        String consumerSecret = null;
        if (YZJSpecialContext.getSpecailObject() != null) {
            consumerSecret = YZJSpecialContext.getSpecailObject().getConsumerSecret();
        }
        if (kd.bos.util.StringUtils.isEmpty(consumerSecret) || null == consumerSecret) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230SConsumerSecret\uff0c\u8bf7\u914d\u7f6eSConsumerSecret\u5c5e\u6027\u3002", (String)"YZJSpecialUtils_9", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)consumerSecret)) {
            return consumerSecret.trim();
        }
        return consumerSecret;
    }

    private static String getConsumerKey(Account currentCenter) {
        String consumerKey = "";
        if (YZJSpecialContext.getSpecailObject() != null) {
            consumerKey = YZJSpecialContext.getSpecailObject().getConsumerKey();
        }
        if (kd.bos.util.StringUtils.isEmpty((String)consumerKey)) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230SConsumerSecret\uff0c\u8bf7\u914d\u7f6eSConsumerSecret\u5c5e\u6027\u3002", (String)"YZJSpecialUtils_9", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        return consumerKey.trim();
    }

    public static String getYzjUserInfo(Account currentCenter) {
        String eid = YZJSpecialUtils.getYZJEid(currentCenter);
        String openId = "";
        if (RequestContext.get() != null) {
            openId = RequestContext.get().getUserOpenId();
        }
        String result = "";
        Map<String, Object> paramMap = ConfigureationService.getCommonParameters(currentCenter);
        if (paramMap == null) {
            return null;
        }
        try {
            String yzjHost = paramMap.get("syunzhijiaapphost").toString();
            String appId = System.getProperty("YZJAppID");
            String appSecret = System.getProperty("YZJAppSecret");
            String accessToken = YunzhijiaTicketService.getAccessToken(yzjHost, appId, appSecret);
            if (!yzjHost.endsWith("/")) {
                yzjHost = yzjHost + "/";
            }
            StringBuilder yzjGetPersonUrl = new StringBuilder(yzjHost);
            yzjGetPersonUrl.append(GET_PERSON_URL).append(ACCESS_TOKEN).append(accessToken);
            ArrayList<HttpClientUtils.FormDataEntity> formDatas = new ArrayList<HttpClientUtils.FormDataEntity>();
            formDatas.add(new HttpClientUtils.FormDataEntity("openId", openId));
            formDatas.add(new HttpClientUtils.FormDataEntity("eid", eid));
            result = HttpClientUtils.postFormData((String)yzjGetPersonUrl.toString(), null, formDatas, (int)3000, (int)5000);
        }
        catch (Exception e) {
            logger.error("YZJSpecialUtils--isYzjAdmin--getPerson error:" + e);
        }
        return result;
    }
}

