/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.yunzhijia.lightapp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.HttpUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.verfiy.BaseVerifier;
import kd.bos.login.verfiy.VerifyEnum;
import kd.bos.login.verfiy.VerifyResult;
import org.apache.commons.lang.StringUtils;

public class LingappVerifier {
    private static Log logger = LogFactory.getLog(LingappVerifier.class);
    private static final String LOGIN_VERIFY = "login_verfiers";
    private static final String LOGIN_ADDR = "/login.do";

    public static boolean verifyAll(HttpServletRequest request, HttpServletResponse response, String appId, String ticket, String accountIdParameter, String sandBoxId, String openId) {
        boolean isHandled = false;
        try {
            String allVerifies;
            Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountIdParameter, request).getAccount();
            Lang lang = LoginLangUtils.getLoginLanguage(request);
            Map<String, String> user = LoginUserService.getErpUserInfo(currentCenter, openId, lang.name());
            if ("1".equalsIgnoreCase(user.get("success")) && !StringUtils.isEmpty((String)(allVerifies = System.getProperty(LOGIN_VERIFY)))) {
                String[] verifiers;
                HashMap<Object, String> systemParameters = new HashMap<Object, String>();
                systemParameters.put((Object)VerifyEnum.DB_DRIVER, user.get("db_driver"));
                systemParameters.put((Object)VerifyEnum.DB_URL, user.get("db_url"));
                systemParameters.put((Object)VerifyEnum.E_ID, user.get("feid"));
                systemParameters.put((Object)VerifyEnum.USER_ID, user.get("fid"));
                systemParameters.put((Object)VerifyEnum.OPEN_ID, user.get("fopenid"));
                systemParameters.put((Object)VerifyEnum.ORGNIZATION_ID, user.get("forgid"));
                systemParameters.put((Object)VerifyEnum.USER_TYPE, user.get("userType"));
                systemParameters.put((Object)VerifyEnum.TRUE_NAME, user.get("ftruename"));
                systemParameters.put((Object)VerifyEnum.PHONE, user.get("fphone"));
                String appNumber = request.getParameter("appNumber");
                systemParameters.put((Object)VerifyEnum.APP_ID, appNumber);
                logger.info("appNumber=" + appNumber);
                boolean isSuccess = false;
                String errorMessage = "";
                logger.info("LOGIN_VERIFY=" + allVerifies);
                for (String verify : verifiers = allVerifies.split(",")) {
                    BaseVerifier verifier = null;
                    try {
                        verifier = (BaseVerifier)Class.forName(verify).newInstance();
                        VerifyResult result = verifier.verify(systemParameters, request.getParameterMap(), currentCenter);
                        isSuccess = result.isSucceed();
                        errorMessage = result.getErrorMessage();
                        if (isSuccess) continue;
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        errorMessage = String.format(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u6821\u9a8c\u5668%s\u6821\u9a8c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01", (String)"LingappVerifier_0", (String)"bos-login", (Object[])new Object[0]), verify);
                    }
                    break;
                }
                if (!isSuccess) {
                    HttpUtils.webAlert(response, errorMessage);
                    isHandled = true;
                }
                logger.info("verified result=" + isSuccess);
            }
        }
        catch (KDException ex) {
            ErrorCode code = ex.getErrorCode();
            try {
                String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
                isHandled = true;
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            try {
                String resp = LoginUtils.getLoginResponse("1", ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\n", (String)"LingappVerifier_1", (String)"bos-login", (Object[])new Object[0]));
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
                isHandled = true;
            }
            catch (IOException ex) {
                logger.error((Throwable)ex);
            }
        }
        return isHandled;
    }
}

