/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.yunzhijia.lightapp;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.yunzhijia.AppInfo;
import kd.bos.login.yunzhijia.YunzhijiaAppContext;
import kd.bos.login.yunzhijia.YzjAppSingleton;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;

public class YunzhijiaTicketService {
    private static final String BOS_LOGIN = "bos-login";
    private static Log logger = LogFactory.getLog(YunzhijiaTicketService.class);

    public static YunzhijiaAppContext getContextByTicket(String ticket) {
        return YunzhijiaTicketService.getContextByTicket(ticket, "");
    }

    public static YunzhijiaAppContext getContextByTicket(String ticket, boolean isYzjPublicCloud) {
        return YunzhijiaTicketService.getContextByTicket(ticket, "", isYzjPublicCloud);
    }

    public static YunzhijiaAppContext getContextByTicket(String ticket, String appId) {
        return YunzhijiaTicketService.getContextByTicket(ticket, appId, true);
    }

    public static YunzhijiaAppContext getContextByTicket(String ticket, String appId, boolean isYzjPublicCloud) {
        AppInfo app;
        YunzhijiaAppContext yunzhijiaAppContext = null;
        String sYunzhijiaHost = StringUtils.getTrimedBlank(System.getProperty("YunZhiJiaAppHost"));
        String sAppID = StringUtils.getTrimedBlank(System.getProperty("YZJAppID"));
        String sAppSecret = StringUtils.getTrimedBlank(System.getProperty("YZJAppSecret"));
        if (!isYzjPublicCloud) {
            sYunzhijiaHost = StringUtils.getTrimedBlank(SystemPropertyUtils.getProptyByTenant("YunZhiJiaAppHost", RequestContext.get().getTenantId()));
            sAppID = StringUtils.getTrimedBlank(SystemPropertyUtils.getProptyByTenant("YZJAppID", RequestContext.get().getTenantId()));
            sAppSecret = StringUtils.getTrimedBlank(SystemPropertyUtils.getProptyByTenant("YZJAppSecret", RequestContext.get().getTenantId()));
        }
        if (!StringUtils.isEmpty(appId) && (app = YzjAppSingleton.getInstance().getAppInfo(appId)) != null) {
            sAppID = appId;
            sAppSecret = app.getSecret();
        }
        try {
            String token = YunzhijiaTicketService.getAccessToken(sYunzhijiaHost, sAppID, sAppSecret);
            if (StringUtils.isNull(token) || StringUtils.isBlank(token)) {
                throw new KDException(ResManager.loadKDString((String)"\u9a8c\u8bc1\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u7528\u6237AcessToken\u3002", (String)"YunzhijiaTicketService_0", (String)BOS_LOGIN, (Object[])new Object[0]));
            }
            yunzhijiaAppContext = YunzhijiaTicketService.getYunzhijiaAppContextByTicket(sYunzhijiaHost, token, sAppID, ticket);
        }
        catch (Exception e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
        return yunzhijiaAppContext;
    }

    private static YunzhijiaAppContext getYunzhijiaAppContextByTicket(String sYunzhijiaHost, String token, String sAppID, String ticket) {
        String url = sYunzhijiaHost + "/gateway/ticket/user/acquirecontext" + "?accessToken=" + token;
        HashMap<String, Object> bodyMap = new HashMap<String, Object>(8);
        bodyMap.put("appid", sAppID);
        bodyMap.put("ticket", ticket);
        bodyMap.put("disposable", true);
        Object obj = YunzhijiaTicketService.getYunzhijiaINfo(url, true, null, bodyMap);
        YunzhijiaAppContext yunzhijiaAppContext = null;
        Map result = (Map)obj;
        if (result != null && StringUtils.isNotEmpty((String)result.get("openid"))) {
            Map dataMap = result;
            yunzhijiaAppContext = new YunzhijiaAppContext();
            yunzhijiaAppContext.setEid((String)dataMap.get("eid"));
            yunzhijiaAppContext.setOpenid((String)dataMap.get("openid"));
            yunzhijiaAppContext.setTid((String)dataMap.get("tid"));
            yunzhijiaAppContext.setUid((String)dataMap.get("uid"));
            yunzhijiaAppContext.setUsername((String)dataMap.get("username"));
        }
        return yunzhijiaAppContext;
    }

    public static String getAccessToken(String sYzjHost, String appId, String appSecret) {
        String access_token = "";
        String timestamp = String.valueOf(System.currentTimeMillis());
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("appId", appId);
        bodyMap.put("secret", appSecret);
        bodyMap.put("timestamp", timestamp);
        bodyMap.put("scope", "app");
        Object obj = YunzhijiaTicketService.getYunzhijiaINfo(sYzjHost + "/gateway/oauth2/token/getAccessToken", true, null, bodyMap);
        Map result = (Map)obj;
        if (result != null) {
            access_token = (String)result.get("accessToken");
        }
        return access_token;
    }

    private static Object getYunzhijiaINfo(String url, boolean appJson, Map<String, String> header, Map<String, Object> data) {
        try {
            String resp = "";
            resp = appJson ? HttpClientUtils.postAppJson((String)url, header, data) : HttpClientUtils.post((String)url, header, data);
            if (StringUtils.isEmpty(resp)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4e91\u4e4b\u5bb6\u5931\u8d25\uff0c\u65e0\u6709\u6548\u6570\u636e\u3002URL:%s", (String)"YunzhijiaTicketService_1", (String)BOS_LOGIN, (Object[])new Object[0]), url)});
            }
            Map objMap = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true);
            if (0 != (Integer)objMap.get("errorCode")) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u6570\u636e\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"YunzhijiaTicketService_2", (String)BOS_LOGIN, (Object[])new Object[0]), objMap.get("error"))});
            }
            return objMap.get("data");
        }
        catch (KDException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u8bbf\u95ee\u4e91\u4e4b\u5bb6\u5931\u8d25\uff1a%s\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"YunzhijiaTicketService_3", (String)BOS_LOGIN, (Object[])new Object[0]), url)});
        }
    }

    public static String getQRCodeURL(String tenantId) {
        return YunzhijiaTicketService.getQRCodeURL(tenantId, true);
    }

    public static String getQRCodeURL(String tenantId, boolean isYzjPublicCloud) {
        StringBuilder sb = new StringBuilder();
        String sYunzhijiaHost = System.getProperty("YunZhiJiaAppHost");
        String sAppID = System.getProperty("YZJAppID");
        if (!isYzjPublicCloud) {
            sYunzhijiaHost = SystemPropertyUtils.getProptyByTenant("YunZhiJiaAppHost", RequestContext.get().getTenantId());
            sAppID = SystemPropertyUtils.getProptyByTenant("YZJAppID", RequestContext.get().getTenantId());
        }
        sb.append(sYunzhijiaHost);
        sb.append("/opencloud/openthird/qrconnet");
        sb.append("?appid=");
        sb.append(sAppID);
        String yzjName = System.getProperty(tenantId + "_" + "YunZhiJiaAppName");
        if (StringUtils.isEmpty(yzjName)) {
            yzjName = System.getProperty("YunZhiJiaAppName");
        }
        if (StringUtils.isNotEmpty(yzjName)) {
            sb.append("&appName=");
            sb.append(yzjName);
        }
        return sb.toString();
    }
}

