/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

@Deprecated
public class PrintEntityTreePlugin
extends StandardTreeListPlugin {
    private static final String CURRENT_NODE_ID = "currentNodeId";
    private static final String CLOUD = "cloud_";
    private static final String NUMBER = "number";
    private static final String BIZ_APP_ID = "bizappid";
    private static final String CACHE_FILTER = "cachefilter";

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    public void initTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PrintEntityTreePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        if (!configInfo.isEmpty()) {
            String currentNodeId = String.valueOf(configInfo.get(CURRENT_NODE_ID));
            List<TreeNode> cloudNodes = null;
            List<TreeNode> appNodes = null;
            if (currentNodeId.contains(CLOUD)) {
                cloudNodes = this.getCloudNodeById(currentNodeId);
                appNodes = this.getAppNodes();
            } else if (currentNodeId.contains("app_")) {
                cloudNodes = this.getCloudNodes();
                appNodes = this.getAppNodeById(currentNodeId);
            } else {
                cloudNodes = this.getCloudNodes();
                appNodes = this.getAppNodes();
            }
            List<TreeNode> billNodes = this.getBillNodes(null);
            ArrayList<String> pBillNodeIds = new ArrayList<String>(10);
            for (TreeNode billNode : billNodes) {
                String pBillNodeId = billNode.getParentid();
                pBillNodeIds.add(pBillNodeId);
            }
            Iterator<TreeNode> itApp = appNodes.iterator();
            while (itApp.hasNext()) {
                TreeNode appNode = itApp.next();
                String appNodeId = appNode.getId();
                if (pBillNodeIds.contains(appNodeId)) continue;
                itApp.remove();
            }
            for (int i = 0; i < cloudNodes.size(); ++i) {
                this.addChildNode(cloudNodes.get(i), appNodes);
            }
            Iterator<TreeNode> itCloud = cloudNodes.iterator();
            while (itCloud.hasNext()) {
                TreeNode cloudNode = itCloud.next();
                if (cloudNode.getChildren() != null && !cloudNode.getChildren().isEmpty()) continue;
                itCloud.remove();
            }
            root.addChildren(cloudNodes);
            this.getTreeModel().setRoot(root);
            this.getTreeModel().setCurrentNodeId((Object)root.getId());
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String currentNodeId = String.valueOf(configInfo.get(CURRENT_NODE_ID));
        List<TreeNode> childNodes = this.getChildNodes(e.getNodeId(), currentNodeId);
        e.setChildNodes(childNodes);
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        String nodeId = treenodeevent.getNodeId().toString();
        this.getPageCache().put("nodeId", nodeId);
        super.treeNodeClick(treenodeevent);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String currentNodeId = String.valueOf(configInfo.get(CURRENT_NODE_ID));
        QFilter filter = null;
        if (currentNodeId.contains("app_")) {
            currentNodeId = StringUtils.substringAfter((String)currentNodeId, (String)"_");
            filter = new QFilter(NUMBER, "in", this.getBillIdInApp(Collections.singletonList(currentNodeId)));
        } else if (currentNodeId.contains(CLOUD)) {
            currentNodeId = StringUtils.substringAfter((String)currentNodeId, (String)"_");
            QFilter filter2 = new QFilter(NUMBER, "in", this.getBillIdInCloud(currentNodeId));
            if (this.isTopNodeId(nodeId) || nodeId.contains(CLOUD)) {
                filter = filter2;
            } else {
                String appId = StringUtils.substringAfter((String)nodeId, (String)"_");
                filter = new QFilter(NUMBER, "in", this.getBillIdInApp(Collections.singletonList(appId)));
            }
        } else if (this.isTopNodeId(nodeId)) {
            filter = new QFilter(NUMBER, "in", this.getBillId());
        } else if (nodeId.contains(CLOUD)) {
            String cloudId = StringUtils.substringAfter((String)nodeId, (String)"_");
            filter = new QFilter(NUMBER, "in", this.getBillIdInCloud(cloudId));
        } else {
            String appId = StringUtils.substringAfter((String)nodeId, (String)"_");
            filter = new QFilter(NUMBER, "in", this.getBillIdInApp(Collections.singletonList(appId)));
        }
        this.getPageCache().put(CACHE_FILTER, SerializationUtils.toJsonString((Object)filter));
        e.addQFilter(filter);
        e.setCancel(true);
    }

    public void setFilter(SetFilterEvent e) {
        String filterStr = this.getPageCache().get(CACHE_FILTER);
        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            QFilter qFilter = (QFilter)SerializationUtils.fromJsonString((String)filterStr, QFilter.class);
            e.addCustomQFilter(qFilter);
        }
    }

    private boolean isTopNodeId(String currNodeId) {
        return currNodeId.equals(this.getTreeModel().getRoot().getId());
    }

    private List<TreeNode> getChildNodes(Object parentId, String currentNodeId) {
        List<TreeNode> cloudNodes = new ArrayList<TreeNode>();
        List<Object> appNodes = new ArrayList();
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            if (currentNodeId.contains(CLOUD)) {
                cloudNodes = this.getCloudNodeById(currentNodeId);
                appNodes = this.getAppNodes();
            } else if (currentNodeId.contains("app_")) {
                cloudNodes = this.getCloudNodes();
                appNodes = this.getAppNodeById(currentNodeId);
            } else {
                cloudNodes = this.getCloudNodes();
                appNodes = this.getAppNodes();
            }
            List<TreeNode> billNodes = this.getBillNodes(null);
            ArrayList<String> pBillNodeIds = new ArrayList<String>(10);
            for (TreeNode billNode : billNodes) {
                String pBillNodeId = billNode.getParentid();
                pBillNodeIds.add(pBillNodeId);
            }
            Iterator<Object> itApp = appNodes.iterator();
            while (itApp.hasNext()) {
                TreeNode appNode = (TreeNode)itApp.next();
                String appNodeId = appNode.getId();
                if (pBillNodeIds.contains(appNodeId)) continue;
                itApp.remove();
            }
            for (int i = 0; i < cloudNodes.size(); ++i) {
                this.addChildNode(cloudNodes.get(i), appNodes);
            }
            Iterator<TreeNode> itCloud = cloudNodes.iterator();
            while (itCloud.hasNext()) {
                TreeNode cloudNode = itCloud.next();
                if (cloudNode.getChildren() != null && !cloudNode.getChildren().isEmpty()) continue;
                itCloud.remove();
            }
            return cloudNodes;
        }
        return cloudNodes;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(cnode);
        }
        return pnode;
    }

    private List<String> getBillId() {
        ArrayList<String> billIds = new ArrayList<String>(10);
        List<TreeNode> billNodes = this.getBillNodes(null);
        for (TreeNode billNode : billNodes) {
            String id = billNode.getId();
            billIds.add(id);
        }
        return billIds;
    }

    private List<String> getBillIdInCloud(String cloudId) {
        List<String> appIds = this.getAppIdInCloud(cloudId);
        return this.getBillIdInApp(appIds);
    }

    private List<String> getBillIdInApp(List<String> appIds) {
        ArrayList<String> billIds = new ArrayList<String>(10);
        List<TreeNode> billNodes = this.getBillNodes(appIds);
        for (TreeNode billNode : billNodes) {
            String id = billNode.getId();
            billIds.add(id);
        }
        return billIds;
    }

    private List<String> getAppIdInCloud(String cloudId) {
        Object[] param = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)cloudId)};
        String strSQL = "SELECT B.FID FROM t_meta_bizcloud A LEFT JOIN t_meta_bizapp B ON A.FID = B.FBIZCLOUDID WHERE A.FID = ?";
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)strSQL, (Object[])param, (ResultSetHandler)action);
    }

    private List<TreeNode> getAppNodes() {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection apps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : apps) {
            TreeNode node = new TreeNode();
            String nodeID = "app_" + app.getString("id");
            node.setText(app.getString("name"));
            node.setParentid(CLOUD + app.getString("bizcloud"));
            node.setId(nodeID);
            node.setData((Object)"app");
            appNodes.add(node);
        }
        return appNodes;
    }

    private List<TreeNode> getAppNodeById(String appId) {
        ArrayList<TreeNode> appNode = new ArrayList<TreeNode>();
        appId = StringUtils.substringAfter((String)appId, (String)"_");
        DynamicObject app = BizAppServiceHelp.getBizAppByID((String)appId);
        TreeNode node = new TreeNode();
        String nodeID = "app_" + app.getString("id");
        node.setText(app.getString("name"));
        node.setParentid(CLOUD + app.getString("bizcloud.id"));
        node.setId(nodeID);
        node.setData((Object)"app");
        appNode.add(node);
        return appNode;
    }

    private List<TreeNode> getCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        DynamicObjectCollection clouds = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject cloud : clouds) {
            TreeNode node = new TreeNode();
            String nodeID = CLOUD + cloud.getString("id");
            node.setText(cloud.getString("name"));
            node.setParentid("0");
            node.setId(nodeID);
            node.setData((Object)"cloud");
            cloudNode.add(node);
        }
        return cloudNode;
    }

    private List<TreeNode> getCloudNodeById(String cloudID) {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        cloudID = StringUtils.substringAfter((String)cloudID, (String)"_");
        DynamicObject cloud = BizCloudServiceHelp.getBizCloudByID((String)cloudID);
        TreeNode node = new TreeNode();
        String nodeID = CLOUD + cloud.getString("id");
        node.setText(cloud.getString("name"));
        node.setParentid("0");
        node.setId(nodeID);
        node.setData((Object)"cloud");
        cloudNode.add(node);
        return cloudNode;
    }

    private List<TreeNode> getBillNodes(List<String> bizAppIds) {
        ArrayList<TreeNode> billNodes = new ArrayList<TreeNode>();
        String fields = "id, number, name, bizappid";
        String orderby = "bizappid asc";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel"));
        QFilter modelTypeFilter2 = new QFilter("modeltype", "in", Arrays.asList("ReportFormModel", "QueryListModel", "DynamicFormModel"));
        QFilter isPrintFilter = new QFilter("isprint", "=", (Object)Boolean.TRUE);
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter appFilter = new QFilter(BIZ_APP_ID, "in", bizAppIds);
        QFilter baseFilter = isPrintFilter.and(isTemplateFilter).and(modelTypeFilter).or(modelTypeFilter2);
        QFilter propertyFilter = null;
        propertyFilter = StringUtils.isNotBlank(bizAppIds) ? baseFilter.and(appFilter) : baseFilter;
        QFilter[] filters = new QFilter[]{propertyFilter};
        try (DataSet ds = ORM.create().queryDataSet("bos_entityobject", "bos_entityobject", fields, filters, orderby);){
            for (Row row : ds) {
                if (!StringUtils.isNotBlank((CharSequence)row.getString(BIZ_APP_ID))) continue;
                TreeNode node = new TreeNode();
                String nodeID = row.getString("id");
                node.setText(row.getString("name"));
                node.setParentid("app_" + row.getString(BIZ_APP_ID));
                node.setId(nodeID);
                node.setData((Object)row.getString(NUMBER));
                billNodes.add(node);
            }
        }
        return billNodes;
    }
}

