/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.printop;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.report.IReportView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.print.PrintPriorityHelper;
import org.apache.commons.lang3.StringUtils;

public class ScriptPrint
extends DefaultDynamicFormOperate {
    private static Log log = LogFactory.getLog(ScriptPrint.class);
    private Object templatePkId;

    public void setTemplatePkId(Object templatePkId) {
        this.templatePkId = templatePkId;
    }

    public boolean needSelectData() {
        return true;
    }

    protected OperationResult invokeOperation() {
        OperationResult result = super.invokeOperation();
        if (this.getView() instanceof IListView || this.getView() instanceof IReportView) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u811a\u672c\u6253\u5370\u6682\u4e0d\u652f\u6301\u5217\u8868\u3002", (String)"ScriptPrint_0", (String)"bos-noteprint", (Object[])new Object[0]));
        } else {
            List<Object> pkIds = this.getPKIds();
            String entityTypeId = this.getEntityTypeId();
            if (pkIds.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5370\u5355\u636e\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"ScriptPrint_1", (String)"bos-noteprint", (Object[])new Object[0]));
                result.setSuccess(false);
                return result;
            }
            boolean isConfirm = "MessageCallBackType".equals(this.getParameter().get("sourceName"));
            DynamicObject obj = ParameterReader.getBillParameter((String)entityTypeId);
            String printcondition = null;
            String printconditionname = null;
            if (obj != null) {
                printcondition = obj.getString("printconditionvalue");
                printconditionname = obj.getString("printcondition");
            }
            if (StringUtils.isNotBlank(printcondition)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)printcondition, FilterCondition.class);
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityTypeId);
                FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
                filterBuilder.buildFilter(true);
                QFilter qfFormBillParameter = filterBuilder.getQFilter();
                if (qfFormBillParameter != null) {
                    QFilter[] filters = new QFilter[]{qfFormBillParameter, new QFilter(dt.getPrimaryKey().getName(), "in", pkIds)};
                    Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)entityTypeId, (QFilter[])filters);
                    if (!isConfirm) {
                        if (filterObjs.isEmpty()) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u7b26\u5408%s\u6253\u5370\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u6253\u5370\u3002", (String)"AbstractPrint_28", (String)"bos-noteprint", (Object[])new Object[0]), printconditionname));
                            return result;
                        }
                        if (pkIds.size() > filterObjs.size()) {
                            String confirmTip = ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5370\u65f6\uff0c\u6240\u9009\u6570\u636e\u4e2d\u5b58\u5728\u90e8\u5206\u6570\u636e\u4e0d\u6ee1\u8db3\u6253\u5370\u6761\u4ef6\uff0c\u5c06\u53ea\u6253\u5370\u6ee1\u8db3\u6253\u5370\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u6253\u5370", (String)"AbstractPrint_29", (String)"bos-noteprint", (Object[])new Object[0]);
                            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("contentChange", (AbstractOperate)this);
                            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, this.getConfirmTypes(), confirmCallBacks);
                            return result;
                        }
                    } else {
                        pkIds = filterObjs.values().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                    }
                }
            }
            if (ObjectUtils.isEmpty((Object)this.templatePkId)) {
                this.templatePkId = PrintPriorityHelper.getTemplateId(entityTypeId, pkIds, entityTypeId);
            }
            boolean isSplitEntry = false;
            if (ObjectUtils.isEmpty((Object)this.templatePkId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u6253\u5370\u65b9\u6848\uff0c\u8bf7\u5728\u3010\u811a\u672c\u6253\u5370\u65b9\u6848\u3011\u4e2d\u914d\u7f6e\u3002", (String)"ScriptPrint_2", (String)"bos-noteprint", (Object[])new Object[0]));
                result.setSuccess(false);
                return result;
            }
            String msg = "";
            Object billPkId = this.getView().getModel().getDataEntity().getPkValue();
            boolean success = false;
            try {
                success = PrintServiceHelper.createScriptPrintJob((String)entityTypeId, (Object)billPkId, (Object)this.templatePkId, (String)"", (Boolean)false, (Boolean)isSplitEntry);
            }
            catch (Exception e) {
                msg = e.getMessage();
            }
            if (success) {
                result.setSuccess(true);
                result.setShowMessage(true);
                result.setMessage(ResManager.loadKDString((String)"\u6253\u5370\u6210\u529f\u3002", (String)"ScriptPrint_3", (String)"bos-noteprint", (Object[])new Object[0]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521b\u5efa\u6253\u5370\u4efb\u52a1\u6210\u529f\u3002", (String)"ScriptPrint_4", (String)"bos-noteprint", (Object[])new Object[0]));
                PrintOperationHelper.updatePrintCountField((String)this.getEntityTypeId(), Stream.of(billPkId).collect(Collectors.toList()));
            } else {
                result.setSuccess(false);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.getView().showErrorNotification(msg);
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ScriptPrint_5", (String)"bos-noteprint", (Object[])new Object[0]));
                }
            }
        }
        return result;
    }

    private String getEntityTypeId() {
        String entityTypeId = this.getView().getFormShowParameter().getFormConfig().getEntityTypeId();
        if (this.getView() instanceof IMobileView) {
            MobileBillShowParameter mo = (MobileBillShowParameter)this.getView().getFormShowParameter();
            entityTypeId = mo.getFormConfig().getEntityTypeId();
        } else if (this.getView() instanceof IListView) {
            entityTypeId = ((ListView)this.getView()).getEntityTypeId();
        }
        return entityTypeId;
    }

    private List<Object> getPKIds() {
        ArrayList<Object> pkids = new ArrayList<Object>();
        if (this.getView() instanceof IMobileView) {
            if (!(this.getView() instanceof IMobileListView)) {
                Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
                PKFieldProp pkProp = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey();
                if (!pkProp.getValueComparator().compareValue(pkValue)) {
                    pkids.add(pkValue);
                }
            }
        } else if (this.getView() instanceof IListView) {
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            if (!listSelectedRowCollection.isEmpty()) {
                for (ListSelectedRow listSelectedRowValue : listSelectedRowCollection) {
                    Object pkv = listSelectedRowValue.getPrimaryKeyValue();
                    if (pkids.contains(pkv)) continue;
                    pkids.add(pkv);
                }
            }
        } else {
            PKFieldProp pkProp;
            Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
            if (pkValue != null && !(pkProp = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey()).getValueComparator().compareValue(pkValue)) {
                pkids.add(pkValue);
            }
        }
        return pkids;
    }
}

