/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.ParamCell;
import kd.bos.entity.param.ParamConvert;
import kd.bos.entity.param.ParamKey;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.entity.param.ParamRow;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.param.ParameterUtils;
import kd.bos.inte.api.IInteService;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.param.ParameterReader;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;

@Deprecated
public class ParameterDimenSetPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeClickListener,
SearchEnterListener,
TreeNodeQueryListener {
    private static final String ORG_FIELD = "orgfield";
    private static final String BTN_SELECT = "btnselect";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_TOOLBAR = "btntoolbar";
    private static final String TREEENTRYENTITY_KEY = "treeentryentity";
    public static final int MAX_COLUMN = 20;
    private static final String BOS_PARAMETER = "bos-parameter";
    private static final String PARAMFORMID = "paramFormId";
    private static final String ORGID = "orgId";
    private static final String PARENTID = "parentid";
    private static final String ENTRYFIELDGROUPAP = "entryfieldgroupap";
    private static final String FIELDNAMES = "fieldNames";
    private static final String CHECK = "check";
    private static final String ID = "id";
    private static final String TREEVIEWAP = "treeviewap";
    private static final String NAME = "name";
    private static final String CONTAINS = "contains";
    private static final String PARAMID = "paramId";
    private static final String VIEWTREETYPE = "viewTreeType";
    private static final String ST = "searchText";
    private static final String STT = "searchText_time";
    private static final String SD = "searchData";
    private static final String BOS_ORG_STRUCTURE = "bos_org_structure";
    private static final String IDANDORGID = "id,org.id";
    private static final String ON = "org.number";
    private static final String VIEW = "view";
    private static final String LN = "longnumber";
    private static final String TNCO = "treeNodeClickOrgId";
    private static final String EXCLAMATIONMARK = "!";
    private static final String ISLEAF = "isleaf";
    private static final String ORGNAME = "org.name";
    private static final String ORGFORID = "org.id";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{BTN_TOOLBAR});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(TREEENTRYENTITY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView tree = (TreeView)this.getControl(TREEVIEWAP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        tree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.getPageCache().put(TNCO, evt.getNodeId().toString());
        long orgId = Long.parseLong(evt.getNodeId().toString());
        this.loadData(orgId);
    }

    public void afterCreateNewData(EventObject e) {
        ParamPublishObject param = this.getParamPublishObject();
        if (this.initColumnFields(param.getSelectedFields())) {
            this.loadParaData();
        }
    }

    public void afterBindData(EventObject e) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY_KEY);
        treeEntryGrid.setCollapse(false);
        treeEntryGrid.setColumnProperty(ORG_FIELD, "isFixed", (Object)true);
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "btnselect": {
                this.showSelectForm();
                break;
            }
            case "btnsave": {
                String formId = (String)this.getView().getFormShowParameter().getCustomParam(PARAMFORMID);
                EntityMetadata entiryMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
                Map<ParamKey, ParamRow> rows = this.getRowsFromCache();
                HashMap<Long, Map<String, Boolean>> orgLockFields = new HashMap<Long, Map<String, Boolean>>(16);
                for (Map.Entry<ParamKey, ParamRow> row : rows.entrySet()) {
                    ParamKey key = row.getKey();
                    HashMap<String, Boolean> lockFields = (HashMap<String, Boolean>)orgLockFields.get(key.getOrgId());
                    if (lockFields == null) {
                        lockFields = new HashMap<String, Boolean>();
                    }
                    lockFields.put(key.getParam(), row.getValue().isLock());
                    orgLockFields.put(key.getOrgId(), lockFields);
                    Field field = entiryMetadata.getFieldByKey(key.getParam());
                    if (!(field instanceof TimeRangeField)) continue;
                    String startDateFieldKey = ((TimeRangeField)field).getStartDateFieldKey();
                    String endDateFieldKey = ((TimeRangeField)field).getEndDateFieldKey();
                    Map start = (Map)orgLockFields.get(key.getOrgId());
                    start.put(startDateFieldKey, row.getValue().isLock());
                    orgLockFields.put(key.getOrgId(), start);
                    Map end = (Map)orgLockFields.get(key.getOrgId());
                    lockFields.put(endDateFieldKey, row.getValue().isLock());
                    orgLockFields.put(key.getOrgId(), end);
                }
                this.updateParamLock(orgLockFields);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ParameterDimenSetPlugin_0", (String)BOS_PARAMETER, (Object[])new Object[0]));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object retData = closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        Map data = (Map)retData;
        String fields = data.get("selectedFields").toString();
        boolean first = Boolean.parseBoolean(data.get("first").toString());
        this.saveSelectedParams(fields);
        if (this.initColumnFields(fields)) {
            if (first) {
                this.loadParaData();
            } else {
                long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam(ORGID).toString());
                this.loadData(orgId);
            }
        }
    }

    private void showSelectForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_param_select");
        parameter.setCustomParam(PARAMFORMID, this.getView().getFormShowParameter().getCustomParam(PARAMFORMID));
        parameter.setCustomParam("selectedFields", (Object)this.getParamPublishObject().getSelectedFields());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectParams"));
        this.getView().showForm(parameter);
    }

    private void loadParaData() {
        long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam(ORGID).toString());
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        String viewType = (String)this.getView().getFormShowParameter().getCustomParam(VIEWTREETYPE);
        String orgName = OrgServiceHelper.getOrgFullName((String)viewType, (long)orgId);
        ArrayList<Map<String, Object>> newOrgs = new ArrayList<Map<String, Object>>();
        List orgs = OrgViewServiceHelper.getAllChildrenData((String)String.valueOf(orgId), (String)viewType);
        HashMap<String, Object> parentOrg = new HashMap<String, Object>();
        parentOrg.put(ID, orgId);
        parentOrg.put(PARENTID, 0);
        parentOrg.put(NAME, orgName.substring(orgName.lastIndexOf(95) + 1, orgName.length()));
        newOrgs.add(parentOrg);
        if (((Boolean)this.getModel().getValue(CONTAINS)).booleanValue()) {
            newOrgs.addAll(orgs);
        }
        TreeNode root = new TreeNode("", String.valueOf(orgId), orgName.substring(orgName.lastIndexOf(95) + 1, orgName.length()));
        treeView.addNode(root);
        treeView.focusNode(root);
        treeView.expand(String.valueOf(orgId));
        ArrayList<TreeNode> tnList = new ArrayList<TreeNode>();
        for (Object org : orgs) {
            String id;
            if (!String.valueOf(orgId).equals(String.valueOf(org.get(PARENTID))) || "0".equals(id = String.valueOf(org.get(ID)))) continue;
            TreeNode tn = new TreeNode(String.valueOf(org.get(PARENTID)), id, String.valueOf(org.get(NAME)));
            if ("0".equals(String.valueOf(org.get(ISLEAF)))) {
                tn.setChildren(new ArrayList());
            }
            tnList.add(tn);
        }
        treeView.addNodes(tnList);
        orgs.add(parentOrg);
        ArrayList<Long> orgList = new ArrayList<Long>(10);
        for (Map org : orgs) {
            orgList.add((Long)org.get(ID));
        }
        if (!orgs.isEmpty()) {
            String formId = (String)this.getView().getFormShowParameter().getCustomParam(PARAMFORMID);
            String paramId = (String)this.getView().getFormShowParameter().getCustomParam(PARAMID);
            DynamicObjectCollection collection = ParameterUtils.queryAllOrgParams(orgList, (String)viewType, (String)paramId);
            List orgParams = ParameterHelper.getOrgsFormatParams((DynamicObjectCollection)collection, (String)formId);
            if (orgParams == null || orgParams.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u4fdd\u5b58\u53c2\u6570\u65b9\u6848\uff0c\u4e0d\u80fd\u542f\u7528\u96c6\u56e2\u7ba1\u63a7\uff0c\u8bf7\u8fd4\u56de\u53c2\u6570\u914d\u7f6e\u754c\u9762\u4fdd\u5b58\u53c2\u6570\u3002", (String)"ParameterDimenSetPlugin_1", (String)BOS_PARAMETER, (Object[])new Object[0]));
            }
            List paramItems = ParamConvert.getParamItems((String)formId);
            Map rows = ParamConvert.getParamFormatRows((List)orgParams, (List)paramItems);
            List<Long> supOrgs = this.getSuperioOrgs(orgId, viewType, orgs);
            rows.putAll(ParameterUtils.getOrgParamRows((String)formId, (String)viewType, (String)paramId, supOrgs));
            this.getModel().beginInit();
            this.draw(newOrgs, paramItems, rows);
            this.getModel().endInit();
        }
    }

    private List<Long> getSuperioOrgs(long orgId, String viewType, List<Map<String, Object>> subOrgs) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        long currentId = orgId;
        while (currentId != 0L) {
            orgIds.add(currentId);
            List ids = OrgUnitServiceHelper.getSuperiorOrgs((String)viewType, (long)currentId);
            if (ids == null || ids.isEmpty()) break;
            currentId = (Long)ids.get(0);
        }
        QFilter filter = new QFilter("org", "in", orgIds);
        QFilter filter2 = new QFilter("view.number", "=", (Object)viewType);
        QFilter[] qFilters = new QFilter[]{filter, filter2};
        List supOrgs = ParameterHelper.getOrgStructureByFilter((QFilter[])qFilters);
        supOrgs.addAll(subOrgs.stream().filter(org -> Long.parseLong(org.get(ID).toString()) != orgId).collect(Collectors.toList()));
        this.getPageCache().put("allOrgs", SerializationUtils.toJsonString((Object)supOrgs));
        return orgIds;
    }

    private void removeGroupControlFields(List<String> allFields) {
        String[] gcFieldArr;
        String gcFields = (String)this.getView().getFormShowParameter().getCustomParam("gcLockFieldKey");
        if (StringUtils.isBlank((CharSequence)gcFields) || allFields == null || allFields.isEmpty()) {
            return;
        }
        for (String f : gcFieldArr = gcFields.split(",")) {
            allFields.removeIf(item -> item.equals(f));
        }
    }

    private boolean initColumnFields(String fields) {
        int i;
        String[] fieldArr = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)fields)) {
            fieldArr = fields.split(",");
        }
        String paramId = (String)this.getView().getFormShowParameter().getCustomParam(PARAMFORMID);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)paramId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        formMetadata.createIndex();
        List controlAps = formMetadata.getItems();
        List<String> fieldNames = this.replaceFieldName(controlAps, fieldArr);
        this.removeGroupControlFields(fieldNames);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY_KEY);
        HashMap<String, String> header = null;
        for (i = 1; i < fieldNames.size() + 1; ++i) {
            String field = fieldArr[i - 1];
            LocaleString ls = this.getFieldNameById(field, controlAps);
            header = new HashMap<String, String>();
            header.put("en_US", ls.getLocaleValue_en());
            header.put("zh_TW", ls.getLocaleValue_zh_TW());
            header.put("zh_CN", ls.getLocaleValue_zh_CN());
            treeEntryGrid.setColumnProperty(ENTRYFIELDGROUPAP + i, "header", header);
            treeEntryGrid.setColumnProperty(ENTRYFIELDGROUPAP + i, "visible", (Object)true);
        }
        for (i = fieldNames.size() + 1; i <= 20; ++i) {
            treeEntryGrid.setColumnProperty(ENTRYFIELDGROUPAP + i, "visible", (Object)false);
        }
        this.getPageCache().put(FIELDNAMES, SerializationUtils.toJsonString(fieldNames));
        if (StringUtils.isBlank((CharSequence)fields)) {
            this.showSelectForm();
            this.getView().updateView(TREEENTRYENTITY_KEY);
            return false;
        }
        return true;
    }

    private void draw(List<Map<String, Object>> orgs, List<String> paramItems, Map<ParamKey, ParamRow> rows) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(PARAMFORMID);
        EntityMetadata entiryMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        if (!rows.isEmpty()) {
            List fieldNames = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(FIELDNAMES), String.class);
            List allOrgs = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("allOrgs"), Map.class);
            for (Map<String, Object> org : orgs) {
                long id = Long.parseLong(org.get(ID).toString());
                for (String item : paramItems) {
                    ParamCell cell = ParamConvert.getParamValue(rows, (long)id, (String)item, (List)allOrgs);
                    if (cell == null) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u4fdd\u5b58\u53c2\u6570\u503c\u3002id=%1,item=%2", (String)"ParameterDimenSetPlugin_2", (String)BOS_PARAMETER, (Object[])new Object[]{id, item}));
                        return;
                    }
                    org.put(cell.getKey().getParam(), cell.getValue());
                    org.put(CHECK + (fieldNames.indexOf(item) + 1), cell.isLock());
                    org.put("isOwnCheck" + (fieldNames.indexOf(item) + 1), cell.isOwnLock());
                    org.put("isOwnValue" + (fieldNames.indexOf(item) + 1), cell.isOwnValue());
                }
            }
            this.getModel().deleteEntryData(TREEENTRYENTITY_KEY);
            this.getModel().batchCreateNewEntryRow(TREEENTRYENTITY_KEY, orgs.size());
            DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY_KEY);
            for (int i = 0; i < orgs.size(); ++i) {
                Map<String, Object> org = orgs.get(i);
                DynamicObject target = (DynamicObject)treeEntryEntity.get(i);
                target.set(ID, org.get(ID));
                target.set("pid", org.get(PARENTID));
                target.set(ORG_FIELD, org.get(NAME));
                for (int j = 1; j < fieldNames.size() + 1; ++j) {
                    String fieldName = (String)fieldNames.get(j - 1);
                    Field field = entiryMetadata.getFieldByKey(fieldName);
                    if (field instanceof TimeRangeField) {
                        String startDateFieldKey = ((TimeRangeField)field).getStartDateFieldKey();
                        ParamCell startCell = ParamConvert.getParamValue(rows, (long)Long.parseLong(org.get(ID).toString()), (String)startDateFieldKey, (List)allOrgs);
                        Object startValue = startCell.getValue();
                        String endDateFieldKey = ((TimeRangeField)field).getEndDateFieldKey();
                        ParamCell endCell = ParamConvert.getParamValue(rows, (long)Long.parseLong(org.get(ID).toString()), (String)endDateFieldKey, (List)allOrgs);
                        Object endValue = endCell.getValue();
                        String time = "";
                        String startTime = this.formatTime((Integer)startValue);
                        String endTime = this.formatTime((Integer)endValue);
                        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
                            time = startTime + "~" + endTime;
                        }
                        target.set("textfield" + j, (Object)time);
                        target.set(CHECK + j, (Object)startCell.isLock());
                        if (startCell.isLock() && !startCell.isOwnLock()) {
                            FieldEdit edit = (FieldEdit)this.getView().getControl(CHECK + j);
                            edit.setEnable("", Boolean.FALSE.booleanValue(), i);
                        }
                    } else if (field instanceof BasedataPropField) {
                        String refId = ((BasedataPropField)field).getRefBaseFieldId();
                        String refFiedKey = entiryMetadata.getFieldById(refId).getKey();
                        ParamCell cell = ParamConvert.getParamValue(rows, (long)Long.parseLong(org.get(ID).toString()), (String)refFiedKey, (List)allOrgs);
                        target.set("textfield" + j, cell.getValue());
                        target.set(CHECK + j, (Object)cell.isLock());
                        FieldEdit edit = (FieldEdit)this.getView().getControl(CHECK + j);
                        edit.setEnable("", Boolean.FALSE.booleanValue(), i);
                    } else {
                        target.set("textfield" + j, org.get(fieldName));
                        target.set(CHECK + j, org.get(CHECK + j));
                        if (org.get(CHECK + j) == null || ((Boolean)org.get(CHECK + j)).booleanValue() && !((Boolean)org.get("isOwnCheck" + j)).booleanValue()) {
                            FieldEdit edit = (FieldEdit)this.getView().getControl(CHECK + j);
                            edit.setEnable("", Boolean.FALSE.booleanValue(), i);
                        }
                    }
                    FieldEdit textFieldEdit = (FieldEdit)this.getView().getControl("textfield" + j);
                    textFieldEdit.setEnable("", Boolean.FALSE.booleanValue(), i);
                }
            }
        }
        this.getView().updateView(TREEENTRYENTITY_KEY);
        this.getPageCache().put("rows", SerializationUtils.toJsonString(rows));
        this.getPageCache().put("paramItems", SerializationUtils.toJsonString(paramItems));
        this.getPageCache().put("orgs", SerializationUtils.toJsonString(orgs));
    }

    private String getTime(Integer time) {
        if (time != null && time >= 0) {
            Integer hour = time / 3600;
            time = time % 3600;
            Integer minutes = time / 60;
            Integer second = time % 60;
            String result = (hour < 10 ? "0" : "") + hour + ":" + (minutes < 10 ? "0" : "") + minutes + ":" + (second < 10 ? "0" : "") + second;
            return result;
        }
        return "0";
    }

    private String formatTime(Integer time) {
        if (time != null && time >= 0) {
            String result = this.getTime(time);
            IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
            Long userId = RequestContext.get().getCurrUserId();
            Map timeFormat = inteService.getTimeFormat(userId);
            try {
                Date data = new SimpleDateFormat("HH:mm:ss").parse(result);
                return new SimpleDateFormat((String)timeFormat.get("timeFormat")).format(data);
            }
            catch (ParseException e) {
                return "";
            }
        }
        return "";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        if (prop instanceof BooleanProp && prop.getName().startsWith(CHECK)) {
            String paramItemsCache;
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            long orgId = (Long)this.getModel().getValue(ID, rowIndex);
            boolean isLock = false;
            if (e.getChangeSet()[0].getNewValue() != null) {
                isLock = (Boolean)e.getChangeSet()[0].getNewValue();
            }
            if (StringUtils.isBlank((CharSequence)(paramItemsCache = this.getPageCache().get("paramItems")))) {
                return;
            }
            List paramItems = SerializationUtils.fromJsonStringToList((String)paramItemsCache, String.class);
            List orgs = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("orgs"), Map.class);
            List fieldNames = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(FIELDNAMES), String.class);
            Map<ParamKey, ParamRow> rows = this.getRowsFromCache();
            int index = Integer.parseInt(prop.getName().replace(CHECK, ""));
            ParamConvert.updateLock((String)((String)fieldNames.get(index - 1)), (long)orgId, (boolean)isLock, rows);
            this.getModel().beginInit();
            this.draw(orgs, paramItems, rows);
            this.getModel().endInit();
            this.getPageCache().put("rows", SerializationUtils.toJsonString(rows));
        } else if (CONTAINS.equals(prop.getName())) {
            String treeNodeClickOrgId = this.getPageCache().get(TNCO);
            long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam(ORGID).toString());
            if (treeNodeClickOrgId != null) {
                orgId = Long.parseLong(treeNodeClickOrgId);
            }
            this.loadData(orgId);
        }
    }

    private Map<ParamKey, ParamRow> getRowsFromCache() {
        HashMap<ParamKey, ParamRow> newRows = new HashMap<ParamKey, ParamRow>();
        String rowsObj = this.getPageCache().get("rows");
        if (StringUtils.isNotBlank((CharSequence)rowsObj)) {
            Map rows = (Map)SerializationUtils.fromJsonString((String)rowsObj, Map.class);
            for (Map.Entry row : rows.entrySet()) {
                Map obj = (Map)row.getValue();
                Map keyMap = (Map)obj.get("key");
                ParamKey key = new ParamKey(keyMap.get("param").toString(), Long.parseLong(keyMap.get(ORGID).toString()));
                ParamRow tmpRow = new ParamRow(key, obj.get("value"), ((Boolean)obj.get("lock")).booleanValue());
                newRows.put(key, tmpRow);
            }
        }
        return newRows;
    }

    private Map<String, Object> getOrgParams(Map<String, Object> org, List<Map<String, Object>> orgs, List<Map<String, Object>> orgParams) {
        for (Map<String, Object> param : orgParams) {
            if (!param.get(ORGID).equals(org.get(ID))) continue;
            return param;
        }
        for (Map<String, Object> tmpOrg : orgs) {
            if (!org.get(PARENTID).equals(tmpOrg.get(ID))) continue;
            return this.getOrgParams(tmpOrg, orgs, orgParams);
        }
        return null;
    }

    private List<String> replaceFieldName(List<ControlAp<?>> aps, String[] fields) {
        ArrayList<String> result = new ArrayList<String>();
        block0: for (int i = 0; i < fields.length; ++i) {
            for (ControlAp<?> ap : aps) {
                FieldAp fap;
                if (!(ap instanceof FieldAp) || !(fap = (FieldAp)ap).getFieldId().equals(fields[i])) continue;
                result.add(ap.getKey());
                continue block0;
            }
        }
        return result;
    }

    private LocaleString getFieldNameById(String fieldId, List<ControlAp<?>> controlAps) {
        for (ControlAp<?> ap : controlAps) {
            if (!(ap instanceof FieldAp) || !((FieldAp)ap).getFieldId().equals(fieldId)) continue;
            return ap.getName();
        }
        return new LocaleString(ResManager.loadKDString((String)"\u53c2\u6570", (String)"ParameterDimenSetPlugin_3", (String)BOS_PARAMETER, (Object[])new Object[0]));
    }

    private ParamPublishObject getParamPublishObject() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(PARAMFORMID);
        return ParameterReader.getParameterObjByFormId((String)formId);
    }

    private void saveSelectedParams(String fields) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(PARAMFORMID);
        ParameterHelper.saveSysParameterFieldsByFormId((String)formId, (String)fields);
    }

    private void updateParamLock(Map<Long, Map<String, Boolean>> lockFields) {
        String viewTreeType = (String)this.getView().getFormShowParameter().getCustomParam(VIEWTREETYPE);
        String paramId = (String)this.getView().getFormShowParameter().getCustomParam(PARAMID);
        int accountBook = 0;
        int acctingBook = 0;
        for (Map.Entry<Long, Map<String, Boolean>> field : lockFields.entrySet()) {
            Throwable throwable;
            TXHandle h;
            String sql = " SELECT FDATA FROM T_BAS_SYSPARAMETER WHERE FORGID=? AND FVIEWTYPEID=? AND FACCTBOOKID=? AND FACCTINGBOOKID=? AND FPARAMID=? ";
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            params.add(new SqlParameter(":FORGID", -5, (Object)field.getKey()));
            params.add(new SqlParameter(":FVIEWTYPEID", 12, (Object)viewTreeType));
            params.add(new SqlParameter(":FACCTBOOKID", 4, (Object)accountBook));
            params.add(new SqlParameter(":FACCTINGBOOKID", 4, (Object)acctingBook));
            params.add(new SqlParameter(":FPARAMID", 12, (Object)paramId));
            DynamicObjectCollection existData = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            if (existData == null || existData.isEmpty()) {
                sql = "insert into T_BAS_SYSPARAMETER(FID,FORGID,FVIEWTYPEID,FACCTBOOKID,FACCTINGBOOKID,FPARAMID,FLOCKFIELDS) values(?,?,?,?,?,?,?)";
                params.add(0, new SqlParameter(":FID", 12, (Object)Uuid16.create().toString()));
                params.add(new SqlParameter(":FLOCKFIELDS", 12, (Object)SerializationUtils.toJsonString(field.getValue())));
                h = TX.requiresNew();
                throwable = null;
                try {
                    DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h == null) continue;
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    h.close();
                    continue;
                }
            }
            sql = "update T_BAS_SYSPARAMETER set FLOCKFIELDS=? where FORGID=? and FVIEWTYPEID=? and FACCTBOOKID=? and FACCTINGBOOKID=? and FPARAMID=?";
            params.add(0, new SqlParameter(":FLOCKFIELDS", 12, (Object)SerializationUtils.toJsonString(field.getValue())));
            h = TX.requiresNew();
            throwable = null;
            try {
                DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                h.close();
            }
        }
    }

    private void loadData(long orgId) {
        String viewType = (String)this.getView().getFormShowParameter().getCustomParam(VIEWTREETYPE);
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        String orgName = OrgServiceHelper.getOrgFullName((String)viewType, (long)orgId);
        ArrayList<Map<String, Object>> orgs = new ArrayList<Map<String, Object>>(10);
        List subOrgs = OrgViewServiceHelper.getAllChildrenData((String)String.valueOf(orgId), (String)viewType);
        HashMap<String, Object> currentOrg = new HashMap<String, Object>(16);
        currentOrg.put(ID, orgId);
        currentOrg.put(PARENTID, 0);
        currentOrg.put(NAME, orgName.substring(orgName.lastIndexOf(95) + 1, orgName.length()));
        orgs.add(currentOrg);
        ArrayList<TreeNode> tnList = new ArrayList<TreeNode>(10);
        for (Object org : subOrgs) {
            String string;
            if (!String.valueOf(orgId).equals(String.valueOf(org.get(PARENTID))) || "0".equals(string = String.valueOf(org.get(ID)))) continue;
            TreeNode tn = new TreeNode(String.valueOf(org.get(PARENTID)), string, String.valueOf(org.get(NAME)));
            if ("0".equals(String.valueOf(org.get(ISLEAF)))) {
                tn.setChildren(new ArrayList());
            }
            tnList.add(tn);
        }
        treeView.addNodes(tnList);
        treeView.expand(String.valueOf(orgId));
        treeView.focusNode(new TreeNode("", String.valueOf(orgId), orgName.substring(orgName.lastIndexOf(95) + 1, orgName.length())));
        if (((Boolean)this.getModel().getValue(CONTAINS)).booleanValue()) {
            long rootOrgId = ParameterOrgUtils.getParamRootOrgId();
            if (orgId == rootOrgId) {
                ArrayList<Map> arrayList = new ArrayList<Map>(10);
                for (Map so : subOrgs) {
                    if (!String.valueOf(rootOrgId).equals(so.get(PARENTID).toString()) || "0".equals(so.get(ID).toString())) continue;
                    arrayList.add(so);
                }
                orgs.addAll(arrayList);
            } else {
                orgs.addAll(subOrgs);
            }
        }
        ArrayList<Long> orgList = new ArrayList<Long>(10);
        for (Map map : orgs) {
            orgList.add((Long)map.get(ID));
        }
        if (!orgs.isEmpty()) {
            String formId = (String)this.getView().getFormShowParameter().getCustomParam(PARAMFORMID);
            String string = (String)this.getView().getFormShowParameter().getCustomParam(PARAMID);
            DynamicObjectCollection collection = ParameterUtils.queryAllOrgParams(orgList, (String)viewType, (String)string);
            List orgParams = ParameterHelper.getOrgsFormatParams((DynamicObjectCollection)collection, (String)formId);
            List paramItems = ParamConvert.getParamItems((String)formId);
            Map rows = ParamConvert.getParamFormatRows((List)orgParams, (List)paramItems);
            List<Long> supOrgs = this.getSuperioOrgs(orgId, viewType, orgs);
            rows.putAll(ParameterUtils.getOrgParamRows((String)formId, (String)viewType, (String)string, supOrgs));
            this.getModel().beginInit();
            this.draw(orgs, paramItems, rows);
            this.getModel().endInit();
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText;
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        String searchTextFormCache = this.getPageCache().get(ST);
        String searchTextTimeString = this.getPageCache().get(STT);
        String searchIdAndOrgIdAndOrgName = "id,org.id,org.name";
        int searchTextTime = 1;
        String viewType = (String)this.getView().getFormShowParameter().getCustomParam(VIEWTREETYPE);
        if (StringUtils.isNotBlank((CharSequence)searchTextTimeString)) {
            searchTextTime = Integer.parseInt(searchTextTimeString);
        }
        if ((searchText = searchEnterEvent.getText()).equals(searchTextFormCache)) {
            String searchDataString = this.getPageCache().get(SD);
            List list = new ArrayList();
            if (searchDataString != null) {
                list = SerializationUtils.fromJsonStringToList((String)searchDataString, TreeNode.class);
                if (!list.isEmpty()) {
                    if (list.size() > searchTextTime) {
                        TreeNode focusNode = (TreeNode)list.get(searchTextTime);
                        String longNumber = focusNode.getLongNumber();
                        String[] number = null;
                        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
                            number = longNumber.split(EXCLAMATIONMARK);
                            Map parentOrgs = BusinessDataServiceHelper.loadFromCache((String)BOS_ORG_STRUCTURE, (String)IDANDORGID, (QFilter[])new QFilter[]{new QFilter(VIEW, "=", (Object)Long.parseLong(viewType)), new QFilter(ON, "in", (Object)number)});
                            DynamicObject firstLevelOrg = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_ORG_STRUCTURE, (String)IDANDORGID, (QFilter[])new QFilter[]{new QFilter(VIEW, "=", (Object)Long.parseLong(viewType)), new QFilter(ON, "=", (Object)number[0])});
                            DynamicObject secondLevelOrg = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_ORG_STRUCTURE, (String)searchIdAndOrgIdAndOrgName, (QFilter[])new QFilter[]{new QFilter(VIEW, "=", (Object)Long.parseLong(viewType)), new QFilter(ON, "=", (Object)number[1])});
                            List subOrgs = OrgViewServiceHelper.getAllChildrenData((String)secondLevelOrg.getString(ORGFORID), (String)viewType);
                            ArrayList<TreeNode> tnList = new ArrayList<TreeNode>();
                            for (Map map : subOrgs) {
                                String[] orgLongNumber;
                                String id = String.valueOf(map.get(ID));
                                if ("0".equals(id)) continue;
                                TreeNode tn = new TreeNode(String.valueOf(map.get(PARENTID)), id, String.valueOf(map.get(NAME)));
                                if ("0".equals(String.valueOf(map.get(ISLEAF)))) {
                                    tn.setChildren(new ArrayList());
                                }
                                if ((orgLongNumber = map.get(LN).toString().split(EXCLAMATIONMARK)).length > number.length || orgLongNumber.length == number.length && !orgLongNumber[orgLongNumber.length - 2].equals(number[number.length - 2])) continue;
                                tnList.add(tn);
                            }
                            tnList.add(new TreeNode(firstLevelOrg.getString(ORGFORID), secondLevelOrg.getString(ORGFORID), secondLevelOrg.getString(ORGNAME)));
                            treeView.addNodes(tnList);
                            for (Map.Entry entry : parentOrgs.entrySet()) {
                                treeView.expand(((DynamicObject)entry.getValue()).getString(ORGFORID));
                            }
                        }
                        this.loadData(Long.parseLong(focusNode.getId()));
                        this.getPageCache().put(TNCO, focusNode.getId());
                        treeView.focusNode(focusNode);
                        this.getPageCache().put(STT, String.valueOf(searchTextTime + 1));
                    } else {
                        TreeNode focusNode = (TreeNode)list.get(0);
                        String longNumber = focusNode.getLongNumber();
                        String[] number = null;
                        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
                            number = longNumber.split(EXCLAMATIONMARK);
                            Map parentOrgs = BusinessDataServiceHelper.loadFromCache((String)BOS_ORG_STRUCTURE, (String)IDANDORGID, (QFilter[])new QFilter[]{new QFilter(VIEW, "=", (Object)Long.parseLong(viewType)), new QFilter(ON, "in", (Object)number)});
                            DynamicObject firstLevelOrg = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_ORG_STRUCTURE, (String)IDANDORGID, (QFilter[])new QFilter[]{new QFilter(VIEW, "=", (Object)Long.parseLong(viewType)), new QFilter(ON, "=", (Object)number[0])});
                            DynamicObject secondLevelOrg = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_ORG_STRUCTURE, (String)searchIdAndOrgIdAndOrgName, (QFilter[])new QFilter[]{new QFilter(VIEW, "=", (Object)Long.parseLong(viewType)), new QFilter(ON, "=", (Object)number[1])});
                            List subOrgs = OrgViewServiceHelper.getAllChildrenData((String)secondLevelOrg.getString(ORGFORID), (String)viewType);
                            ArrayList<TreeNode> tnList = new ArrayList<TreeNode>();
                            for (Map map : subOrgs) {
                                String[] orgLongNumber;
                                String id = String.valueOf(map.get(ID));
                                if ("0".equals(id)) continue;
                                TreeNode tn = new TreeNode(String.valueOf(map.get(PARENTID)), id, String.valueOf(map.get(NAME)));
                                if ("0".equals(String.valueOf(map.get(ISLEAF)))) {
                                    tn.setChildren(new ArrayList());
                                }
                                if ((orgLongNumber = map.get(LN).toString().split(EXCLAMATIONMARK)).length > number.length || orgLongNumber.length == number.length && !orgLongNumber[orgLongNumber.length - 2].equals(number[number.length - 2])) continue;
                                tnList.add(tn);
                            }
                            tnList.add(new TreeNode(firstLevelOrg.getString(ORGFORID), secondLevelOrg.getString(ORGFORID), secondLevelOrg.getString(ORGNAME)));
                            treeView.addNodes(tnList);
                            for (Map.Entry entry : parentOrgs.entrySet()) {
                                treeView.expand(((DynamicObject)entry.getValue()).getString(ORGFORID));
                            }
                        }
                        this.loadData(Long.parseLong(focusNode.getId()));
                        this.getPageCache().put(TNCO, focusNode.getId());
                        treeView.focusNode(focusNode);
                        this.getPageCache().put(STT, "1");
                    }
                } else {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e0e\u201c%s\u201d\u7684\u76f8\u5173\u6570\u636e\u3002", (String)"ParameterDimenSetPlugin_4", (String)BOS_PARAMETER, (Object[])new Object[0]), searchText));
                }
            }
            this.getPageCache().put(ST, searchText);
            this.getPageCache().put(SD, SerializationUtils.toJsonString(list));
        } else {
            long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam(ORGID).toString());
            String orgName = OrgServiceHelper.getOrgFullName((String)viewType, (long)orgId);
            List orgs = OrgViewServiceHelper.getAllChildrenData((String)String.valueOf(orgId), (String)viewType);
            HashMap<String, Object> parentOrg = new HashMap<String, Object>();
            parentOrg.put(ID, orgId);
            parentOrg.put(PARENTID, 0);
            parentOrg.put(NAME, orgName.substring(orgName.lastIndexOf(95) + 1, orgName.length()));
            orgs.add(parentOrg);
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (Map org : orgs) {
                String name = (String)org.get(NAME);
                Object parentid = org.get(PARENTID);
                Object id = org.get(ID);
                String string = (String)org.get(LN);
                if (!name.contains(searchText)) continue;
                TreeNode tn = new TreeNode(String.valueOf(parentid), String.valueOf(id), name);
                tn.setLongNumber(string);
                list.add(tn);
            }
            if (list.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e0e\u201c%s\u201d\u7684\u76f8\u5173\u6570\u636e\u3002", (String)"ParameterDimenSetPlugin_4", (String)BOS_PARAMETER, (Object[])new Object[0]), searchText));
            } else {
                TreeNode focusNode = (TreeNode)list.get(0);
                String longNumber = focusNode.getLongNumber();
                String[] number = null;
                if (StringUtils.isNotBlank((CharSequence)longNumber)) {
                    number = longNumber.split(EXCLAMATIONMARK);
                    Map parentOrgs = BusinessDataServiceHelper.loadFromCache((String)BOS_ORG_STRUCTURE, (String)IDANDORGID, (QFilter[])new QFilter[]{new QFilter(VIEW, "=", (Object)Long.parseLong(viewType)), new QFilter(ON, "in", (Object)number)});
                    DynamicObject firstLevelOrg = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_ORG_STRUCTURE, (String)IDANDORGID, (QFilter[])new QFilter[]{new QFilter(VIEW, "=", (Object)Long.parseLong(viewType)), new QFilter(ON, "=", (Object)number[0])});
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_ORG_STRUCTURE, (String)searchIdAndOrgIdAndOrgName, (QFilter[])new QFilter[]{new QFilter(VIEW, "=", (Object)Long.parseLong(viewType)), new QFilter(ON, "=", (Object)number[1])});
                    List subOrgs = OrgViewServiceHelper.getAllChildrenData((String)dynamicObject.getString(ORGFORID), (String)viewType);
                    ArrayList<TreeNode> tnList = new ArrayList<TreeNode>();
                    for (Map map : subOrgs) {
                        String[] orgLongNumber;
                        String id = String.valueOf(map.get(ID));
                        if ("0".equals(id)) continue;
                        TreeNode tn = new TreeNode(String.valueOf(map.get(PARENTID)), id, String.valueOf(map.get(NAME)));
                        if ("0".equals(String.valueOf(map.get(ISLEAF)))) {
                            tn.setChildren(new ArrayList());
                        }
                        if ((orgLongNumber = map.get(LN).toString().split(EXCLAMATIONMARK)).length > number.length || orgLongNumber.length == number.length && !orgLongNumber[orgLongNumber.length - 2].equals(number[number.length - 2])) continue;
                        tnList.add(tn);
                    }
                    tnList.add(new TreeNode(firstLevelOrg.getString(ORGFORID), dynamicObject.getString(ORGFORID), dynamicObject.getString(ORGNAME)));
                    treeView.addNodes(tnList);
                    for (Map.Entry entry : parentOrgs.entrySet()) {
                        treeView.expand(((DynamicObject)entry.getValue()).getString(ORGFORID));
                    }
                }
                this.loadData(Long.parseLong(focusNode.getId()));
                this.getPageCache().put(TNCO, focusNode.getId());
                treeView.focusNode(focusNode);
            }
            this.getPageCache().put(ST, searchText);
            this.getPageCache().put(STT, "1");
            this.getPageCache().put(SD, SerializationUtils.toJsonString(list));
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
        String viewType = (String)this.getView().getFormShowParameter().getCustomParam(VIEWTREETYPE);
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        String nodeId = (String)arg0.getNodeId();
        String parentId = (String)arg0.getParentNodeId();
        List subOrgs = OrgViewServiceHelper.getAllChildrenData((String)nodeId, (String)viewType);
        String orgName = OrgServiceHelper.getOrgFullName((String)viewType, (long)Long.parseLong(nodeId));
        ArrayList<TreeNode> tnList = new ArrayList<TreeNode>();
        for (Map org : subOrgs) {
            String id;
            if (!nodeId.equals(String.valueOf(org.get(PARENTID))) || "0".equals(id = String.valueOf(org.get(ID)))) continue;
            TreeNode tn = new TreeNode(String.valueOf(org.get(PARENTID)), id, String.valueOf(org.get(NAME)));
            if ("0".equals(String.valueOf(org.get(ISLEAF)))) {
                tn.setChildren(new ArrayList());
            }
            tnList.add(tn);
        }
        treeView.addNodes(tnList);
        treeView.expand(nodeId);
        treeView.focusNode(new TreeNode(parentId, nodeId, orgName.substring(orgName.lastIndexOf(95) + 1, orgName.length())));
    }
}

