/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;

@Deprecated
public class ParameterSelectPlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener,
F7SelectedListRemoveListener {
    private static final String TREEKEY = "treeviewap";
    private static final String F7LIST = "f7selectedlistap";
    private static final String BTNOK = "btnok";
    private static final String SELECTEDFIELDS = "selectedFields";
    private static final String ENTITYMETA = "entitymeta";

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK});
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7LIST);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String paramId = (String)this.getView().getFormShowParameter().getCustomParam("paramFormId");
        String fieldStr = (String)this.getView().getFormShowParameter().getCustomParam(SELECTEDFIELDS);
        if (fieldStr == null) {
            fieldStr = "";
        }
        String[] fields = fieldStr.split(",");
        List<TreeNode> nodes = this.buildAllTree(paramId);
        TreeNode root = nodes.remove(0);
        root.setChildren(this.getChildren(root.getId(), nodes));
        this.removeEmptyNodes(root);
        TreeView treeView = (TreeView)this.getControl(TREEKEY);
        treeView.addNode(root);
        this.setCheckedNodes(fields, treeView, root);
        this.getPageCache().put("tree", SerializationUtils.toJsonString((Object)root));
    }

    private void setCheckedNodes(String[] fields, TreeView treeView, TreeNode root) {
        ArrayList<TreeNode> checkedNodes = new ArrayList<TreeNode>();
        if (fields.length > 0) {
            for (String field : fields) {
                TreeNode node2 = root.getTreeNode(field, 16);
                if (node2 == null) continue;
                checkedNodes.add(node2);
            }
        }
        F7SelectedList f7 = (F7SelectedList)this.getControl(F7LIST);
        treeView.checkNodes(checkedNodes);
        checkedNodes.removeIf(node -> !node.getType().equals(ENTITYMETA));
        List items = checkedNodes.stream().map(node -> new ValueTextItem(node.getId(), node.getText())).collect(Collectors.toList());
        f7.addItems(items);
        this.getPageCache().put(SELECTEDFIELDS, SerializationUtils.toJsonString(items));
    }

    private List<TreeNode> buildAllTree(String paramId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)paramId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)paramId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        formMetadata.createIndex();
        List controlAps = formMetadata.getItems();
        TreeNode root = null;
        TreeNode node = null;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (ControlAp ap : controlAps) {
            ContainerAp cp;
            if (entityMetadata.getFieldByKey(ap.getKey()) instanceof RadioField || ap instanceof ContainerAp && (cp = (ContainerAp)ap).getItems().isEmpty()) continue;
            if (ap instanceof FormAp) {
                root = new TreeNode();
                root.setText(ap.getName().getLocaleValue());
                root.setId(ap.getId());
                root.setType("root");
                nodes.add(root);
                continue;
            }
            node = new TreeNode();
            node.setData((Object)ap.getKey());
            node.setId(ap.getId());
            node.setText(ap.getName().getLocaleValue());
            node.setIsOpened(true);
            node.setParentid(ap.getParentId());
            if (ap instanceof FieldAp) {
                Field field = entityMetadata.getFieldByKey(ap.getKey());
                if (field.isGroupControl()) continue;
                node.setType(ENTITYMETA);
            } else {
                node.setType("formmeta");
            }
            if (node == null) continue;
            nodes.add(node);
        }
        if (root != null) {
            root.setIsOpened(true);
        }
        return nodes;
    }

    private List<TreeNode> getChildren(String id, List<TreeNode> nodes) {
        ArrayList<TreeNode> childList = new ArrayList<TreeNode>();
        for (TreeNode node : nodes) {
            if (!StringUtils.isNotBlank((CharSequence)node.getParentid()) || !node.getParentid().equals(id)) continue;
            childList.add(node);
        }
        for (TreeNode node : childList) {
            if (!StringUtils.isNotBlank((CharSequence)node.getId())) continue;
            node.setChildren(this.getChildren(node.getId(), nodes));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    private void removeEmptyNodes(TreeNode root) {
        if (root.getChildren() == null) {
            return;
        }
        Iterator nodes = root.getChildren().iterator();
        while (nodes.hasNext()) {
            TreeNode node = (TreeNode)nodes.next();
            if (node.getChildren() != null) {
                this.removeEmptyNodes(node);
                continue;
            }
            if (!"formmeta".equals(node.getType())) continue;
            nodes.remove();
        }
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        if (ctl.getKey().equals(BTNOK)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            String fields = this.getSelectFields();
            if (fields == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u8d85\u8fc7\u4e86%d\u4e2a\u53c2\u6570\u3002", (String)"ParameterSelectPlugin_1", (String)"bos-form-business", (Object[])new Object[0]), 20));
                return;
            }
            if (StringUtils.isBlank((CharSequence)fields)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u5fc5\u987b\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u53c2\u6570\u3002", (String)"ParameterSelectPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            data.put(SELECTEDFIELDS, fields);
            if (this.getView().getFormShowParameter().getCustomParam(SELECTEDFIELDS) == null) {
                data.put("first", true);
            } else {
                data.put("first", false);
            }
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
    }

    private String getSelectFields() {
        TreeView treeView = (TreeView)this.getControl(TREEKEY);
        TreeView.TreeState state = treeView.getTreeState();
        if (this.getPageCache().get("tree") == null) {
            return "";
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("tree"), TreeNode.class);
        List nodes = state.getCheckedNodes();
        nodes.removeIf(node -> !root.getTreeNode(node.get("id").toString(), 16).getType().equals(ENTITYMETA));
        if (!nodes.isEmpty()) {
            if (nodes.size() > 20) {
                return null;
            }
            StringBuilder fieldStr = new StringBuilder(((Map)nodes.get(0)).get("id").toString());
            for (int i = 1; i < nodes.size(); ++i) {
                fieldStr.append(",").append(((Map)nodes.get(i)).get("id").toString());
            }
            return fieldStr.toString();
        }
        return "";
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        F7SelectedList f7 = (F7SelectedList)this.getControl(F7LIST);
        TreeView treeView = (TreeView)this.getControl(TREEKEY);
        TreeView.TreeState state = treeView.getTreeState();
        if (this.getPageCache().get("tree") == null) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("tree"), TreeNode.class);
        List nodes = state.getCheckedNodes();
        nodes.removeIf(node -> !root.getTreeNode(node.get("id").toString(), 16).getType().equals(ENTITYMETA));
        List<Object> items = new ArrayList();
        items = nodes.stream().map(node -> new ValueTextItem(node.get("id").toString(), node.get("text").toString())).collect(Collectors.toList());
        f7.addItems(items);
    }

    public String listToString(List<String> stringList) {
        if (stringList.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < stringList.size(); ++i) {
            builder.append(stringList.get(i));
            if (i >= stringList.size() - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        if (evt.getParam() != null) {
            tree.uncheckNode(evt.getParam().toString());
        } else {
            tree.uncheckNodes(tree.getTreeState().getCheckedNodeIds());
        }
    }
}

