/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;

public class ImportTemplatePlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BOS_NOTEPRINT = "bos-noteprint";
    private static final Log logger = LogFactory.getLog(ImportTemplatePlugin.class);
    private long LIMITSIZ = 0x500000L;
    private static final String IMPORTPOSITION = "importposition";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZUNITID = "bizunitid";
    private static final String URLARR = "urlarr";
    private static final List<String> SUPPORT_FORMAT = Arrays.asList(".apng", ".bmp", ".gif", ".ico", ".cur", ".jpg", ".jpeg", ".jfif", ".pjpeg", ".pjp", ".png", ".svg", ".tif", ".tiff", ".xbm");

    private String getEmpty() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9700\u8981\u5b89\u88c5\u7684\u90e8\u7f72\u5305\u3002", (String)"ImportTemplatePlugin_0", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
    }

    private String getImpSuccess() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ImportTemplatePlugin_1", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
    }

    private String getInstallPatcherror() {
        return ResManager.loadKDString((String)"\u8bf7\u52ff\u5b89\u88c5\u5e94\u7528\u3002", (String)"ImportTemplatePlugin_2", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
    }

    private String getBizimportpageplugin4() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"ImportTemplatePlugin_3", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
    }

    private String getBizimportpageplugin11() {
        return ResManager.loadKDString((String)"\u8868\u5355", (String)"ImportTemplatePlugin_4", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm"});
        AttachmentPanel dbspanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        dbspanel.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "confirm": {
                this.confirm();
                break;
            }
        }
    }

    public void upload(UploadEvent arg0) {
        if (arg0 == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImportTemplatePlugin_10", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return;
        }
        Object[] args = arg0.getUrls();
        if (args == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImportTemplatePlugin_10", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return;
        }
        for (int n = 0; n < args.length; ++n) {
            Map urlMsg = (Map)args[n];
            String urlName = (String)urlMsg.get("name");
            String url = (String)urlMsg.get("url");
            JSONArray urlArr = new JSONArray();
            JSONObject urlObj = new JSONObject();
            urlObj.put(urlName, (Object)url);
            urlArr.add((Object)urlObj);
            JSONArray urlCaheArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
            if (urlCaheArr != null && urlCaheArr.size() > 0) {
                for (int i = 0; i < urlCaheArr.size(); ++i) {
                    JSONObject urlCatchObj = (JSONObject)urlCaheArr.get(i);
                    if (!urlCatchObj.containsKey((Object)urlName)) continue;
                    urlCaheArr.remove((Object)urlCatchObj);
                }
                urlCaheArr.addAll((Collection)urlArr);
                this.getPageCache().put(URLARR, urlCaheArr.toJSONString());
                continue;
            }
            this.getPageCache().put(URLARR, urlArr.toJSONString());
        }
    }

    public void remove(UploadEvent arg0) {
        Map urlMsg = (Map)arg0.getUrls()[0];
        String urlName = (String)urlMsg.get("name");
        JSONArray urlCacheArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
        if (urlCacheArr != null && urlCacheArr.size() > 0) {
            for (int i = 0; i < urlCacheArr.size(); ++i) {
                JSONObject urlCatchObj = (JSONObject)urlCacheArr.get(i);
                if (!urlCatchObj.containsKey((Object)urlName)) continue;
                urlCacheArr.remove((Object)urlCatchObj);
            }
            this.getPageCache().put(URLARR, urlCacheArr.toJSONString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void confirm() {
        JSONArray urlArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
        JSONObject message = new JSONObject();
        String bizunitId = (String)this.getView().getFormShowParameter().getCustomParam(BIZUNITID);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String number = "";
        long logId = DB.genGlobalLongId();
        if (urlArr != null && urlArr.size() > 0) {
            int i = 0;
            while (i < urlArr.size()) {
                JSONObject urlObj = (JSONObject)urlArr.get(i);
                for (String urlName : urlObj.keySet()) {
                    String url = urlObj.getString(urlName);
                    TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    try (InputStream inputStream = cache.getInputStream(url);
                         ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                        ZipEntry zEntry = zipInputStream.getNextEntry();
                        if (zEntry == null) {
                            this.getView().showErrorNotification(this.getBizimportpageplugin4());
                            return;
                        }
                        String metaName = zEntry.getName();
                        if ("kdpkgs.xml".equals(metaName)) {
                            this.getView().showTipNotification(this.getInstallPatcherror());
                            return;
                        }
                        if (metaName.endsWith(".zip") && metaName.startsWith("dm")) {
                            this.getView().showTipNotification(this.getInstallPatcherror());
                            return;
                        }
                    }
                    catch (NullPointerException nullPoint) {
                        this.getView().showErrorNotification(this.getBizimportpageplugin4());
                        return;
                    }
                    catch (Exception redisExcetion) {
                        this.getView().showErrorNotification(this.getBizimportpageplugin4() + redisExcetion.getMessage());
                        return;
                    }
                    ZipEntry zipEntry = null;
                    String formId = null;
                    ArrayList<String> formIdList = new ArrayList<String>();
                    String curRebuildFormId = "";
                    String masterId = "";
                    String pageNum = "";
                    try (TXHandle tx = TX.required((String)"mdl_ImportTemplatePlugin_confirm");
                         InputStream inStream = cache.getInputStream(url);
                         ZipInputStream zipIn = new ZipInputStream(inStream);){
                        while ((zipEntry = zipIn.getNextEntry()) != null) {
                            ByteArrayInputStream srcPicStream;
                            block103: {
                                if (zipEntry.isDirectory()) continue;
                                String metaName = zipEntry.getName();
                                metaName = metaName.replace(File.separator, "/");
                                int readLength = 0;
                                int len = 0;
                                byte[] buf = new byte[(int)this.LIMITSIZ];
                                int lastIndexOf = metaName.lastIndexOf(".");
                                String suffix = metaName.substring(lastIndexOf);
                                if (metaName.endsWith("dym") || metaName.endsWith("dymx")) {
                                    while ((readLength = zipIn.read()) != -1) {
                                        buf[len] = (byte)readLength;
                                        ++len;
                                    }
                                    String content = new String(buf, 0, len);
                                    if (metaName.endsWith("dym")) {
                                        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
                                        serializer.setColloctionIgnorePKValue(true);
                                        DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
                                        DesignMeta meta = (DesignMeta)deployNew.getDesignMetas().get(0);
                                        String metaISV = meta.getIsv();
                                        String modelType = meta.getModelType();
                                        if (!"PrintModel".equals(modelType)) continue;
                                        pageNum = meta.getNumber();
                                        formId = deployNew.getId();
                                        String metaType = meta.getDevType();
                                        curRebuildFormId = "2".equals(metaType) ? (masterId = deployNew.getMasterId()) : formId;
                                        if (StringUtils.isBlank((CharSequence)metaISV)) {
                                            throw new KDException(new ErrorCode("devp_isv", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u9875\u9762\"%s\"\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ImportTemplatePlugin_5", (String)BOS_NOTEPRINT, (Object[])new Object[0]), pageNum)), new Object[0]);
                                        }
                                    }
                                    MetadataDao.deployMetadata((String)content, (String)bizunitId, (String)bizAppId);
                                    formIdList.add(curRebuildFormId);
                                    this.writeLog(formId, pageNum, content, logId);
                                    continue;
                                }
                                if (!SUPPORT_FORMAT.contains(suffix)) continue;
                                String imgPath = StringUtils.substringAfter((String)metaName, (String)"resource");
                                while ((readLength = zipIn.read()) != -1) {
                                    buf[len] = (byte)readLength;
                                    ++len;
                                }
                                String resFileName = metaName.substring(metaName.lastIndexOf("/") + 1, metaName.length());
                                srcPicStream = new ByteArrayInputStream(buf);
                                Throwable throwable = null;
                                try {
                                    FileItemExt newItem = new FileItemExt(resFileName, imgPath, (InputStream)srcPicStream);
                                    newItem.setSource(FileSource.PRINT_TPL_RESOURCE);
                                    FileServiceFactory.getImageFileService().upload((FileItem)newItem);
                                    if (srcPicStream == null) continue;
                                    if (throwable == null) break block103;
                                }
                                catch (Throwable throwable2) {
                                    try {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        if (srcPicStream == null) throw throwable3;
                                        if (throwable == null) {
                                            srcPicStream.close();
                                            throw throwable3;
                                        }
                                        try {
                                            srcPicStream.close();
                                            throw throwable3;
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                            throw throwable3;
                                        }
                                    }
                                }
                                try {
                                    srcPicStream.close();
                                    continue;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    continue;
                                }
                            }
                            srcPicStream.close();
                        }
                    }
                    MetadataDao.clearSubRuntimeMeta(formIdList);
                    for (String rbFormId : formIdList) {
                        try {
                            MetadataDao.rebuildRuntimeMetaById((String)rbFormId);
                            number = MetadataDao.getNumberById((String)rbFormId);
                            message.put("SUCCESS", (Object)this.getImpSuccess());
                        }
                        catch (Exception runtimeException) {
                            String retInfo = "";
                            retInfo = StringUtils.isNotBlank((CharSequence)number) ? String.format(ResManager.loadKDString((String)"%s\"\u5bfc\u5165\u5931\u8d25\u3002\u6784\u5efa\u8fd0\u884c\u671f\u5143\u6570\u636e\u5931\u8d25\uff1a", (String)"ImportTemplatePlugin_9", (String)BOS_NOTEPRINT, (Object[])new Object[0]), this.getBizimportpageplugin11() + number) : String.format(ResManager.loadKDString((String)"%s\"\u5bfc\u5165\u5931\u8d25\u3002\u6784\u5efa\u8fd0\u884c\u671f\u5143\u6570\u636e\u5931\u8d25\uff1a", (String)"ImportTemplatePlugin_9", (String)BOS_NOTEPRINT, (Object[])new Object[0]), this.getBizimportpageplugin11() + curRebuildFormId);
                            message.put("RUNTIMEERROR", (Object)(retInfo + runtimeException.getMessage()));
                        }
                    }
                    message.put(BIZAPPID, (Object)bizAppId);
                    message.put(BIZUNITID, (Object)bizunitId);
                    message.put("bizpageid", formId);
                    message.put("bizpagenumber", (Object)number);
                    if (message.containsKey((Object)"SUCCESS")) {
                        AppLogInfo appLogInfo = new AppLogInfo();
                        appLogInfo.setUserID(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
                        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
                        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
                        appLogInfo.setOpTime(new Date());
                        DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getView().getFormShowParameter().getAppId())});
                        appLogInfo.setBizAppID(String.valueOf(bizApp.getPkValue()));
                        DynamicObject bizObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"bas_manageprinttpl")});
                        appLogInfo.setBizObjID(String.valueOf(bizObj.getPkValue()));
                        appLogInfo.setClientType(RequestContext.get().getClient());
                        appLogInfo.setOpName(ResManager.loadKDString((String)"\u5bfc\u5165", (String)"ImportTemplatePlugin_11", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                        appLogInfo.setOpDescription(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"ImportTemplatePlugin_12", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
                    }
                    this.getView().returnDataToParent((Object)message);
                    this.getView().close();
                }
                ++i;
            }
            return;
        }
        this.getView().showTipNotification(this.getEmpty());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret = (Map)e.getReturnData();
        if (ret != null && "chooseunitcallback".equals(e.getActionId())) {
            String bizUnitId = (String)ret.get("id");
            String bizUnitName = (String)ret.get("name");
            this.getModel().setValue(BIZUNITID, (Object)bizUnitId);
            this.getModel().setValue(IMPORTPOSITION, (Object)bizUnitName);
        }
    }

    private void writeLog(String formId, String formNumber, String content, long logId) {
        try {
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addMetaLog(formId, formNumber, content, (int)MetaLogType.PageImport.getValue(), logId, (int)MetaType.Form.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

