/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import com.kingdee.bos.ctrl.swing.KDFont;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.QueryResult;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class ManageFontsListEdit
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(ManageFontsListEdit.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.createTempFiles();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IPageCache iPageCache = this.getView().getPageCache();
        iPageCache.put("testss", this.getView().getPageId());
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"new", (CharSequence)operateKey)) {
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            String key = userId + "bos_dutystate" + "userDutyState";
            String userDutyState = UserConfigServiceHelper.getSetting((long)userId, (String)key);
            if (StringUtils.isEmpty((CharSequence)userDutyState) || !"checkboxfieldTrue".equals(userDutyState)) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("bos_dutystate");
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "fontDutyState");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(callBack);
                parameter.setCaption(ResManager.loadKDString((String)"\u514d\u8d23\u58f0\u660e", (String)"ManagePrintInfoListEdit_9", (String)"bos-noteprint", (Object[])new Object[0]));
                this.getView().showForm(parameter);
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)"delete", (CharSequence)operateKey)) {
            ListView listview = (ListView)this.getView();
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            BillList billList = (BillList)this.getView().getControl("billlistap");
            QueryResult queryResult = billList.queryDataBySelectedRows(selectedRows);
            DynamicObjectCollection collection = queryResult.getCollection();
            for (DynamicObject obj : collection) {
                String source = obj.getString("source");
                if (!StringUtils.equals((CharSequence)source, (CharSequence)"1")) continue;
                args.setCancel(true);
                String message = ResManager.loadKDString((String)"\u7cfb\u7edf\u5b57\u6bb5\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u52ff\u52fe\u9009\u3002", (String)"ManagePrintInfoListEdit_10", (String)"bos-noteprint", (Object[])new Object[0]);
                args.setCancelMessage(message);
                this.getView().showTipNotification(message);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void createTempFiles() {
        String tempFontDir = KDFont.getFontFilesDir();
        Set fileNames = KDFont.getFontFileNames();
        if (!fileNames.isEmpty()) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("tenantid", "=", (Object)RequestContext.get().getTenantId())};
        Map fonts = BusinessDataServiceHelper.loadFromCache((String)"bos_fontmanagement", (QFilter[])filters);
        for (Map.Entry entry : fonts.entrySet()) {
            String interId = entry.getKey().toString();
            QFilter[] attachmentFilters = new QFilter[]{new QFilter("FInterID", "=", (Object)interId), new QFilter("FBillType", "=", (Object)"bos_fontmanagement")};
            DynamicObject attachmentObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_attachment", (QFilter[])attachmentFilters);
            if (attachmentObj == null || attachmentObj.get("FAttachmentName") == null || attachmentObj.get("FFileId") == null) continue;
            String name = attachmentObj.get("FAttachmentName").toString();
            String path = attachmentObj.get("FFileId").toString();
            if (fileNames.contains(name)) continue;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            FileServiceFactory.getAttachmentFileService().download(path, (OutputStream)bos, "");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bos.toByteArray());
            try {
                String tempJARFontPath = tempFontDir + File.separatorChar + name;
                File tempFontFile = new File(tempJARFontPath);
                boolean success = tempFontFile.createNewFile();
                if (!success) continue;
                try (FileOutputStream fos = new FileOutputStream(tempFontFile);){
                    byte[] bytes = new byte[1024];
                    int index = 0;
                    while ((index = inputStream.read(bytes)) != -1) {
                        fos.write(bytes, 0, index);
                        fos.flush();
                    }
                }
                log.debug("\u6253\u5370 \uff1a \u5df2\u6210\u529f\u5c06" + name + "\u5199\u5165\u5b57\u4f53\u76ee\u5f55 :" + tempJARFontPath);
            }
            catch (IOException e) {
                log.debug("\u6253\u5370 \uff1a\u5c06" + name + "\u5199\u5165\u5b57\u4f53\u76ee\u5f55\u5931\u8d25:" + e.getMessage());
            }
        }
    }
}

