/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import com.kingdee.bos.ctrl.swing.KDFont;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ManageFontsPlugin
extends AbstractBasePlugIn
implements UploadListener {
    private static final Log log = LogFactory.getLog(ManageFontsPlugin.class);
    private static final String ATTACHMENT_PANEL = "fontattachment";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("save")) {
            DynamicObject aa = this.getModel().getDataEntity();
            String tempFontDir = KDFont.getFontFilesDir();
            Set fileNames = KDFont.getFontFileNames();
            String innerId = aa.getPkValue() == null ? null : aa.getPkValue().toString();
            QFilter[] attachmentFilters = new QFilter[]{new QFilter("FInterID", "=", (Object)innerId), new QFilter("FBillType", "=", (Object)"bos_fontmanagement")};
            Map dynColl = BusinessDataServiceHelper.loadFromCache((String)"bos_attachment", (QFilter[])attachmentFilters);
            for (Map.Entry attachmentEntry : dynColl.entrySet()) {
                DynamicObject attachmentObj = (DynamicObject)attachmentEntry.getValue();
                if (attachmentObj == null || attachmentObj.get("FAttachmentName") == null || attachmentObj.get("FFileId") == null) continue;
                String name = attachmentObj.get("FAttachmentName").toString();
                String path = attachmentObj.get("FFileId").toString();
                if (fileNames.contains(name)) continue;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                FileServiceFactory.getAttachmentFileService().download(path, (OutputStream)bos, "");
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bos.toByteArray());
                try {
                    String tempJARFontPath = tempFontDir + File.separatorChar + name;
                    File tempFontFile = new File(tempJARFontPath);
                    if (!tempFontFile.createNewFile()) {
                        // empty if block
                    }
                    try (FileOutputStream fos = new FileOutputStream(tempFontFile);){
                        byte[] bytes = new byte[1024];
                        int index = 0;
                        while ((index = inputStream.read(bytes)) != -1) {
                            fos.write(bytes, 0, index);
                            fos.flush();
                        }
                    }
                    log.debug("\u6253\u5370 \uff1a \u5df2\u6210\u529f\u5c06" + name + "\u5199\u5165\u5b57\u4f53\u76ee\u5f55 :" + tempJARFontPath);
                }
                catch (IOException e) {
                    log.debug("\u6253\u5370 \uff1a\u5c06" + name + "\u5199\u5165\u5b57\u4f53\u76ee\u5f55\u5931\u8d25:" + e.getMessage());
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANEL);
        panel.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setValue("isv", (Object)ISVService.getISVInfo().getName());
        this.getModel().setValue("tenantid", (Object)RequestContext.get().getTenantId());
        this.getModel().setDataChanged(false);
    }

    public void upload(UploadEvent e) {
        if (null == e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImportTemplatePlugin_10", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        Object[] args = e.getUrls();
        if (null == args) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImportTemplatePlugin_10", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        for (Object arg : args) {
            Map argMap = (Map)arg;
            String url = (String)argMap.get("url");
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            try (InputStream input = cache.getInputStream(url);){
                Font f = Font.createFont(0, input);
                this.getModel().setValue("fontname", (Object)f.getName());
            }
            catch (FontFormatException fontFormatException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void remove(UploadEvent e) {
        Object[] urls = e.getUrls();
        if (null == urls || urls.length == 0) {
            return;
        }
        this.getModel().setValue("fontname", (Object)"");
    }
}

