/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityObjectReader;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.print.PrintMetaUtils;
import kd.bos.isv.ISVService;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.svc.util.print.PrintFileUtil;

public class ManagePrintInfoListEdit
extends StandardTreeListPlugin
implements RowClickEventListener,
ItemClickListener {
    private static final Log log = LogFactory.getLog(ManagePrintInfoListEdit.class);
    private static final String PREFIX_APP = "app_";
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndel";
    private static final String TABLENAME = "t_bas_printtplinfo";
    public static final String ADDNEW_PERMID = "47156aff000000ac";
    public static final String EDIT_PERMID = "4715a0df000000ac";
    public static final String DELETE_PERMID = "4715e1f1000000ac";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String MODELTYPE = "modeltype";
    private static final String BILLFORMID = "billformid";
    private static final String BILLLISTAP = "billlistap";
    private static final String BAS_MANAGEPRINTTPL = "bas_manageprinttpl";
    private static final String PRINTTPLID_ID = "printtplid_id";
    private static final String BOS_DEVPORTAL_UNITRELFORM = "bos_devportal_unitrelform";
    private static final String BIZAPP = "bizapp";
    private static final String NUMBER = "number";
    private static final String BIZUNITID = "bizunitid";
    private static final String BIZAPPID = "bizappid";
    private static final String USER_HOME = PrintFileUtil.normalize((String)System.getProperty("user.home"));
    private static final String DOWNLOADPATH = "KINGDEEDOWNLOAD";
    public static final String TBLSETDEFAULT = "tblsetdefault";
    public static final String TBLSETUNDEFAULT = "tblsetundefault";
    private String errDataMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u662f\u5386\u53f2\u810f\u6570\u636e\u5bfc\u81f4\uff0c\u8bf7\u68c0\u67e5\u540e\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u6216\u91cd\u5efa\u6a21\u677f\u3002", (String)"ManagePrintInfoListEdit_7", (String)"bos-noteprint", (Object[])new Object[0]);

    public void afterCreateNewData(EventObject e) {
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
        if (ConfigConstUtil.isOldPrintClose()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "tblcopy", "tblimport", "tblexport"});
        }
    }

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.addCustomQFilter(new QFilter("type", "!=", (Object)"B"));
        e.setOrderBy("id");
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject rowData = e.getRowData();
        DynamicObject printtpObj = rowData.getDynamicObject("printtplid");
        if (printtpObj == null) {
            BasedataProp basedataProp = (BasedataProp)rowData.getDynamicObjectType().getProperty("printtplid");
            DynamicObject dynamicObject = new DynamicObject(basedataProp.getDynamicComplexPropertyType());
            Object printtplid = rowData.get(PRINTTPLID_ID);
            dynamicObject.set("id", printtplid);
            dynamicObject.set(NUMBER, printtplid);
            rowData.set("printtplid", (Object)dynamicObject);
            e.setRowData(rowData);
        }
    }

    private void initTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeListModel_0", (String)"bos-noteprint", (Object[])new Object[0]));
        root.setId("root");
        root.setParentid("");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        root.setChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>(0);
        }
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            String cloudNodeId = PREFIX_CLOUD + cloud.getId();
            cloud.setId(cloudNodeId);
            cloud.setData((Object)"cloud");
            List apps = cloud.getChildren();
            if (apps == null) {
                cloudIterator.remove();
                continue;
            }
            for (TreeNode app : apps) {
                String appNodeId = PREFIX_APP + app.getId();
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData((Object)"app");
            }
        }
        return clouds;
    }

    private List<TreeNode> getChildNodes(String parentId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(parentId, 20);
        if (parent == null) {
            return new ArrayList<TreeNode>();
        }
        if (!parentId.startsWith(PREFIX_APP)) {
            return parent.getChildren();
        }
        if (parent.getChildren() == null || !parent.getChildren().isEmpty()) {
            return parent.getChildren();
        }
        return Collections.emptyList();
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{BTN_EDIT, BTN_DELETE});
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        List<TreeNode> childNodes = this.getChildNodes(nodeId);
        e.setChildNodes(childNodes);
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        String nodeId = treenodeevent.getNodeId().toString();
        this.getPageCache().put("nodeId", nodeId);
        super.treeNodeClick(treenodeevent);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        QFilter filter = null;
        if (!this.isTopNodeId(nodeId)) {
            if (nodeId.startsWith(PREFIX_CLOUD)) {
                String cloudId = StringUtils.substringAfter((String)nodeId, (String)"_");
                filter = new QFilter(BILLFORMID, "in", (Object)EntityObjectReader.loadEntityNumbersInCloud((String)cloudId, (QFilter[])new QFilter[0]));
            } else if (nodeId.startsWith(PREFIX_APP)) {
                String appId = StringUtils.substringAfter((String)nodeId, (String)"_");
                filter = new QFilter(BILLFORMID, "in", (Object)EntityObjectReader.loadEntityNumbersInApp((String)appId, (QFilter[])new QFilter[0]));
            } else {
                filter = new QFilter(BILLFORMID, "=", (Object)nodeId);
            }
        }
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private boolean isTopNodeId(String currNodeId) {
        return currNodeId.equals(this.getTreeModel().getRoot().getId());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        boolean isHasPermisson = ManagePrintInfoListEdit.newCheckPagePermission("47150e89000000ac");
        if (!isHasPermisson) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"ManagePrintInfoListEdit_1", (String)"bos-noteprint", (Object[])new Object[0]));
        }
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintInfoListEdit_11", (String)"bos-noteprint", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ListSelectedRow listSelectedRow = ((BillListHyperLinkClickEvent)evt.getHyperLinkClickEvent()).getCurrentRow();
        Long pkid = (Long)listSelectedRow.getPrimaryKeyValue();
        Map cacheObjs = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{pkid}, (String)BAS_MANAGEPRINTTPL);
        DynamicObject infoObj = (DynamicObject)cacheObjs.get(pkid);
        if (infoObj == null) {
            return;
        }
        evt.setCancel(true);
        String tplId = infoObj.getString(PRINTTPLID_ID);
        Object printtplid = infoObj.get("printtplid");
        if (printtplid == null) {
            this.getView().showMessage(this.errDataMsg);
            return;
        }
        ManagePrintInfoListEdit.gotoPageDesinger(this.getView(), tplId, "bos_devportal_bizpagelist");
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains(PREFIX_CLOUD) || currentNodeId.contains(PREFIX_APP) || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam("tree_parent_id", null);
        param.setCustomParam(BILLFORMID, (Object)currentNodeId);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        boolean closed = ConfigConstUtil.isOldPrintClose();
        if ("tblnew".equals(itemKey)) {
            if (closed) {
                return;
            }
            boolean isHasPermisson = ManagePrintInfoListEdit.newCheckPagePermission(ADDNEW_PERMID);
            if (!isHasPermisson) {
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u65b0\u5efa\u201d\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"ManagePrintInfoListEdit_12", (String)"bos-noteprint", (Object[])new Object[0]));
            }
            String currentIsv = ISVService.getISVInfo().getId();
            if (StringUtils.isBlank((CharSequence)currentIsv)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintInfoListEdit_11", (String)"bos-noteprint", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            this.createPrintTemplate();
        } else if ("tbldel".equals(itemKey)) {
            boolean isHasPermisson = ManagePrintInfoListEdit.newCheckPagePermission(DELETE_PERMID);
            if (!isHasPermisson) {
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"ManagePrintInfoListEdit_13", (String)"bos-noteprint", (Object[])new Object[0]));
            }
            this.deleteInfo();
        } else if ("tblcopy".equals(itemKey)) {
            if (closed) {
                return;
            }
            boolean isHasPermisson = ManagePrintInfoListEdit.newCheckPagePermission(ADDNEW_PERMID);
            if (!isHasPermisson) {
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u65b0\u5efa\u201d\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"ManagePrintInfoListEdit_12", (String)"bos-noteprint", (Object[])new Object[0]));
            }
            this.copyPrintTemplate();
        } else if (TBLSETDEFAULT.equals(itemKey)) {
            this.setTblDefaultState(itemKey, ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u6a21\u677f\u3002", (String)"ManagePrintInfoListEdit_0", (String)"bos-noteprint", (Object[])new Object[0]), "ManagePrintInfoListEdit_0");
        } else if (TBLSETUNDEFAULT.equals(itemKey)) {
            this.setTblDefaultState(itemKey, ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u64a4\u9500\u9ed8\u8ba4\u6a21\u677f\u3002", (String)"ManagePrintInfoListEdit_2", (String)"bos-noteprint", (Object[])new Object[0]), "ManagePrintInfoListEdit_2");
        } else if ("tblimport".equals(itemKey)) {
            if (closed) {
                return;
            }
            String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
            if (!currentNodeId.contains(PREFIX_APP)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e94\u7528\u8282\u70b9\u3002", (String)"ManagePrintInfoListEdit_3", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            String currentIsv = ISVService.getISVInfo().getId();
            if (StringUtils.isBlank((CharSequence)currentIsv)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintInfoListEdit_11", (String)"bos-noteprint", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            String appId = currentNodeId.substring(currentNodeId.indexOf(95) + 1, currentNodeId.length());
            AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
            AppFunctionPacketElement appFunctionPacketElement = null;
            if (appMeta != null) {
                appFunctionPacketElement = (AppFunctionPacketElement)appMeta.getAppFunctionPackets().get(0);
                this.importPage(appId, appFunctionPacketElement.getId());
            }
        } else if ("tblexport".equals(itemKey)) {
            if (closed) {
                return;
            }
            String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
            if (!currentNodeId.contains(PREFIX_APP)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e94\u7528\u8282\u70b9\u3002", (String)"ManagePrintInfoListEdit_3", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            String appId = currentNodeId.substring(currentNodeId.indexOf(95) + 1, currentNodeId.length());
            this.exportSource(appId);
        }
    }

    private void setTblDefaultState(String itemKey, String description, String resourceID) {
        boolean isHasPermisson = ManagePrintInfoListEdit.newCheckPagePermission(EDIT_PERMID);
        if (!isHasPermisson) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7f16\u8f91\u201d\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"ManagePrintInfoListEdit_14", (String)"bos-noteprint", (Object[])new Object[0]));
        }
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u3002", (String)"ManagePrintInfoListEdit_15", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintInfoListEdit_11", (String)"bos-noteprint", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Long pkid = (Long)listSelectedRow.getPrimaryKeyValue();
        Map cacheObjs = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{pkid}, (String)BAS_MANAGEPRINTTPL);
        DynamicObject infoObj = (DynamicObject)cacheObjs.get(pkid);
        if (infoObj == null) {
            return;
        }
        Object printtplid = infoObj.get("printtplid");
        if (printtplid == null) {
            this.getView().showMessage(this.errDataMsg);
            return;
        }
        String formId = infoObj.getString("billformId_id");
        if (this.getTplEnable(pkid)) {
            if (this.getIsdefault(pkid) && TBLSETDEFAULT.equals(itemKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u4e3a\u9ed8\u8ba4\u6a21\u677f\u72b6\u6001\u3002", (String)"ManagePrintInfoListEdit_16", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            if (!this.getIsdefault(pkid) && TBLSETUNDEFAULT.equals(itemKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u4e3a\u975e\u9ed8\u8ba4\u6a21\u677f\u72b6\u6001\u3002", (String)"ManagePrintInfoListEdit_17", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            this.updateInfo(pkid, formId, itemKey);
            this.getTreeListView().refresh();
            AppLogInfo appLogInfo = this.writeLogInfo();
            Object number = infoObj.getDynamicObject("printtplid").get(NUMBER);
            if (TBLSETDEFAULT.equals(itemKey)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u4e3a\u9ed8\u8ba4\u6a21\u677f\u6210\u529f\u3002", (String)"ManagePrintInfoListEdit_18", (String)"bos-noteprint", (Object[])new Object[0]));
                appLogInfo.setOpName(ResManager.loadKDString((String)"\u8bbe\u4e3a\u9ed8\u8ba4\u6a21\u677f", (String)"ManagePrintInfoListEdit_19", (String)"bos-noteprint", (Object[])new Object[0]));
                appLogInfo.setOpDescription(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u8bbe\u4e3a\u9ed8\u8ba4\u6a21\u677f\u6210\u529f\u3002", (String)"ManagePrintInfoListEdit_20", (String)"bos-noteprint", (Object[])new Object[0]), number));
                LogServiceHelper.addLog((AppLogInfo)appLogInfo);
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u9ed8\u8ba4\u6a21\u677f\u6210\u529f\u3002", (String)"ManagePrintInfoListEdit_21", (String)"bos-noteprint", (Object[])new Object[0]));
            appLogInfo.setOpName(ResManager.loadKDString((String)"\u64a4\u9500\u9ed8\u8ba4\u6a21\u677f", (String)"ManagePrintInfoListEdit_22", (String)"bos-noteprint", (Object[])new Object[0]));
            appLogInfo.setOpDescription(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u64a4\u9500\u9ed8\u8ba4\u6a21\u677f\u6210\u529f\u3002", (String)"ManagePrintInfoListEdit_23", (String)"bos-noteprint", (Object[])new Object[0]), number));
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
            return;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)description, (String)resourceID, (String)"bos-noteprint", (Object[])new Object[0]));
    }

    public boolean getTplEnable(Long pkid) {
        boolean enable = false;
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)pkid)};
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)BAS_MANAGEPRINTTPL, (String)"enable", (QFilter[])qFilters);
        String tplenable = (String)pageRelInfo.get("enable");
        if (tplenable.equals("1")) {
            enable = true;
        }
        return enable;
    }

    public boolean getIsdefault(Long pkid) {
        boolean isdefault = false;
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)pkid)};
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)BAS_MANAGEPRINTTPL, (String)"isdefault", (QFilter[])qFilters);
        Boolean tblsetdefault = (Boolean)pageRelInfo.get("isdefault");
        if (tblsetdefault.booleanValue()) {
            isdefault = true;
        }
        return isdefault;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("copyprinttemplate".equals(e.getActionId())) {
            if (e.getReturnData() != null) {
                this.getTreeListView().refresh();
            }
        } else if ("importpagecallback".equals(e.getActionId())) {
            this.getTreeListView().refresh();
        } else if (e.getReturnData() != null) {
            Map returnData = (Map)e.getReturnData();
            if ("true".equals(returnData.get("success").toString())) {
                String formId = returnData.get("formid").toString();
                this.getTreeListView().refresh();
                ManagePrintInfoListEdit.gotoPageDesinger(this.getView(), formId, "bos_devportal_bizpagelist");
            } else if (returnData.get("message") != null) {
                this.getView().showErrorNotification(returnData.get("message").toString());
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9875\u9762\u521b\u5efa\u5931\u8d25\uff01", (String)"ManagePrintInfoListEdit_24", (String)"bos-noteprint", (Object[])new Object[0]));
            }
        }
    }

    public static void gotoPageDesinger(IFormView view, String id, String pageNumber) {
        QFilter qFormId = new QFilter("form", "=", (Object)id);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
        if (StringUtils.isBlank((Object)pageRelInfo)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u9875\u9762\u521b\u5efa\u5931\u8d25\uff0c\u5e94\u7528\u548c\u5e94\u7528\u5355\u5143\u4e4b\u95f4\u6ca1\u6709\u5173\u8054\u3002", (String)"ManagePrintInfoListEdit_25", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        String appId = pageRelInfo.getString(BIZAPP);
        DynamicObject pageInfo = OldPrintTemplateUtil.loadSingleFromCache((Object)id);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_formdesigner");
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam(NUMBER, pageInfo.get(NUMBER));
        parameter.setCustomParam(BIZAPPID, (Object)appId);
        parameter.setClientParam(MODELTYPE, pageInfo.get(MODELTYPE));
        parameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        view.showForm(parameter);
    }

    public static boolean checkPagePermission(String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int flag = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)0L, (String)BAS_MANAGEPRINTTPL, (String)permissionItemId);
        boolean isHasPermission = flag == 1;
        return isHasPermission;
    }

    private static boolean newCheckPagePermission(String permissionItemId) {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.hasSpecificPerm((long)userId, null, (String)BAS_MANAGEPRINTTPL, (String)permissionItemId);
    }

    private void createPrintTemplate() {
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(MODELTYPE, "PrintModel");
        map.put(BIZAPPID, "");
        map.put(BIZUNITID, "");
        map.put("name", null);
        map.put(NUMBER, null);
        map.put("bizentity", "");
        map.put("isprinttemplate", "true");
        map.put("currentNodeId", currentNodeId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_newprinttpl");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(map);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "createprinttemplate");
        parameter.setCloseCallBack(callBack);
        parameter.setCaption(ResManager.loadKDString((String)"\u521b\u5efa\u6253\u5370\u6a21\u677f\u9875\u9762 ", (String)"ManagePrintInfoListEdit_26", (String)"bos-noteprint", (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    private void copyPrintTemplate() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u6a21\u677f\u3002", (String)"ManagePrintInfoListEdit_27", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u3002", (String)"ManagePrintInfoListEdit_15", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintInfoListEdit_11", (String)"bos-noteprint", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Long pkid = (Long)listSelectedRow.getPrimaryKeyValue();
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkid, (String)BAS_MANAGEPRINTTPL);
        if (obj == null) {
            return;
        }
        Object printtplid = obj.get("printtplid");
        if (printtplid == null) {
            this.getView().showMessage(this.errDataMsg);
            return;
        }
        String tplId = obj.getString(PRINTTPLID_ID);
        String bizUnitId = this.getUnitId(tplId);
        String bizAppId = this.getAppId(tplId);
        String number = (String)obj.get("printtplid.number");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(MODELTYPE, "PrintModel");
        map.put(BIZUNITID, bizUnitId);
        map.put(BIZAPPID, bizAppId);
        map.put("bizentity", tplId);
        map.put(NUMBER, number);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_copyprinttpl");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(map);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "copyprinttemplate");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private String getUnitId(String fromId) {
        String unitId = "";
        QFilter qFormId = new QFilter("form", "=", (Object)fromId);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)"bizunit", (QFilter[])new QFilter[]{qFormId});
        if (!StringUtils.isBlank((Object)pageRelInfo)) {
            unitId = pageRelInfo.getString("bizunit");
        }
        return unitId;
    }

    private String getAppId(String fromId) {
        String appId = "";
        QFilter qFormId = new QFilter("form", "=", (Object)fromId);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)BIZAPP, (QFilter[])new QFilter[]{qFormId});
        if (!StringUtils.isBlank((Object)pageRelInfo)) {
            appId = pageRelInfo.getString(BIZAPP);
        }
        return appId;
    }

    private void updateInfo(Long id, String billFormId, String fisdefault) {
        String UPDATEOTHER_SQL = "update %s set  fisdefault = ? where fbillformid = ? and fid <> ?";
        String UPDATE_SQL = "update %s set  fisdefault = ? where fid = ?";
        String sql = String.format(UPDATE_SQL, TABLENAME);
        String fisdefaultSelf = "1";
        String fisdefaultOtrher = "0";
        Object[] params = new SqlParameter[2];
        if (TBLSETUNDEFAULT.equals(fisdefault)) {
            fisdefaultSelf = "0";
            fisdefaultOtrher = "0";
        }
        params[0] = new SqlParameter("fisdefault", 1, (Object)fisdefaultSelf);
        params[1] = new SqlParameter("fid", -5, (Object)id);
        String sql1 = String.format(UPDATEOTHER_SQL, TABLENAME);
        Object[] otherParams = new SqlParameter[]{new SqlParameter("fisdefault", 1, (Object)fisdefaultOtrher), new SqlParameter("fbillformid", 12, (Object)billFormId), new SqlParameter("fid", -5, (Object)id)};
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            if (TBLSETDEFAULT.equals(fisdefault)) {
                DB.execute((DBRoute)DBRoute.basedata, (String)sql1, (Object[])otherParams);
            }
        }
        catch (KDException e) {
            throw e;
        }
        catch (OrmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s.", e.getMessage())});
        }
    }

    private void deleteInfo() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6a21\u677f\u3002", (String)"ManagePrintInfoListEdit_28", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintInfoListEdit_11", (String)"bos-noteprint", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u6a21\u677f\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u6a21\u677f\u5417\uff1f", (String)"ManagePrintInfoListEdit_29", (String)"bos-noteprint", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (callBackId.equals("delete_comfirm") && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            String isvName = ISVService.getISVInfo().getName();
            if (isvName == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintInfoListEdit_4", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            ListView listview = (ListView)event.getSource();
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            Map<String, List<String>> allTplIds = this.getPrintTplId(selectedRows);
            ArrayList<String> canDelTplNumbers = new ArrayList<String>(10);
            Object[] canDelTplIds = allTplIds.get("canDelTplIds").toArray();
            Object[] notDelTplIds = allTplIds.get("notDelTplIds").toArray();
            for (Object id : canDelTplIds) {
                canDelTplNumbers.add(MetadataDao.getNumberById((String)((String)id)));
            }
            QFilter qFilter = new QFilter("printtplid", "in", (Object)canDelTplIds);
            QFilter[] qFilters = new QFilter[]{qFilter};
            int successCount = DeleteServiceHelper.delete((String)BAS_MANAGEPRINTTPL, (QFilter[])qFilters);
            BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(DesignFormMeta.class), (Object[])canDelTplIds);
            BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(DesignFormMetaL.class), (Object[])canDelTplIds);
            if (notDelTplIds.length > 0) {
                this.showDelInfo(successCount, notDelTplIds);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ManagePrintInfoListEdit_30", (String)"bos-noteprint", (Object[])new Object[0]));
            }
            StringBuilder s = new StringBuilder();
            for (String tplNumber : canDelTplNumbers) {
                MetaCacheUtils.removeDistributeCache((String[])new String[]{tplNumber});
                s.append(tplNumber).append("\uff0c");
            }
            this.getView().invokeOperation("refresh");
            AppLogInfo appLogInfo = this.writeLogInfo();
            appLogInfo.setOpName(ResManager.loadKDString((String)"\u5220\u9664", (String)"ManagePrintInfoListEdit_31", (String)"bos-noteprint", (Object[])new Object[0]));
            appLogInfo.setOpDescription(s.insert(0, ResManager.loadKDString((String)"\u7f16\u53f7", (String)"ManagePrintInfoListEdit_32", (String)"bos-noteprint", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ManagePrintInfoListEdit_30", (String)"bos-noteprint", (Object[])new Object[0])).toString());
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
        }
    }

    public void showDelInfo(int successCount, Object[] notDelTplIds) {
        String isvName = ISVService.getISVInfo().getName();
        if (notDelTplIds.length > 1) {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("bos_operationresult");
            parameters.setShowTitle(false);
            int allCount = successCount + notDelTplIds.length;
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u5220\u9664\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20", (String)"ManagePrintInfoListEdit_8", (String)"bos-noteprint", (Object[])new Object[0]), allCount, successCount, allCount - successCount);
            parameters.setCustomParam("title", (Object)title);
            StringBuilder buf = new StringBuilder();
            String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546%s\u7684\u6a21\u677f\u65e0\u6cd5\u5220\u9664\u3002", (String)"ManagePrintInfoListEdit_33", (String)"bos-noteprint", (Object[])new Object[0]), isvName);
            buf.append(msg);
            parameters.setCustomParam("errorMsg", (Object)buf.toString().trim());
            this.getView().showForm(parameters);
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546%s\u7684\u6a21\u677f\u65e0\u6cd5\u5220\u9664\u3002", (String)"ManagePrintInfoListEdit_33", (String)"bos-noteprint", (Object[])new Object[0]), isvName));
        }
    }

    public Map<String, List<String>> getPrintTplId(ListSelectedRowCollection selectedRows) {
        HashMap<String, List<String>> allTplIds = new HashMap<String, List<String>>();
        ArrayList<String> canDelTplIds = new ArrayList<String>();
        ArrayList<String> notDelTplIds = new ArrayList<String>();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Long pkid = (Long)listSelectedRow.getPrimaryKeyValue();
            Map cacheObjs = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{pkid}, (String)BAS_MANAGEPRINTTPL);
            DynamicObject infoObj = (DynamicObject)cacheObjs.get(pkid);
            if (infoObj == null) continue;
            String tplId = infoObj.getString(PRINTTPLID_ID);
            if (OldPrintTemplateUtil.exists((Object)tplId)) {
                PrintMetadata meta = OldPrintTemplateUtil.findOldPrintMetadata((String)tplId);
                if (meta == null) continue;
                String currentIsv = ISVService.getISVInfo().getId();
                boolean isKingdee = StringUtils.equals((CharSequence)currentIsv, (CharSequence)"kingdee");
                if (isKingdee || meta.getIsv().equalsIgnoreCase(currentIsv)) {
                    canDelTplIds.add(tplId);
                    continue;
                }
                notDelTplIds.add(tplId);
                continue;
            }
            canDelTplIds.add(tplId);
        }
        allTplIds.put("canDelTplIds", canDelTplIds);
        allTplIds.put("notDelTplIds", notDelTplIds);
        return allTplIds;
    }

    private void exportSource(String appId) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6a21\u677f\u3002", (String)"ManagePrintInfoListEdit_5", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintInfoListEdit_11", (String)"bos-noteprint", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        Map cacheObjs = BusinessDataServiceHelper.loadFromCache((Object[])selectedRows.getPrimaryKeyValues(), (String)BAS_MANAGEPRINTTPL);
        List<Object> bizIds = cacheObjs.values().stream().map(o -> o.get(PRINTTPLID_ID)).collect(Collectors.toList());
        this.exportPageSource(appId, bizIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportPageSource(String bizAppId, List<Object> tplIds) {
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizAppNumber = appMeta.getNumber();
        String appVersion = appMeta.getAppElement().getVersion();
        String appNumberPath = USER_HOME + File.separator + DOWNLOADPATH + File.separator + bizAppNumber;
        String traceIdHash = Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), Charsets.UTF_8).toString();
        String traceIdPath = appNumberPath + File.separator + traceIdHash;
        String localPath = traceIdPath + File.separator + "datamodel" + File.separator + appVersion + File.separator + "main" + File.separator + bizAppNumber;
        ArrayList<File> fileList = new ArrayList<File>();
        for (Object bizId : tplIds) {
            if (!OldPrintTemplateUtil.exists((Object)bizId)) continue;
            PrintMetaUtils.expFormMetadata((String)bizId, localPath, "EXPORT_PAGE");
        }
        InputStream in = null;
        try {
            PrintMetaUtils.zipFiles(bizAppNumber, localPath, fileList);
            String downloadFile = localPath + File.separator + bizAppNumber + ".zip";
            Path downloadPath = Paths.get(PrintMetaUtils.checkFilePath(downloadFile), new String[0]);
            in = Files.newInputStream(downloadPath, new OpenOption[0]);
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(bizAppNumber + ".zip", in, 7200);
            this.getView().openUrl(urls);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        finally {
            try {
                File traceIdFile;
                if (in != null) {
                    in.close();
                }
                if ((traceIdFile = new File(traceIdPath.replace('.', '%').replace('/', '%'))).exists()) {
                    boolean appNumDelete;
                    PrintMetaUtils.deleteKd(traceIdFile);
                    File appNumberFile = new File(appNumberPath.replace('.', '%').replace('/', '%'));
                    if (appNumberFile.listFiles().length == 0 && (appNumDelete = appNumberFile.delete())) {
                        log.debug(appNumberFile + "delete:" + appNumDelete);
                    }
                }
            }
            catch (IOException iOException) {}
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ManagePrintInfoListEdit_6", (String)"bos-noteprint", (Object[])new Object[0]));
        AppLogInfo appLogInfo = this.writeLogInfo();
        appLogInfo.setOpName(ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"ManagePrintInfoListEdit_34", (String)"bos-noteprint", (Object[])new Object[0]));
        appLogInfo.setOpDescription(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ManagePrintInfoListEdit_6", (String)"bos-noteprint", (Object[])new Object[0]));
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    private void importPage(String bizAppId, String selectedUnitId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_importprinttpl");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(BIZUNITID, (Object)selectedUnitId);
        parameter.setCustomParam("bizunitType", (Object)"1");
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importpagecallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs arg0) {
        String currentIsv;
        AbstractOperate s = (AbstractOperate)arg0.getSource();
        String opKey = s.getOperateKey();
        if (("disable".equals(opKey) || "enable".equals(opKey)) && StringUtils.isBlank((CharSequence)(currentIsv = ISVService.getISVInfo().getId()))) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintInfoListEdit_11", (String)"bos-noteprint", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && opResult.isSuccess()) {
            String opKey = afterDoOperationEventArgs.getOperateKey();
            AppLogInfo appLogInfo = this.writeLogInfo();
            Map cacheObjs = BusinessDataServiceHelper.loadFromCache((Object[])opResult.getSuccessPkIds().toArray(), (String)BAS_MANAGEPRINTTPL);
            Iterator cacheObjsIt = cacheObjs.entrySet().iterator();
            StringBuilder s = new StringBuilder();
            if ("disable".equals(opKey)) {
                appLogInfo.setOpName(ResManager.loadKDString((String)"\u7981\u7528", (String)"ManagePrintInfoListEdit_35", (String)"bos-noteprint", (Object[])new Object[0]));
                while (cacheObjsIt.hasNext()) {
                    DynamicObject dy = (DynamicObject)cacheObjsIt.next().getValue();
                    s.append(dy.get("printtplid.number")).append("\uff0c");
                }
                appLogInfo.setOpDescription(s.insert(0, ResManager.loadKDString((String)"\u7f16\u53f7", (String)"ManagePrintInfoListEdit_32", (String)"bos-noteprint", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ManagePrintInfoListEdit_36", (String)"bos-noteprint", (Object[])new Object[0])).toString());
                LogServiceHelper.addLog((AppLogInfo)appLogInfo);
            } else if ("enable".equals(opKey)) {
                appLogInfo.setOpName(ResManager.loadKDString((String)"\u542f\u7528", (String)"ManagePrintInfoListEdit_37", (String)"bos-noteprint", (Object[])new Object[0]));
                while (cacheObjsIt.hasNext()) {
                    DynamicObject dy = (DynamicObject)cacheObjsIt.next().getValue();
                    s.append(dy.get("printtplid.number")).append("\uff0c");
                }
                appLogInfo.setOpDescription(s.insert(0, ResManager.loadKDString((String)"\u7f16\u53f7", (String)"ManagePrintInfoListEdit_32", (String)"bos-noteprint", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ManagePrintInfoListEdit_38", (String)"bos-noteprint", (Object[])new Object[0])).toString());
                LogServiceHelper.addLog((AppLogInfo)appLogInfo);
            }
        }
    }

    private AppLogInfo writeLogInfo() {
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setUserID(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        appLogInfo.setOpTime(new Date());
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "cts";
        }
        DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)appId)});
        appLogInfo.setBizAppID(String.valueOf(bizApp.getPkValue()));
        DynamicObject bizObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)BAS_MANAGEPRINTTPL)});
        appLogInfo.setBizObjID(String.valueOf(bizObj.getPkValue()));
        appLogInfo.setClientType(RequestContext.get().getClient());
        return appLogInfo;
    }
}

