/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.util.Date;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.events.AfterDoOperationEventArgs;

public class ManagePrintInfoPlugin
extends AbstractBasePlugIn {
    private static final String UPDATE_SQL = "update %s set fmodifytime = ?, fisdefault = ? where fbillformid = ? and fid <> ?";
    private static final String TABLENAME = "t_bas_printtplinfo";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean isDefault;
        super.afterDoOperation(afterDoOperationEventArgs);
        List eInfos = afterDoOperationEventArgs.getOperationResult().getAllErrorOrValidateInfo();
        if (eInfos.size() == 0 && (isDefault = ((Boolean)this.getModel().getValue("isdefault")).booleanValue())) {
            Object id = this.getModel().getDataEntity().getPkValue();
            DynamicObject formObj = (DynamicObject)this.getModel().getValue("billformid");
            Object formId = formObj.getPkValue();
            this.updatePrintInfo(id, formId);
        }
    }

    private void updatePrintInfo(Object id, Object billFormId) {
        String sql = String.format(UPDATE_SQL, TABLENAME);
        Object[] params = new SqlParameter[]{new SqlParameter("fmodifytime", 91, (Object)new Date()), new SqlParameter("fisdefault", 1, (Object)"0"), new SqlParameter("fbillformid", 12, billFormId), new SqlParameter("fid", -5, id)};
        try (TXHandle h = TX.beginNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        catch (Throwable e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            if (e instanceof OrmException) {
                throw (OrmException)e;
            }
            throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format("Error:%s.", e.getMessage())});
        }
    }
}

