/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.bos.util.EncryptUtils;
import org.apache.commons.io.FileUtils;

public class PrintMetaUtils {
    public static final Log logger = LogFactory.getLog(PrintMetaUtils.class);
    public static final String ERROR = "ERROR";
    public static final String NUMBER = "number";
    public static final String NOPATH = "NOPATH";
    public static final String BIZAPP = "bizapp";
    public static final String BIZUNIT = "bizunit";
    private static final String JSONTYPE = ".json";
    public static final String BIZPAGE = "bizpage";
    public static final String SUCCESS = "SUCCESS";
    public static final String VERSION = "version";
    public static final String MASTERID = "masterid";
    public static final String PARENTID = "parentid";
    public static final String BIZCLOUD = "bizcloud";
    public static final String BIZAPPID = "bizappid";
    public static final String INDUSTRY = "industry";
    public static final String CONFLICT = "CONFLICT";
    private static final String KDPKGS = "kdpkgs.xml";
    public static final String ERRORCODE = "errorcode";
    public static final String ORITENENTISV = "kingdee";
    public static final String MODIFIERID = "modifierid";
    public static final String CREATEDATE = "createdate";
    public static final String MODIFYDATE = "modifydate";
    public static final String EXPORT_APP = "EXPORT_APP";
    public static final String DESCRIPTION = "description";
    public static final String EXPORT_PAGE = "EXPORT_PAGE";
    private static final String ERRORINFO = "errorInfo.txt";
    public static final String RUNTIMEERROR = "RUNTIMEERROR";
    public static final String EMPTY_COMMIT = "EMPTY COMMIT";
    public static final String CHECKIN_PAGE = "CHECKIN_PAGE";
    public static final String CHECKIN_APP = "CHECKIN_APP";
    public static final String EXPORT_CLOUD = "EXPORT_CLOUD";
    public static final String MULTI_TXT_NAME = "multi_txt_name";
    public static final String USER_HOME = System.getProperty("user.home");
    private static final String APPINFOXML = "appInfo.xml";
    private static final String RESOURCE = "resource";
    private static final String CUSTOM = "custom";
    private static final String UPLOADSOURCE = "uploadsource";
    private static final String IS_DELETE = "is delete";

    public static JSONObject expFormMetadata(String formId, String exportPath, String sourceType) {
        JSONObject checkInMsg = new JSONObject();
        try {
            List list = MetadataDao.getFormDeployFile((String)formId);
            if (list != null && list.size() > 0) {
                String pageIsv = OldPrintTemplateUtil.loadSingleFromCache((Object)formId, (String)"isv").getString("isv");
                String dymMeta = ((DeployFile)list.get(0)).getFileContent();
                String dymFileName = ((DeployFile)list.get(0)).getFileName();
                PrintMetaUtils.saveMetaFile(dymMeta, dymFileName, exportPath);
                PrintMetaUtils.saveResourceFile(dymMeta, exportPath);
                for (int i = 1; i < list.size(); ++i) {
                    String dymLangFileName = ((DeployFile)list.get(i)).getFileName();
                    String dymLangMeta = ((DeployFile)list.get(i)).getFileContent();
                    if (dymLangFileName.endsWith("zh_CN.dymx")) {
                        PrintMetaUtils.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
                        continue;
                    }
                    String currentIsv = ISVService.getISVInfo().getId();
                    if (!StringUtils.isEmpty((CharSequence)currentIsv) || ORITENENTISV.equals(pageIsv) || !currentIsv.equals(pageIsv)) continue;
                    PrintMetaUtils.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return checkInMsg;
    }

    private static void saveResourceFile(String dymMeta, String exportPath) {
        List<String> resources = PrintMetaUtils.getLabelText(dymMeta, "ImageKey");
        for (String resource : resources) {
            String resFileName;
            String pth = resource.substring(0, resource.lastIndexOf("?"));
            String fullPath = PrintMetaUtils.getResourcePath(pth, exportPath);
            String[] abovePath = fullPath.split(resFileName = pth.substring(pth.lastIndexOf("/") + 1, pth.length()));
            File fileAbovePath = new File(abovePath[0]);
            if (!fileAbovePath.exists()) {
                fileAbovePath.mkdirs();
            }
            byte[] bytes = PrintMetaUtils.download(resource);
            try {
                FileUtils.writeByteArrayToFile((File)new File(fullPath), (byte[])bytes);
            }
            catch (IOException iOException) {}
        }
    }

    private static void saveMetaFile(String dymMeta, String dymFileName, String exportPath) {
        List<String> resource = PrintMetaUtils.getLabelText(dymMeta, "ImageKey");
        String fullPath = PrintMetaUtils.getMetaXmlPath(dymFileName, exportPath);
        String[] abovePath = fullPath.split(dymFileName);
        File fileAbovePath = new File(abovePath[0]);
        if (!fileAbovePath.exists()) {
            fileAbovePath.mkdirs();
        }
        Path customZipPath = Paths.get(PrintMetaUtils.checkFilePath(fullPath), new String[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(customZipPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(dymMeta);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static String getMetaXmlPath(String filename, String exportPath) {
        String fullPath = String.format("%s/metadata/%s", exportPath, filename);
        return fullPath;
    }

    public static String getResourcePath(String filename, String exportPath) {
        String fullPath = String.format("%s/resource/%s", exportPath, filename);
        return fullPath;
    }

    public static void zipFiles(List<String> zipNames, String zipPath, String defaultAppPackageName) {
        String staticResourcePath;
        File staticResourceFile;
        String customResourcePath;
        File customResourceFile;
        String appInfo;
        File appInfoFile;
        String errorLog;
        File errorLogFile;
        JSONArray files = new JSONArray();
        String packageXML = (zipPath = PrintMetaUtils.checkFilePath(zipPath)) + File.separator + KDPKGS;
        File packageXMLFile = new File(packageXML);
        if (packageXMLFile.exists()) {
            files.add((Object)packageXML);
        }
        if ((errorLogFile = new File(errorLog = zipPath + File.separator + ERRORINFO)).exists()) {
            files.add((Object)errorLog);
        }
        if ((appInfoFile = new File(appInfo = zipPath + File.separator + APPINFOXML)).exists()) {
            files.add((Object)appInfo);
        }
        for (String zipName : zipNames) {
            String zipAppPath = zipPath + File.separator + "dm" + File.separator + zipName + ".zip";
            File zipAppFile = new File(zipAppPath);
            if (!zipAppFile.exists()) continue;
            files.add((Object)zipAppPath);
        }
        String libPath = zipPath + File.separator + "jar";
        File libFile = new File(libPath);
        if (libFile.exists()) {
            files.add((Object)libPath);
        }
        if ((customResourceFile = new File(customResourcePath = zipPath + File.separator + RESOURCE + File.separator + CUSTOM)).exists()) {
            files.add((Object)customResourcePath);
        }
        if ((staticResourceFile = new File(staticResourcePath = zipPath + File.separator + RESOURCE + File.separator + UPLOADSOURCE)).exists()) {
            files.add((Object)staticResourcePath);
        }
        String zipFilePath = zipPath + File.separator + defaultAppPackageName + ".zip";
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            PrintMetaUtils.compressZipFile(files, out, zipNames);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void zipFiles(String zipName, String localPath, List<File> fileList) {
        String resourcePath;
        File resourceFile;
        JSONArray files = new JSONArray();
        String MetadataPath = (localPath = PrintMetaUtils.checkFilePath(localPath)) + File.separator + "metadata";
        File MetadataFile = new File(MetadataPath);
        if (MetadataFile.exists()) {
            files.add((Object)MetadataPath);
        }
        if ((resourceFile = new File(resourcePath = localPath + File.separator + RESOURCE)).exists()) {
            files.add((Object)resourcePath);
        }
        if (fileList != null && fileList.size() > 0) {
            for (File file : fileList) {
                files.add((Object)file.getAbsolutePath());
            }
        }
        String zipFilePath = localPath + File.separator + zipName + ".zip";
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            PrintMetaUtils.zipFile(files, out, "");
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void zipFile(JSONArray files, ZipOutputStream out, String pathSign) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File((String)files.get(i));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles) {
                    tempFiles.add((Object)tempFile.getAbsolutePath());
                }
                PrintMetaUtils.zipFile(tempFiles, out, pathSign);
                continue;
            }
            String path = file.getAbsolutePath();
            Path zipFilePath = Paths.get(path, new String[0]);
            String fileName = file.getName();
            int t = -1;
            if (path.contains("datamodel")) {
                t = path.indexOf("datamodel");
            }
            if (path.contains("jar") && path.endsWith(".zip") && !fileName.contains("jar")) {
                t = path.indexOf("jar");
            }
            if (StringUtils.isNotBlank((CharSequence)pathSign)) {
                if (path.contains(pathSign) && !path.contains(JSONTYPE)) {
                    t = path.indexOf("webapp");
                } else if (path.contains(JSONTYPE)) {
                    t = path.indexOf(pathSign);
                }
            } else if ((path.contains(CUSTOM) || path.contains(UPLOADSOURCE)) && path.endsWith(".zip") && !fileName.contains(CUSTOM) && !fileName.contains(UPLOADSOURCE)) {
                t = path.indexOf(RESOURCE);
            }
            if (t == -1) continue;
            if ((path = path.endsWith(JSONTYPE) ? path.substring(t + pathSign.length() + 1, path.length()) : path.substring(t, path.length())).contains("\\")) {
                path = path.replace('\\', '/');
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipFilePath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private static void compressZipFile(JSONArray files, ZipOutputStream out, List<String> zipNames) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File((String)files.get(i));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles) {
                    tempFiles.add((Object)tempFile.getAbsolutePath());
                }
                PrintMetaUtils.zipFile(tempFiles, out, "");
                continue;
            }
            String path = file.getAbsolutePath();
            Path zipPath = Paths.get(path, new String[0]);
            int t = -1;
            if (path.contains(KDPKGS)) {
                t = path.indexOf(KDPKGS);
            }
            if (path.contains(ERRORINFO)) {
                t = path.indexOf(ERRORINFO);
            }
            if (path.contains(APPINFOXML)) {
                t = path.indexOf(APPINFOXML);
            }
            if (path.endsWith(".zip")) {
                for (String zipName : zipNames) {
                    if (!path.endsWith(zipName + ".zip")) continue;
                    t = path.indexOf(zipName + ".zip");
                }
            }
            if (t == -1) continue;
            path = path.endsWith(".zip") ? path.substring(t - 3, path.length()) : path.substring(t, path.length());
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    public static TreeNode buildNode(TreeNode pnode, List<TreeNode> childNode) {
        HashMap<String, TreeNode> leafNodeMap = new HashMap<String, TreeNode>();
        PrintMetaUtils.getLeafNodes(leafNodeMap, pnode);
        for (int i = 0; i < childNode.size(); ++i) {
            TreeNode cnode = childNode.get(i);
            String parentID = cnode.getParentid();
            TreeNode parNode = (TreeNode)leafNodeMap.get(parentID);
            if (parNode == null) continue;
            int seq = 0;
            if (parNode.getChildren() != null) {
                seq = parNode.getChildren().size();
            }
            parNode.addChild(seq, cnode);
        }
        return pnode;
    }

    public static void getLeafNodes(Map<String, TreeNode> map, TreeNode node) {
        if (node.getChildren() != null) {
            for (TreeNode childNode : node.getChildren()) {
                PrintMetaUtils.getLeafNodes(map, childNode);
            }
        } else {
            map.put(node.getId(), node);
            return;
        }
    }

    public static String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    public static String filenameFilter(String str) {
        Pattern FilePattern = Pattern.compile("[\\\\/:*?\"<>|]");
        return str == null ? null : FilePattern.matcher(str).replaceAll("");
    }

    public static boolean isDevelopEnv() {
        return DevportalCommonUtil.isDevelopEnv();
    }

    public static boolean isGitManageType() {
        return DevportalCommonUtil.isGitManageType();
    }

    public static String getGitCommonRemoteUrl() {
        return DevportalCommonUtil.getGitCommonRemoteUrl();
    }

    public static boolean isGitMultiParallel() {
        return DevportalCommonUtil.isGitMultiParallel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteKd(File file) {
        if (!file.isDirectory()) {
            boolean fileDelete = file.delete();
            if (!fileDelete) return;
        }
        if (!file.isDirectory()) return;
        File[] fileList = file.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File delfile = fileList[i];
            if (!delfile.isDirectory()) {
                boolean isDelFile = delfile.delete();
                if (!isDelFile) continue;
            }
            if (!delfile.isDirectory()) continue;
            PrintMetaUtils.deleteKd(fileList[i]);
        }
        boolean fileDelete = file.delete();
        if (!fileDelete) return;
    }

    public static String getIsvByAppId(String bizAppId) {
        return AppMetaServiceHelper.getIsvByAppId((String)bizAppId);
    }

    public static List<String> getLabelText(String xml, String label) {
        String regex = "<" + label + ">(.*?)</" + label + ">";
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(xml);
        ArrayList<String> fieldList = new ArrayList<String>();
        while (m.find()) {
            if (!StringUtils.isNotEmpty((CharSequence)m.group(1).trim())) continue;
            String content = m.group(1);
            fieldList.add(content.trim());
        }
        return fieldList;
    }

    private static byte[] download(String imageUrl) {
        try {
            imageUrl = EncryptUtils.decrypt((String)imageUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String newUrl = imageUrl;
        if (imageUrl.indexOf("?v=") > 0) {
            newUrl = imageUrl.substring(0, imageUrl.indexOf("?v="));
        }
        if (imageUrl.indexOf("&v=") > 0) {
            newUrl = imageUrl.substring(0, imageUrl.indexOf("&v="));
        }
        byte[] byteImage = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            FileServiceFactory.getImageFileService().download(newUrl, (OutputStream)bos, null);
            byteImage = bos.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteImage;
    }
}

