/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

public class VariableMappingPlugin
extends AbstractBillPlugIn
implements ClickListener,
IConfirmCallBack {
    private static final String VARFIELDTEXT = "varfieldtext";
    private static final String CustParamKey_IsMulti = "ismulti";
    private static final String CloseCallBack_SelectField = "selectField";
    private static final String CustParamKey_SelectedNodeIds = "nodeids";
    private static final String CustParamKey_TreeNodes = "treenodes";
    private static final String SCRIPT_PLUGIN = "scriptplugin";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            DynamicObject dyObj = (DynamicObject)this.getModel().getValue("busibill");
            if (dyObj == null) {
                return;
            }
            ArrayList splitsymbolErrList = new ArrayList();
            ArrayList<String> repeatErrList = new ArrayList<String>();
            HashSet<String> variableSet = new HashSet<String>();
            DynamicObjectCollection collection = this.getModel().getEntryEntity("mappinfield");
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject obj = (DynamicObject)collection.get(i);
                DynamicObject variableObj = (DynamicObject)obj.get("variable");
                if (variableObj == null) continue;
                String var = variableObj.getString("number");
                String type = variableObj.getString("type");
                String splitsymbol = obj.getString("splitsymbol");
                if (variableSet.contains(var)) {
                    String msg = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u53d8\u91cf\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u53d8\u91cf", (String)"VariableMappingPlugin_6", (String)"bos-noteprint", (Object[])new Object[0]), i + 1);
                    repeatErrList.add(msg);
                    continue;
                }
                variableSet.add(var);
            }
            if (!repeatErrList.isEmpty()) {
                String msg;
                if (repeatErrList.size() == 1) {
                    msg = (String)repeatErrList.get(0);
                    this.getView().showMessage(msg);
                } else {
                    msg = StringUtils.join((Object[])repeatErrList.toArray(), (String)"\n");
                    this.getView().showMessage(ResManager.loadKDString((String)"\u53d8\u91cf\u4e0d\u5141\u8bb8\u91cd\u590d", (String)"VariableMappingPlugin_5", (String)"bos-noteprint", (Object[])new Object[0]), msg, MessageTypes.Business);
                }
                args.setCancel(true);
                args.setCancelMessage(msg);
                return;
            }
            if (!splitsymbolErrList.isEmpty()) {
                String msg;
                if (splitsymbolErrList.size() == 1) {
                    msg = (String)splitsymbolErrList.get(0);
                    this.getView().showMessage(msg);
                } else {
                    msg = StringUtils.join((Object[])splitsymbolErrList.toArray(), (String)"\n");
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u5408\u5e76\u5206\u9694\u7b26\u672a\u9009\u62e9", (String)"VariableMappingPlugin_1", (String)"bos-noteprint", (Object[])new Object[0]), msg, MessageTypes.Business);
                }
                args.setCancel(true);
                args.setCancelMessage(msg);
                return;
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection collection = model.getEntryEntity("mappinfield");
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject obj = (DynamicObject)collection.get(i);
            String fieldName = obj.getLocaleString("varfieldname").toString();
            obj.set(VARFIELDTEXT, (Object)fieldName);
        }
        model.setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dyObj = (DynamicObject)this.getModel().getValue("busibill");
        if (dyObj != null) {
            String formId = dyObj.getString("number");
            this.initDataSource(formId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{VARFIELDTEXT, SCRIPT_PLUGIN});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equalsIgnoreCase(VARFIELDTEXT)) {
            Object busiObject = this.getModel().getValue("busibill");
            if (busiObject == null || "0".equals(((DynamicObject)busiObject).getPkValue())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4e1a\u52a1\u5b9e\u4f53\u201d", (String)"VariableMappingPlugin_2", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            DynamicObject variable = (DynamicObject)this.getModel().getValue("variable");
            if (variable == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u53d8\u91cf\u201d", (String)"VariableMappingPlugin_4", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            this.showFieldSelect();
        } else if (SCRIPT_PLUGIN.equalsIgnoreCase(key)) {
            Object val = this.getModel().getValue(key);
            List plugins = new ArrayList();
            if (val != null && kd.bos.util.StringUtils.isNotEmpty((String)val.toString())) {
                plugins = SerializationUtils.fromJsonStringToList((String)val.toString(), Map.class);
            }
            String formId = this.getView().getFormShowParameter().getFormId();
            FormShowParameter showParam = new FormShowParameter();
            showParam.setFormId("ide_plugins");
            showParam.getOpenStyle().setShowType(ShowType.Modal);
            showParam.setCustomParam("value", plugins);
            showParam.setCustomParam("formId", (Object)formId);
            showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SCRIPT_PLUGIN));
            this.getView().showForm(showParam);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map dataMap;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (CloseCallBack_SelectField.equals(actionId)) {
            String returnData = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((CharSequence)returnData)) {
                return;
            }
            Map focusNode = (Map)SerializationUtils.fromJsonString((String)returnData, Map.class);
            String fieldName = (String)focusNode.get("text");
            String fieldId = (String)focusNode.get("id");
            String parentId = (String)focusNode.get("parentid");
            String formId = ((DynamicObject)this.getModel().getValue("busibill")).getString("number");
            String[] arr = fieldId.split("\\.");
            String dsKey = "";
            String dsName = "";
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
            Map allEntities = entityType.getAllEntities();
            boolean isBillHead = Boolean.TRUE;
            if ("billhead".equals(parentId)) {
                dsKey = formId;
            } else if (allEntities.containsKey(arr[0])) {
                dsKey = arr[0];
                isBillHead = Boolean.FALSE;
                dsName = ((EntityType)allEntities.get(arr[0])).getDisplayName().toString();
            } else {
                Map allFields = entityType.getAllFields();
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(arr[0]);
                IDataEntityType parent = property.getParent();
                if (parent instanceof BillEntityType) {
                    dsKey = parent.getName();
                } else if (parent instanceof EntryType) {
                    dsKey = parent.getName();
                    dsName = parent.getDisplayName().toString();
                    isBillHead = Boolean.FALSE;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dsKey)) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("mappinfield");
                if (isBillHead) {
                    this.getModel().setValue("splitsymbol", null);
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"splitsymbol"});
                } else {
                    if (StringUtils.isNotBlank((CharSequence)dsName) && !fieldName.contains(dsName)) {
                        fieldName = dsName + "." + fieldName;
                    }
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"splitsymbol"});
                }
                this.getModel().setValue("varfield", (Object)fieldId);
                this.getModel().setValue("varfieldname", (Object)fieldName);
                this.getModel().setValue(VARFIELDTEXT, (Object)fieldName);
                this.getModel().setValue("vardatasource", (Object)dsKey);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6b63\u786e\u8282\u70b9", (String)"VariableMappingPlugin_3", (String)"bos-noteprint", (Object[])new Object[0]));
            }
        }
        if (SCRIPT_PLUGIN.equalsIgnoreCase(actionId) && (dataMap = (Map)closedCallBackEvent.getReturnData()) != null) {
            List plugins = (List)dataMap.get("value");
            String pluginJson = plugins == null || plugins.isEmpty() ? "" : SerializationUtils.toJsonString((Object)plugins);
            this.getModel().setValue(actionId, (Object)pluginJson);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        ChangeData[] changeSet;
        String name = e.getProperty().getName();
        if ("busibill".equals(name)) {
            changeSet = e.getChangeSet();
            changeData = changeSet[0];
            DynamicObject newObj = (DynamicObject)changeData.getNewValue();
            String newValue = newObj.getString("number");
            this.initDataSource(newValue);
            this.clearField();
        }
        if ("varfield".equals(name)) {
            changeSet = e.getChangeSet();
            changeData = changeSet[0];
            String newValue = (String)changeData.getNewValue();
            String formId = ((DynamicObject)this.getModel().getValue("busibill")).getString("number");
            ComboEdit combo = (ComboEdit)this.getView().getControl("vardatasource");
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setIncludePKField(true);
            option.setIncludeEntryEntityAsKeyPrefix(true);
            option.addMatchedClassTypes(TextProp.class);
            option.addMatchedClassTypes(DecimalProp.class);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
            String varType = ((DynamicObject)this.getModel().getValue("variable")).getString("type");
            this.filterTreeNode(treeNode, type, "1".equals(varType));
            List children = treeNode.getChildren();
            if (children != null) {
                for (TreeNode treeNodeObject : children) {
                    List childPathNodes = treeNodeObject.getChildPathNodes(newValue);
                    if (childPathNodes == null || childPathNodes.size() <= 0) continue;
                    ComboItem item = new ComboItem();
                    item.setValue(((TreeNode)childPathNodes.get(0)).getId());
                    item.setCaption(new LocaleString(((TreeNode)childPathNodes.get(0)).getText()));
                    combo.selectedStore(item);
                    break;
                }
            }
        }
    }

    private void clearField() {
        int rowCount = this.getModel().getEntryRowCount("mappinfield");
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue(VARFIELDTEXT, null, i);
            this.getModel().setValue("variable", null, i);
            this.getModel().setValue("vardatasource", null, i);
            this.getModel().setValue("splitsymbol", null, i);
        }
    }

    private void initDataSource(String formId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        Map allEntities = entityType.getAllEntities();
        ComboEdit combo = (ComboEdit)this.getView().getControl("vardatasource");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map.Entry entry : allEntities.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue((String)entry.getKey());
            item.setCaption(((EntityType)entry.getValue()).getDisplayName());
            comboItems.add(item);
        }
        combo.setComboItems(comboItems);
    }

    private void showFieldSelect() {
        String formId = ((DynamicObject)this.getModel().getValue("busibill")).getString("number");
        String varType = ((DynamicObject)this.getModel().getValue("variable")).getString("type");
        String selectedField = (String)this.getModel().getValue("varfield");
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludePKField(true);
        option.setIncludeEntryEntityAsKeyPrefix(true);
        option.addMatchedClassTypes(TextProp.class);
        option.addMatchedClassTypes(DecimalProp.class);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        this.filterTreeNode(treeNode, type, "1".equals(varType));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_variablefieldf7");
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        showParameter.getCustomParams().put(CustParamKey_TreeNodes, nodesJson);
        showParameter.getCustomParams().put(CustParamKey_SelectedNodeIds, selectedField);
        showParameter.getCustomParams().put(CustParamKey_IsMulti, "false");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CloseCallBack_SelectField));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void filterTreeNode(TreeNode treeNode, MainEntityType mainEntityType, boolean onlyEntryNode) {
        List children = treeNode.getChildren();
        Map allEntities = mainEntityType.getAllEntities();
        if (children == null) {
            return;
        }
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            TreeNode node = (TreeNode)iter.next();
            if (onlyEntryNode && "billhead".equals(node.getId())) {
                iter.remove();
                continue;
            }
            if (!allEntities.containsKey(node.getId()) || !(allEntities.get(node.getId()) instanceof SubEntryType)) continue;
            iter.remove();
        }
    }
}

