/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class Variablefieldf7Plugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener {
    private static final String CustParamKey_TreeNodes = "treenodes";
    private static final String CustParamKey_IsMulti = "ismulti";
    private static final String CustParamKey_SelectedNodeIds = "nodeids";
    private static final String Key_btnOK = "btnok";
    private static final String Key_btnCancel = "btncancel";
    private static final String Key_TreeView = "tv_fields";
    private static final String CacheKey_SelectedNodes = "nodes";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        if (this.isMultiSelected()) {
            tv.setMulti(true);
        } else {
            tv.setMulti(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        this.fillTreeNodes(json);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            this.btnOk();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        TreeView treeView = (TreeView)e.getSource();
        Map focusNode = treeView.getTreeState().getFocusNode();
        this.getPageCache().put(CacheKey_SelectedNodes, SerializationUtils.toJsonString((Object)focusNode));
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodes = treeView.getTreeState().getCheckedNodes();
        this.getPageCache().put(CacheKey_SelectedNodes, SerializationUtils.toJsonString((Object)checkedNodes));
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        TreeView treeView = (TreeView)e.getSource();
        Map focusNode = treeView.getTreeState().getFocusNode();
        this.getView().returnDataToParent((Object)focusNode);
        this.btnOk();
    }

    private void btnOk() {
        String selectNodes = this.getPageCache().get(CacheKey_SelectedNodes);
        if (this.isMultiSelected()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)selectNodes)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6620\u5c04\u5b57\u6bb5", (String)"Variablefieldf7Plugin_0", (String)"bos-noteprint", (Object[])new Object[0]);
            this.getView().showMessage(msg);
            return;
        }
        Map focusNode = (Map)SerializationUtils.fromJsonString((String)selectNodes, Map.class);
        if ("true".equals(focusNode.get("isParent").toString())) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u52ff\u9009\u62e9\u7236\u8282\u70b9", (String)"Variablefieldf7Plugin_1", (String)"bos-noteprint", (Object[])new Object[0]);
            this.getView().showMessage(msg);
            return;
        }
        this.getView().returnDataToParent((Object)selectNodes);
        this.getView().close();
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_IsMulti);
        return "true".equals(isMulti);
    }

    private void fillTreeNodes(String strJson) {
        if (StringUtils.isBlank((CharSequence)strJson)) {
            TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"QuerySelectFieldList_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
            tree.addNode(root);
            return;
        }
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            tree.setMulti(true);
            String cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_SelectedNodeIds);
            if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
                String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
                ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
                for (String nodeId : arr) {
                    TreeNode node = rootNode.getTreeNode(nodeId, 5);
                    if (node == null) continue;
                    selectedNodes.add(node);
                }
                if (selectedNodes.size() > 0) {
                    tree.checkNodes(selectedNodes);
                }
            }
        }
    }
}

