/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin.datasource;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextField;

public class RefDatasourcePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String PROJECT_NAME = "bos-print-business";
    private static final String BTN_CLOSR = "btnclose";
    private static final String BTN_OK = "btnok";
    private static final String ENTRY_KEY = "entryentity";
    private static final String CURRENT_ROW_INDEX = "currentRowIndex";
    private static final String PD_ADDREFDATASOURCE = "pd_addrefdatasource";
    private static final String MAINENTITY_UNIONFIELD = "mainunionfield";
    private static final String IMPORT_ENTITY_ID = "importentityId";
    private static final String KEY_FILTERGRID = "filtergridap";
    private static final String IMPOETENTITY_UNIONFIELD = "importunionfield";
    private static final String QUERY_ENTITY = "queryentity";
    private static final String ALIAS = "alias";
    private static final String UNION_FIELD = "unionfield";
    private static final String CUS_NUMBER = "customnumber";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CLOSR, BTN_OK});
        this.addItemClickListeners(new String[]{"dstoolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map cusParams = this.getView().getFormShowParameter().getCustomParams();
        if (cusParams != null) {
            if (!ObjectUtils.isEmpty(cusParams.get("mainentityId"))) {
                String mainentityId = (String)cusParams.get("mainentityId");
                List<ComboItem> billHeadCols = this.getQueryFiled(mainentityId);
                ComboEdit sortfield = (ComboEdit)this.getView().getControl(MAINENTITY_UNIONFIELD);
                sortfield.setComboItems(billHeadCols);
            }
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
            if (!ObjectUtils.isEmpty(cusParams.get(IMPORT_ENTITY_ID))) {
                this.initControlData(cusParams.get(IMPORT_ENTITY_ID).toString());
            } else {
                filterGrid.setFieldColumns(new ArrayList());
            }
        }
    }

    private void initControlData(String importentityId) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
        List<ComboItem> billHeadCols = this.getQueryFiled(importentityId);
        ComboEdit sortfield = (ComboEdit)this.getView().getControl(IMPOETENTITY_UNIONFIELD);
        sortfield.setComboItems(billHeadCols);
        String entityNumber = MetadataDao.getEntityNumberById((String)importentityId);
        MainEntityType entityType = EntityMetadataCache.getDataEntityTypeById((String)importentityId);
        if (entityType instanceof QueryEntityType) {
            ArrayList<String> filterFieldKeys = new ArrayList<String>(10);
            List slectFields = ((QueryEntityType)entityType).getSelectFields();
            for (QuerySelectField field : slectFields) {
                filterFieldKeys.add(field.getAlias());
            }
            filterGrid.setFilterFieldKeys(filterFieldKeys);
        }
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
        filterGrid.setFilterColumns(cols);
        filterGrid.setEntityNumber(entityNumber);
    }

    private List<ComboItem> getQueryFiled(String entityId) {
        ArrayList<ComboItem> entries = new ArrayList();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        MainEntity rootEntiry = entityMetadata.getRootEntity();
        if (rootEntiry instanceof QueryEntity) {
            List mainSelectFields = ((QueryEntity)rootEntiry).getSelectFields();
            for (QuerySelectField field : mainSelectFields) {
                entries.add(new ComboItem(new LocaleString(field.getDisplayName()), field.getAlias()));
            }
        } else {
            entries = this.getBillHeadFields(entityMetadata);
        }
        return entries;
    }

    private List<ComboItem> getBillHeadFields(EntityMetadata entityMetadata) {
        ArrayList<ComboItem> entries = new ArrayList<ComboItem>();
        entries.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"RefDatasourcePlugin_0", (String)PROJECT_NAME, (Object[])new Object[0])), "id"));
        List entities = entityMetadata.getRootEntity().getItems();
        if (!entities.isEmpty()) {
            for (EntityItem entity : entities) {
                if (!(entity instanceof Field) || (!(entity instanceof TextField) || entity instanceof MuliLangTextField || entity instanceof LargeTextField) && !(entity instanceof IntegerField) && !(entity instanceof DecimalField) && !(entity instanceof BasedataField)) continue;
                entries.add(new ComboItem(entity.getName(), entity.getKey()));
            }
        }
        return entries;
    }

    public void entryRowClick(RowClickEvent e) {
        int rowIndex = e.getRow();
        if (rowIndex < 0) {
            return;
        }
        DynamicObject importentity = (DynamicObject)this.getModel().getValue(QUERY_ENTITY, rowIndex);
        String entityId = importentity.getString("dentityid");
        String cacheRowIndex = this.getPageCache().get(CURRENT_ROW_INDEX);
        if (StringUtils.isNotBlank((CharSequence)cacheRowIndex)) {
            if (rowIndex != Integer.parseInt(cacheRowIndex)) {
                this.getPageCache().put(CURRENT_ROW_INDEX, String.valueOf(rowIndex));
                this.initControlData(entityId);
            }
        } else {
            this.getPageCache().put(CURRENT_ROW_INDEX, String.valueOf(rowIndex));
            this.initControlData(entityId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("btndel".equals(evt.getItemKey())) {
            this.deleteRefQueryEntity();
        } else if ("btnnew".equals(evt.getItemKey())) {
            this.addRefQueryEntity();
        }
    }

    private void addRefQueryEntity() {
        String entityId = this.getCurrentEntityId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(PD_ADDREFDATASOURCE);
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        parameter.setCustomParam("currentEntityId", (Object)entityId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adddatasource"));
        this.getView().showForm(parameter);
    }

    private void deleteRefQueryEntity() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_KEY);
        if (rowIndex >= 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deleteRefQueryEntity", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u6570\u636e\u6e90\u53ef\u80fd\u5df2\u88ab\u4f7f\u7528\uff0c\u60a8\u786e\u8ba4\u9700\u8981\u5220\u9664\u4e48\uff1f", (String)"RefDatasourcePlugin_1", (String)PROJECT_NAME, (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5220\u9664\u884c\u3002", (String)"RefDatasourcePlugin_2", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getCallBackId().equals("deleteRefQueryEntity") && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            int[] rowIndex;
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
            for (int i : rowIndex = grid.getEntryState().getSelectedRows()) {
                this.getModel().deleteEntryRow(ENTRY_KEY, i);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() != null) {
            IDataModel model = this.getModel();
            if ("adddatasource".equals(evt.getActionId())) {
                Map retData = (Map)evt.getReturnData();
                Object queryEntityObj = retData.get(QUERY_ENTITY);
                Object alias = retData.get(ALIAS);
                Object customnumber = retData.get(CUS_NUMBER);
                int rowIndex = model.createNewEntryRow(ENTRY_KEY);
                model.setValue(QUERY_ENTITY, queryEntityObj, rowIndex);
                model.setValue(ALIAS, alias, rowIndex);
                model.setValue(CUS_NUMBER, customnumber, rowIndex);
                IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                viewProxy.invokeControlMethod(ENTRY_KEY, "selectRows", new Object[]{rowIndex});
                viewProxy.getEntryState(ENTRY_KEY).selectRow(rowIndex);
                this.getModel().setEntryCurrentRowIndex(ENTRY_KEY, rowIndex);
            }
        }
    }

    private String getCurrentEntityId() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        return entityId;
    }
}

