/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.testplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.facade.IPrintServiceFacade;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.grid.cardgrid.CardGrid;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class CustomSetCardPageNumberFacade
implements IPrintServiceFacade {
    private static Log log = LogFactory.getLog(CustomSetCardPageNumberFacade.class);

    public void beforeDoPrint(Map<String, Object> params) {
        try {
            PrintWork work = (PrintWork)params.get("printWork");
            PrintTask printTask = (PrintTask)work.getTaskList().get(0);
            String formId = printTask.getFormId();
            if (!String.valueOf(formId).contains("glddy")) {
                return;
            }
            Map<String, Object> listSetting = this.loadSetting(formId);
            int listfieldfont = Integer.parseInt(String.valueOf(listSetting.getOrDefault("listfieldfont", 1)));
            PrintMetadata metadata = (PrintMetadata)params.get("metadata");
            for (List page : metadata.getPages()) {
                for (Control control : page) {
                    if (!(control instanceof CardGrid)) continue;
                    CardGrid cardGrid = (CardGrid)control;
                    cardGrid.setPagePrintN(Integer.valueOf(listfieldfont));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, Object> loadSetting(String formId) {
        String userId = RequestContext.get().getUserId();
        String key = formId + "_listprintsetting";
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)key);
        Map<String, Object> setting = new HashMap<String, Object>(16);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            setting = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return setting;
    }
}

