/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.testplugin;

import java.util.Collection;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.AfterOutputWidgetEvent;
import kd.bos.template.orgctrl.model.PrintTemplateInfo;
import kd.bos.template.orgctrl.model.TemplateInfo;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;

public class PrintTemplateInfoTestPlugin
extends AbstractPrintPlugin {
    private PrintTemplateInfo printTpl;

    public void afterOutputWidget(AfterOutputWidgetEvent evt) {
        super.afterOutputWidget(evt);
        String key = evt.getWidgetKey();
        if (null == this.printTpl) {
            return;
        }
        if ("formId".equals(key)) {
            evt.setOutputValue((Field)new TextField(this.printTpl.getFormId() == null ? "" : this.printTpl.getFormId()));
        } else if ("printerId".equals(key)) {
            evt.setOutputValue((Field)new TextField(this.printTpl.getPrinterId() == null ? "" : String.valueOf(this.printTpl.getPrinterId())));
        } else if ("printLang".equals(key)) {
            evt.setOutputValue((Field)new TextField(this.printTpl.getPrintLang() == null ? "" : this.printTpl.getPrintLang()));
        } else if ("userSettingTplId".equals(key)) {
            evt.setOutputValue((Field)new TextField(this.printTpl.getUserSettingTplId() == null ? "" : this.printTpl.getUserSettingTplId()));
        } else if ("tplList".equals(key)) {
            List tplList = this.printTpl.getTplList();
            StringBuilder sb = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)tplList)) {
                int i = 0;
                for (TemplateInfo info : tplList) {
                    sb.append(++i).append("   ").append("tplId\uff1a").append(info.getId()).append("   ").append("tplName\uff1a").append(info.getName()).append("   ").append("tplType\uff1a").append(info.getType()).append("   ").append("\n");
                }
            }
            evt.setOutputValue((Field)new TextField(sb.toString()));
        }
    }

    public void afterLoadData(AfterLoadDataEvent evt) {
        DsType dsType;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String formId = null;
        PrtDataSource dataSource = evt.getDataSource();
        if (null != dataSource && (dsType = dataSource.getDsType()) instanceof DsType && "MAIN".equals(DsType.MAIN.name())) {
            MainDataSource source = (MainDataSource)dataSource;
            formId = source.getFormId();
        }
        PrintTemplateInfo printTemplate = PrintTemplateServiceFactory.getService().getPrintTemplate(userId, formId);
        this.setPrintTpl(printTemplate);
    }

    public PrintTemplateInfo getPrintTpl() {
        return this.printTpl;
    }

    public void setPrintTpl(PrintTemplateInfo printTpl) {
        this.printTpl = printTpl;
    }
}

