/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.testplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.template.orgctrl.model.PrintTemplateInfo;
import kd.bos.template.orgctrl.model.TemplateInfo;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.url.UrlService;

public class TestExportExcelDyFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"custprint"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String pkValue = customParams.get("businessKey").toString();
        this.getPageCache().put("pkId", pkValue);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"kdtest_kd_cgdd");
        if (dynamicObject != null) {
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", entryEntity.size());
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryRow = (DynamicObject)entryEntity.get(i);
                this.getModel().setValue("material", entryRow.get("material"), i);
                this.getModel().setValue("specification", entryRow.get("specification"), i);
                this.getModel().setValue("unitfield", entryRow.get("unitfield"), i);
                this.getModel().setValue("orderqty", entryRow.get("orderqty"), i);
                this.getModel().setValue("applyqty", entryRow.get("applyqty"), i);
                this.getModel().setValue("amountfield", entryRow.get("amountfield"), i);
            }
            this.getModel().setValue("org", dynamicObject.get("org"));
            this.getModel().setValue("billno", dynamicObject.get("billno"));
        }
    }

    public void click(EventObject evt) {
        Button button = (Button)evt.getSource();
        if ("custprint".equals(button.getKey())) {
            PrintWork printWork = this.createPrintWork();
            PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)printWork);
            this.previewResult(prtAttach);
            this.getView().close();
        }
    }

    private PrintWork createPrintWork() {
        PrintWork printWork = new PrintWork();
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(1);
        PrintTask printTask = new PrintTask();
        printTask.setFormId("kdtest_kd_cgdd");
        PrintTemplateInfo templateInfo = PrintTemplateServiceFactory.getService().getPrintTemplate(Long.valueOf(RequestContext.get().getCurrUserId()), "kdtest_kd_cgdd");
        List tplList = templateInfo.getTplList();
        String tplId = "";
        if (tplList != null && tplList.size() > 0) {
            tplId = ((TemplateInfo)tplList.get(0)).getId();
        }
        printTask.setTplId(tplId);
        ArrayList<String> pkIds = new ArrayList<String>(1);
        pkIds.add(this.getPageCache().get("pkId"));
        printTask.setPkIds(pkIds);
        taskList.add(printTask);
        printWork.setTaskList(taskList);
        printWork.setExpType(PrintWork.EXP_TYPE.EXP_XLS.getCode());
        return printWork;
    }

    private void previewResult(PrtAttach prtAttach) {
        String taskId = prtAttach.getTaskId();
        for (PrtAttach.AttachDetail attachDetail : prtAttach.getAttachDetail()) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("bos_printpreview");
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            HashMap<String, String> reservedSpace = new HashMap<String, String>(1);
            reservedSpace.put("reservedSpace", "true");
            para.getOpenStyle().setCustParam(reservedSpace);
            para.setCustomParam("src", (Object)String.format(UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s ", taskId, attachDetail.getAttachId()));
            this.getView().getParentView().showForm(para);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

