/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.testplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.template.orgctrl.model.PrintTemplateInfo;
import kd.bos.template.orgctrl.model.TemplateInfo;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.url.UrlService;

public class TestExportExcelMobiDyFormPlugin
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Donothing) {
            PrintWork printWork = this.createPrintWork();
            PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)printWork);
            this.previewResult(prtAttach);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String pkValue = customParams.get("businessKey").toString();
        this.getPageCache().put("pkId", pkValue);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"kdtest_kd_cgdd");
        if (dynamicObject != null) {
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", entryEntity.size());
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryRow = (DynamicObject)entryEntity.get(i);
                this.getModel().setValue("specification", entryRow.get("specification"), i);
            }
            this.getModel().setValue("org", dynamicObject.get("org"));
            this.getModel().setValue("billno", dynamicObject.get("billno"));
        }
    }

    private PrintWork createPrintWork() {
        PrintWork work = new PrintWork();
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(1);
        PrintTask task = new PrintTask();
        task.setFormId("kdtest_kd_cgdd");
        PrintTemplateInfo tplInfo = PrintTemplateServiceFactory.getService().getPrintTemplate(Long.valueOf(RequestContext.get().getCurrUserId()), "kdtest_kd_cgdd");
        List tplList = tplInfo.getTplList();
        String tplId = "";
        if (tplList != null && tplList.size() > 0) {
            tplId = ((TemplateInfo)tplList.get(0)).getId();
        }
        task.setTplId(tplId);
        ArrayList<String> pkIds = new ArrayList<String>(1);
        pkIds.add(this.getPageCache().get("pkId"));
        task.setPkIds(pkIds);
        taskList.add(task);
        work.setTaskList(taskList);
        work.setExpType(PrintWork.EXP_TYPE.EXP_XLS.getCode());
        return work;
    }

    private void previewResult(PrtAttach prtAttach) {
        String taskId = prtAttach.getTaskId();
        for (PrtAttach.AttachDetail attachDetail : prtAttach.getAttachDetail()) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("bos_printpreview");
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            HashMap<String, String> reservedSpace = new HashMap<String, String>(1);
            reservedSpace.put("reservedSpace", "true");
            para.getOpenStyle().setCustParam(reservedSpace);
            para.setCustomParam("src", (Object)String.format(UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s", taskId, attachDetail.getAttachId()));
            this.getView().getParentView().showForm(para);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

