/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.testplugin;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.facade.IPrintServiceFacade;
import kd.bos.print.api.facade.param.PrintLogParam;
import kd.bos.service.ServiceFactory;

public class TestLogPrintServiceFacade
implements IPrintServiceFacade {
    private static ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public boolean cancelOpLog() {
        return true;
    }

    public void beforeDoOperationLog(PrintLogParam logParam) {
        Map pkBillNoMap = logParam.getPkBillNoMap();
        if (CollectionUtils.isEmpty((Map)pkBillNoMap)) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)logParam.getEntityId());
        if (!(dataEntityType instanceof BillEntityType)) {
            return;
        }
        for (Map.Entry entry : pkBillNoMap.entrySet()) {
            AppLogInfo appLogInfo = TestLogPrintServiceFacade.buildLogInfo(logParam.getAppId(), logParam.getEntityId(), "web", logParam.getOpName(), "billno:" + (String)entry.getValue() + logParam.getOpName() + "suscess");
            logService.addLog(appLogInfo);
        }
    }

    private static AppLogInfo buildLogInfo(String appId, String entityId, String clientType, String opName, String description) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String bizAppid = TestLogPrintServiceFacade.getAppId(appId, entityId);
        logInfo.setBizAppID(bizAppid);
        logInfo.setBizObjID(entityId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(clientType);
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(description);
        return logInfo;
    }

    private static String getAppId(String appNumber, String entityId) {
        AppInfo appInfo;
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            return appInfo.getId();
        }
        if (StringUtils.isBlank((CharSequence)appNumber)) {
            BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
            if (StringUtils.isNotBlank((CharSequence)entityId)) {
                return bizAppService.getAppIdByFormNum(entityId);
            }
        }
        return "";
    }
}

