/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class DataType
implements Serializable {
    private static final long serialVersionUID = 2751819193028008520L;
    public static final int INT_BOOLEAN = 0;
    public static final int INT_BYTE = 1;
    public static final int INT_SHORT = 2;
    public static final int INT_INTEGER = 3;
    public static final int INT_LONG = 4;
    public static final int INT_DECIMAL = 5;
    public static final int INT_FLOAT = 6;
    public static final int INT_DOUBLE = 7;
    public static final int INT_STRING = 8;
    public static final int INT_DATETIME = 9;
    public static final int INT_CLOB = 10;
    public static final int INT_BLOB = 11;
    public static final int INT_BINARY = 12;
    public static final int INT_NULL = 13;
    public static final DataType BOOLEAN = new DataType("boolean", Boolean.class, 0);
    public static final DataType BYTE = new DataType("byte", Byte.class, 1);
    public static final DataType SHORT = new DataType("short", Short.class, 2);
    public static final DataType INTEGER = new DataType("integer", Integer.class, 3);
    public static final DataType LONG = new DataType("long", Long.class, 4);
    public static final DataType DECIMAL = new DataType("decimal", BigDecimal.class, 5);
    public static final DataType FLOAT = new DataType("float", Float.class, 6);
    public static final DataType DOUBLE = new DataType("double", Double.class, 7);
    public static final DataType STRING = new DataType("string", String.class, 8);
    public static final DataType DATETIME = new DataType("datetime", Date.class, 9);
    public static final DataType CLOB = new DataType("clob", Clob.class, 10);
    public static final DataType BLOB = new DataType("blob", Blob.class, 11);
    public static final DataType BINARY = new DataType("binary", byte[].class, 12);
    public static final DataType NULL = new DataType("null", null, 13);
    protected static final DataType[] ALL_TYPES = new DataType[]{STRING, DATETIME, BOOLEAN, DECIMAL, DOUBLE, FLOAT, INTEGER, LONG, SHORT, BINARY, BYTE, BLOB, CLOB, NULL};
    protected static final DataType[] BASIC_TYPES = new DataType[]{STRING, DATETIME, DECIMAL, DOUBLE, FLOAT, INTEGER, LONG, SHORT};
    private static int[][] coverable_tables = new int[][]{{2, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2}, {1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 2}, {1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 2}, {1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 2}, {1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 2}, {1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 2}, {1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 2}, {1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 2}, {1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 1, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 1, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 2, 2}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}};
    private String name;
    private Class javaType;
    private int intValue;

    private DataType(String name, Class javaType, int i) {
        this.name = name;
        this.javaType = javaType;
        this.intValue = i;
    }

    public int convertableType(DataType targetDT) {
        return coverable_tables[this.intValue][targetDT.intValue];
    }

    public int intValue() {
        return this.intValue;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public static DataType fromName(String typeName) {
        if (STRING.getName().equals(typeName)) {
            return STRING;
        }
        if (CLOB.getName().equals(typeName)) {
            return CLOB;
        }
        if (INTEGER.getName().equals(typeName)) {
            return INTEGER;
        }
        if (LONG.getName().equals(typeName)) {
            return LONG;
        }
        if (SHORT.getName().equals(typeName)) {
            return SHORT;
        }
        if (BYTE.getName().equals(typeName)) {
            return BYTE;
        }
        if (BOOLEAN.getName().equals(typeName)) {
            return BOOLEAN;
        }
        if (DECIMAL.getName().equals(typeName)) {
            return DECIMAL;
        }
        if (DATETIME.getName().equals(typeName)) {
            return DATETIME;
        }
        if (FLOAT.getName().equals(typeName)) {
            return FLOAT;
        }
        if (DOUBLE.getName().equals(typeName)) {
            return DOUBLE;
        }
        if (BINARY.getName().equals(typeName)) {
            return BINARY;
        }
        if (BLOB.getName().equals(typeName)) {
            return BLOB;
        }
        if (NULL.getName().equals(typeName)) {
            return NULL;
        }
        assert (false);
        return NULL;
    }

    public static Class toJavaType(int jdbcType) {
        switch (jdbcType) {
            case 1: 
            case 12: {
                return String.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 5: {
                return Short.class;
            }
            case -6: {
                return Byte.class;
            }
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 7: {
                return Float.class;
            }
            case 91: {
                return java.sql.Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case -3: 
            case -2: {
                return byte[].class;
            }
            case -4: 
            case -1: {
                return InputStream.class;
            }
            case 2004: {
                return Blob.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 2003: {
                return Array.class;
            }
            case 2006: {
                return Ref.class;
            }
            case 70: {
                return URL.class;
            }
        }
        return null;
    }

    public static boolean isNumberType(DataType type) {
        return INTEGER.equals(type) || LONG.equals(type) || SHORT.equals(type) || DECIMAL.equals(type) || FLOAT.equals(type) || DOUBLE.equals(type);
    }
}

