/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.FileUtil;
import kd.bos.print.core.ctrl.common.util.StreamUtil;

public class GlobalLocator {
    public static final Log logger = LogFactory.getLog(GlobalLocator.class);
    public static final char SPLIT_CHAR = '/';
    private static final GlobalLocator instance = new GlobalLocator();
    private final String CTRL_HOME = "ctrlhome";
    private final String USER_HOME = "user.home";
    private final String RESOURCE_HOME = "com/kingdee/bos/ctrl/ctrlhome";
    public static final String TEMP_DIR = "/temp";
    private String homeDir;

    public static GlobalLocator getInstance() {
        return instance;
    }

    private GlobalLocator() {
        this.makeHomeDir();
    }

    private void makeHomeDir() {
        int z;
        char c;
        this.homeDir = this.getSystemProperty("ctrlhome");
        if (this.homeDir == null) {
            URL url;
            ClassLoader clsLdr = this.getClass().getClassLoader();
            if (clsLdr == null) {
                clsLdr = ClassLoader.getSystemClassLoader();
            }
            if ((url = clsLdr.getResource("ctrlhome")) != null) {
                this.homeDir = url.getPath();
            }
            if (this.homeDir == null) {
                this.homeDir = this.getSystemProperty("user.home") + FileUtil.FILE_SEPARATOR + "ctrlhome";
            }
        }
        if ((c = this.homeDir.charAt(z = this.homeDir.length() - 1)) == File.separatorChar || c == '/') {
            this.homeDir = this.homeDir.substring(0, z);
        }
    }

    private String getSystemProperty(String key) {
        String value = System.getProperty(key);
        value = FileUtil.normalize((String)value);
        return value;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String makeFilePath(String pathText) {
        if (pathText == null || this.homeDir == null) {
            return null;
        }
        if (pathText.length() == 0) {
            return this.homeDir;
        }
        if (pathText.charAt(0) == '/') {
            if (File.separatorChar != '/') {
                pathText = pathText.replace('/', File.separatorChar);
            }
            return this.homeDir + pathText;
        }
        return pathText;
    }

    public String makeResourcePath(String pathText) {
        return "com/kingdee/bos/ctrl/ctrlhome" + pathText;
    }

    public File createResourceFile(String pathText) throws IOException {
        String resPath = this.makeResourcePath(pathText);
        URL resUrl = this.getClass().getClassLoader().getResource(resPath);
        if (resUrl == null) {
            return null;
        }
        String filePath = this.makeFilePath(pathText);
        File f = FileUtil.createFile((String)filePath);
        if (f == null) {
            return null;
        }
        try (InputStream res = resUrl.openStream();
             FileOutputStream fos = new FileOutputStream(f);){
            StreamUtil.copy((InputStream)res, (OutputStream)fos, (int)4096);
        }
        return f;
    }

    public File createTempFile(String prefix, String suffix) {
        try {
            File temp = File.createTempFile(prefix, suffix, this.locateResourceFolder(TEMP_DIR));
            return temp;
        }
        catch (IOException e) {
            return null;
        }
    }

    public File locateResourceFolder(String pathText) {
        String filePath = this.makeFilePath(pathText);
        File f = new File(filePath);
        if (!f.exists() && (f = FileUtil.createFolder((String)filePath)) == null) {
            return null;
        }
        if (f.isDirectory()) {
            return f;
        }
        return null;
    }

    public File locateResourceFile(String pathText) {
        File f = new File(this.makeFilePath(pathText));
        if (!f.exists()) {
            try {
                f = this.createResourceFile(pathText);
            }
            catch (Exception e) {
                return null;
            }
            if (f == null) {
                return null;
            }
        }
        if (f.isFile()) {
            return f;
        }
        return null;
    }

    public InputStream locateResourceFileStream(String pathText) {
        FileInputStream fis;
        File f = this.locateResourceFile(pathText);
        if (f == null) {
            return null;
        }
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return fis;
    }
}

