/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common;

import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;

public class LanguageManager {
    private static final Log log = LogFactory.getLog(LanguageManager.class);
    public static final Locale ZH_CN = new Locale("zh", "CN");
    private static final Locale EN_US = new Locale("en", "US");

    public static String getLangMessage(String key, Class classInstance, String tempInfo) {
        return LanguageManager.getLangMessage(key, classInstance, Locale.getDefault(), tempInfo);
    }

    public static String getLangMessage(String key, String resPath, String tempInfo) {
        return LanguageManager.getLangMessage(key, resPath, LanguageManager.getDefaultLocale(), tempInfo);
    }

    public static Locale getDefaultLocale() {
        String lang = ExecuteContext.get().getLang();
        if (StringUtils.isBlank((CharSequence)lang)) {
            return ZH_CN;
        }
        if ("en_US".equalsIgnoreCase(lang)) {
            return EN_US;
        }
        return ZH_CN;
    }

    public static String getLangMessage(String key, String resPath, Locale locale, String tempInfo) {
        ResourceBundle bundle = null;
        try {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            bundle = ResourceBundle.getBundle(resPath, locale);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            String keyInfo;
            if (bundle != null && (keyInfo = bundle.getString(key)) != null) {
                return keyInfo;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (tempInfo != null) {
            return tempInfo;
        }
        throw new MissingResourceException("Do not find any mapping Language Info or Do not specified one temporary text.", null, key);
    }

    public static String getLangMessage(String key, Class classInstance, Locale locale, String tempInfo) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String resPath = LanguageManager.getBundlePath(classInstance);
        return LanguageManager.getLangMessage(key, resPath, locale, tempInfo);
    }

    public static String getBundlePath(Class cName) {
        if (cName != null) {
            return cName.getName();
        }
        return "";
    }

    public static final String getProperty(HashMap properties, String name) {
        return LanguageManager.getProperty(properties, name, Locale.getDefault());
    }

    public static final String getProperty(HashMap properties, String name, Locale locale) {
        if (locale == null) {
            return LanguageManager.getProperty(properties, name);
        }
        String key = (String)properties.get(name);
        if (key == null || "#1".equals(key)) {
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append('.');
            sb.append(locale);
            key = (String)properties.get(sb.toString());
        }
        return key == null ? (String)properties.get(name) : key;
    }
}

