/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import kd.bos.print.core.ctrl.common.util.StringUtil;

public class LangUtil {
    public static final String SPLIT_TEXT = "_";
    public static final char SPLIT_CHAR = "_".charAt(0);
    private static Map langSuffix = new HashMap(16);
    private static Locale cacheLocale;
    private static Vector bundleTails;

    public static final String makeDefaultLang() {
        return LangUtil.makeLang(Locale.getDefault());
    }

    public static final String makeLang(Locale locale) {
        return locale.toString();
    }

    public static final Locale parseLang(String lang) {
        String[] ss = lang.split(SPLIT_TEXT);
        if (ss.length == 1) {
            return new Locale(ss[0]);
        }
        if (ss.length == 2) {
            return new Locale(ss[0], ss[1]);
        }
        if (ss.length == 3) {
            return new Locale(ss[0], ss[1], ss[2]);
        }
        return null;
    }

    private static String getSuffix(Locale l) {
        String suffix = (String)langSuffix.get(l);
        if (suffix == null) {
            suffix = "." + LangUtil.makeLang(l);
            langSuffix.put(l, suffix);
        }
        return suffix;
    }

    public static boolean isMultiLangProperty(Map ps, String name) {
        return "#1".equals(ps.get(name));
    }

    public static void setMultiLangProperty(Map ps, String name) {
        ps.put(name, "#1");
    }

    public static HashMap getProperty(Map ps, String name) {
        String prefix = name + ".";
        int prefixLen = prefix.length();
        Iterator itr = ps.entrySet().iterator();
        HashMap vals = new HashMap();
        while (itr.hasNext()) {
            Map.Entry ent = itr.next();
            String key = (String)ent.getKey();
            if (!key.startsWith(prefix)) continue;
            vals.put(LangUtil.parseLang(key.substring(prefixLen)), ent.getValue());
        }
        return vals;
    }

    public static HashMap getPropertyStr(Map ps, String name) {
        String prefix = name + ".";
        int prefixLen = prefix.length();
        Iterator itr = ps.entrySet().iterator();
        HashMap vals = new HashMap();
        while (itr.hasNext()) {
            Map.Entry ent = itr.next();
            String key = (String)ent.getKey();
            if (!key.startsWith(prefix)) continue;
            vals.put(key.substring(prefixLen), ent.getValue());
        }
        return vals;
    }

    public static Object getProperty(Map ps, String name, Locale l) {
        if (l == null) {
            return ps.get(name);
        }
        Object val = ps.get(name);
        if ("#1".equals(val)) {
            return LangUtil.getMultiLanguage(ps, name + ".", l);
        }
        return val;
    }

    public static void setProperty(Map ps, String name, Map vals) {
        for (Map.Entry ent : vals.entrySet()) {
            Object key = ent.getKey();
            Locale l = key instanceof Locale ? (Locale)ent.getKey() : LangUtil.parseLang(key.toString());
            LangUtil.setProperty(ps, name, l, ent.getValue());
        }
    }

    public static void setProperty(Map ps, String name, Locale l, Object val) {
        if (l == null) {
            ps.put(name, val);
        } else {
            if (!"#1".equals(ps.get(name))) {
                ps.put(name, "#1");
            }
            ps.put(name + LangUtil.getSuffix(l), val);
        }
    }

    private static Vector getBundleTails() {
        if (!Locale.getDefault().equals(cacheLocale)) {
            cacheLocale = Locale.getDefault();
            bundleTails = LangUtil.calculateBundleNames("", cacheLocale);
        }
        return bundleTails;
    }

    public static String[] getFileNames(String files, String properties) {
        Vector v = LangUtil.getBundleTails();
        int size = v.size();
        String[] fileName = new String[size];
        for (int i = 0; i < size; ++i) {
            String language = v.get(size - i - 1).toString().substring(1);
            fileName[i] = files + SPLIT_TEXT + language + properties;
        }
        return fileName;
    }

    public static boolean isEmptyValue(String s) {
        return StringUtil.isEmptyString((String)s) || "#1".equals(s);
    }

    private static Vector calculateBundleNames(String baseName, Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        Vector<String> result = new Vector<String>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuilder temp = new StringBuilder(baseName);
        temp.append('.');
        temp.append(language);
        if (languageLength > 0) {
            result.addElement(temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.addElement(temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }

    public static String getMultiLanguage(Map multiHashMap, String extend) {
        return LangUtil.getMultiLanguage(multiHashMap, extend, Locale.getDefault());
    }

    public static String getMultiLanguage(Map multiHashMap, String extend, Locale locale) {
        String l = locale.getLanguage().toLowerCase();
        String c = locale.getCountry().toUpperCase();
        String v = locale.getVariant().toLowerCase();
        String key = (extend = extend == null ? "" : extend) + l + SPLIT_TEXT + c + SPLIT_TEXT + v;
        String multiLanguage = (String)multiHashMap.get(key);
        if (!StringUtil.isEmptyString((String)multiLanguage)) {
            return multiLanguage;
        }
        key = extend + l + SPLIT_TEXT + c;
        multiLanguage = (String)multiHashMap.get(key);
        if (!StringUtil.isEmptyString((String)multiLanguage)) {
            return multiLanguage;
        }
        multiLanguage = (String)multiHashMap.get(extend + l);
        return multiLanguage;
    }

    public static Locale createLanguage(String language) {
        String[] l = language.split(SPLIT_TEXT);
        if (l.length == 3) {
            return new Locale(l[0], l[1], l[2]);
        }
        if (l.length == 2) {
            return new Locale(l[0], l[1]);
        }
        return new Locale(l[0]);
    }
}

