/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.data.modal;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.print.core.ctrl.common.util.LangUtil;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.data.modal.IDefObj;

public class DefObj
implements IDefObj {
    public static final String P_ALIAS = "alias";
    public static final String P_DESC = "desc";
    private String name;
    private Map properties;

    @Override
    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public final Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public final String getStrProperty(String name) {
        return (String)this.getProperty(name);
    }

    public final void setProperty(String name, Object val) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, val);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAlias() {
        return this.getAlias(Locale.getDefault());
    }

    public String getAlias(Locale l) {
        return (String)LangUtil.getProperty(this.getProperties(), P_ALIAS, l);
    }

    @Override
    public void setAlias(String alias) {
        this.setAlias(alias, Locale.getDefault());
    }

    public void setAlias(String alias, Locale l) {
        LangUtil.setProperty(this.getProperties(), P_ALIAS, l, alias);
    }

    @Override
    public String getAliasName() {
        String alias = this.getAlias();
        if (!StringUtil.isEmptyString((String)alias)) {
            return alias;
        }
        int i = this.name.indexOf(46);
        return i == -1 ? this.name : this.name.substring(0, i);
    }

    @Override
    public String getDesc() {
        return this.getDesc(Locale.getDefault());
    }

    public String getDesc(Locale l) {
        return (String)LangUtil.getProperty(this.getProperties(), P_DESC, l);
    }

    @Override
    public void setDesc(String desc) {
        this.setDesc(desc, Locale.getDefault());
    }

    public void setDesc(String desc, Locale l) {
        LangUtil.setProperty(this.getProperties(), P_DESC, l, desc);
    }

    public String toString() {
        return this.getAliasName();
    }

    @Override
    public void copy(IDefObj obj) {
        if (obj.getName() != null) {
            this.setName(obj.getName());
        }
        this.add(this.getProperties(), obj.getProperties());
    }

    private void add(Map out, Map in) {
        if (in == null || out == null) {
            return;
        }
        int z = in.size();
        if (z == 0) {
            return;
        }
        Map.Entry[] ents = new Map.Entry[z];
        in.entrySet().toArray(ents);
        for (int i = 0; i < z; ++i) {
            Map.Entry ent = ents[i];
            out.put(ent.getKey(), ent.getValue());
        }
    }
}

