/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.form2.ui;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.GlobalLocator;
import kd.bos.print.core.ctrl.kdf.form2.ui.INotePrintHelper;
import kd.bos.print.core.ctrl.print.KDPrinter;

public abstract class AbstractNotePrint
implements INotePrintHelper {
    public static final Log log = LogFactory.getLog(AbstractNotePrint.class);
    private static Properties noteProperties;
    private KDPrinter _ctrlPrint;

    private static synchronized Properties getNoteConfig() {
        if (noteProperties == null) {
            noteProperties = new Properties();
            InputStream is = GlobalLocator.getInstance().locateResourceFileStream("/client/NoteConfig.properties");
            if (is != null) {
                noteProperties.clear();
                try {
                    noteProperties.load(is);
                }
                catch (IOException e) {
                    log.debug("\u8bfb\u53d6\u5957\u6253\u53c2\u6570\u8bbe\u7f6e\u6587\u4ef6\u5931\u8d25", (Object)e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.debug("\u5173\u95ed\u8f93\u5165\u6d41\u5931\u8d25" + e);
                    }
                }
            }
        }
        return noteProperties;
    }

    @Override
    public void setPrinterCtrl(KDPrinter printer) {
        this._ctrlPrint = printer;
    }

    public KDPrinter getPrinterCtrl() {
        return this._ctrlPrint;
    }

    public static int runPrintCtrl(KDPrinter printer, boolean isPreview, boolean isShowPrinterDialog, Component owner, String title) {
        printer.getPrintConfig().setPrintJobName(title);
        if (!isShowPrinterDialog) {
            printer.printDirect();
        }
        return -1;
    }

    public static synchronized int getMaxPagesLimit() {
        String value = AbstractNotePrint.getNoteConfig().getProperty("MaxPagesLimit");
        int result = 10000;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                log.debug(e.getMessage());
            }
        }
        return result;
    }

    protected synchronized boolean isShowMarginPanel() {
        String value = AbstractNotePrint.getNoteConfig().getProperty("ShowMarginPanel");
        return "true".equalsIgnoreCase(value);
    }

    public static synchronized boolean isExportExcel() {
        String value = AbstractNotePrint.getNoteConfig().getProperty("ExportExcel");
        return "true".equalsIgnoreCase(value);
    }
}

