/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.r1print;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.kdf.util.render.NoteTextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.StandardUnderline;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;
import kd.bos.print.core.execute.render.common.linewrap.process.ShrinkWrapProcess;
import kd.bos.print.core.model.ui.view.StyleRender;

public class ComplexTextRenderer {
    private static final Log log = LogFactory.getLog(ComplexTextRenderer.class);
    private NoteTextRender _noteTextRender;

    public ComplexTextRenderer() {
    }

    public ComplexTextRenderer(NoteTextRender noteTextRender) {
        this._noteTextRender = noteTextRender;
    }

    private NoteTextRender getNoteTextRender() {
        if (this._noteTextRender == null) {
            this._noteTextRender = NoteTextRender.shareInstance();
        }
        return this._noteTextRender;
    }

    private static boolean isShrinkWrap(Style style) {
        return style.isWrapText() && style.isShrinkText();
    }

    public void draw(Graphics g, Shape clip, Object object, Style style) {
        this.draw(g, clip, object, style, null);
    }

    public void draw(Graphics g, Shape clip, Object object, Style style, LineWrapParam param) {
        String text = this.object2String(object);
        if (StringUtil.isEmptyString((String)text)) {
            return;
        }
        if (ComplexTextRenderer.isShrinkWrap(style)) {
            Rectangle rect = clip.getBounds();
            if (rect.width <= 0 || rect.height <= 0) {
                return;
            }
            int oriHeight = rect.height;
            boolean wordFlex = false;
            if (param != null) {
                if (param.getRule() == LineWrapRule.NoWrap) {
                    rect.width = StyleRender.getContentBounds((int)param.getMinW(), (int)0, (Style)style).width;
                }
                wordFlex = param.isWordFlex();
            }
            DrawingInfo info = this.thickAdjust((Graphics2D)g, text, rect.width, rect.height, style);
            LineWrapRule rule = param == null ? null : param.getRule();
            int yOffset = this.thinAdjust((Graphics2D)g, rect, info, style, rule, oriHeight, wordFlex);
            this.drawing((Graphics2D)g, rect, info, style, yOffset, rule, wordFlex);
        } else if (param == null) {
            this.getNoteTextRender().draw(g, clip, object, style);
        } else {
            this.getNoteTextRender().draw(g, clip, (Object)param, style);
        }
    }

    private String object2String(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    private static float estimateAvgCharWidth(String text, Font font, float wordSpacing) {
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        float width = fm.stringWidth(text);
        return width / (float)text.length() + wordSpacing;
    }

    private static float calculateLineHeight(String text, Font font, float lineSpacing, Graphics2D g2d) {
        LineMetrics lm = font.getLineMetrics(text, 0, 1, g2d.getFontRenderContext());
        return lm.getHeight() + lineSpacing;
    }

    private static Font createFont(Style style, float fontSize) {
        int boldAndItalic = 0;
        boldAndItalic += style.isBold() ? 1 : 0;
        return KDFont.loadFontFromJAR((String)style.getFontName(), (int)(boldAndItalic += style.isItalic() ? 2 : 0), (float)fontSize);
    }

    private static float getOriSize(Style style) {
        return style.getKDFont().getSize2D();
    }

    public DrawingInfo thickAdjust(Graphics2D g2d, String text, int width, int height, Style style) {
        float lineHeight;
        float wordSpacing = style.getWordspacing();
        float lineSpacing = style.getLinespacing();
        float fontSize = ComplexTextRenderer.getOriSize(style);
        while (true) {
            float rate;
            if (fontSize <= 0.0f) {
                return DrawingInfo.create(text, 0, 0.0f, 0.0f, 0.0f);
            }
            Font font = ComplexTextRenderer.createFont(style, fontSize);
            float avgCharWidth = ComplexTextRenderer.estimateAvgCharWidth(text, font, wordSpacing);
            if ((float)width < avgCharWidth) {
                rate = (float)width / avgCharWidth;
                log.debug("\u5bbd\u5ea6\u592a\u5c0f\uff0c\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + (fontSize *= rate));
                continue;
            }
            lineHeight = ComplexTextRenderer.calculateLineHeight(text, font, lineSpacing, g2d);
            if ((float)height < lineHeight) {
                rate = (float)height / lineHeight;
                log.debug("\u9ad8\u5ea6\u592a\u5c0f\uff0c\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + (fontSize *= rate));
                continue;
            }
            float lineCount = (float)height / lineHeight;
            int acceptedCharCount = (int)((float)width / avgCharWidth * lineCount);
            if (acceptedCharCount >= text.length()) break;
            fontSize = (float)((double)fontSize * Math.sqrt((float)acceptedCharCount / (float)text.length()));
            log.debug("\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + fontSize);
        }
        return DrawingInfo.create(text, fontSize, lineHeight, wordSpacing, lineSpacing);
    }

    public int thinAdjust(Graphics2D g2d, Rectangle rect, DrawingInfo info, Style style) {
        return this.thinAdjust(g2d, rect, info, style, null, rect.height, false);
    }

    public int thinAdjust(Graphics2D g2d, Rectangle rect, DrawingInfo info, Style style, LineWrapRule rule, int oriHeight, boolean wordFlex) {
        String text = info.getText();
        CalculateExtend ce = new CalculateExtend(g2d);
        int testTimes = 0;
        boolean toTry = true;
        while (toTry) {
            log.debug("\u8bd5\u63a2\u7b2c" + ++testTimes + "\u6b21\uff0c\u5b57\u53f7\uff1a" + info.getFontSizeF());
            Font font = ComplexTextRenderer.createFont(style, info.getFontSizeF());
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            LineMetrics lm = font.getLineMetrics(text, g2d.getFontRenderContext());
            ce.setOnceMore(false);
            if (rule == null) {
                ComplexTextRenderer.throughStringAtRect(text, info, style, rect.width, rect.height, fm, lm, ce);
            } else {
                ComplexTextRenderer.throughStringAtRect(text, info, style, rect.width, rect.height, fm, lm, ce, font, rule, wordFlex);
            }
            toTry = ce.isOnceMore();
        }
        int offsetY = style.getVerticalAlign() == Styles.VerticalAlignment.TOP ? 0 : (style.getVerticalAlign() == Styles.VerticalAlignment.MIDDLE ? (oriHeight - ce.getUsedHeight()) / 2 - 1 : oriHeight - ce.getUsedHeight() - 2);
        return offsetY;
    }

    private void drawing(Graphics2D g2d, Rectangle rect, DrawingInfo info, Style style, int yOffset, LineWrapRule rule, boolean wordFlex) {
        String text = info.getText();
        Graphics2D newGraphics = (Graphics2D)g2d.create(rect.x, rect.y + yOffset, rect.width, rect.height > yOffset ? rect.height - yOffset : yOffset);
        newGraphics.setFont(ComplexTextRenderer.createFont(style, info.getFontSizeF()));
        newGraphics.setColor(style.getFontColor());
        DrawingExtend ext = new DrawingExtend(newGraphics);
        Font font = ComplexTextRenderer.createFont(style, info.getFontSizeF());
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        LineMetrics lm = font.getLineMetrics(text, 0, 1, g2d.getFontRenderContext());
        try {
            if (rule == null) {
                ComplexTextRenderer.throughStringAtRect(text, info, style, rect.width, rect.height, fm, lm, ext);
            } else {
                ComplexTextRenderer.throughStringAtRect(text, info, style, rect.width, rect.height, fm, lm, ext, font, rule, wordFlex);
            }
        }
        catch (Exception e) {
            log.debug("\u5728ComplexTextRender\u4e2d\u7ed8\u5236\u5b57\u7b26" + text + "   " + e);
        }
    }

    private static void throughStringAtRect(String text, DrawingInfo info, Style style, int width, int height, FontMetrics fontMetrics, LineMetrics lineMetrics, IThroughStringAtRect ext, Font font, LineWrapRule rule, boolean wordFlex) {
        ShrinkWrapProcess shrinkWrapProcess = new ShrinkWrapProcess(new LineWrapParam.Builder(text, rule).font(font).minW(width).maxW(width).build());
        ShrinkWrapProcess.ShrinkWrapInfo shrinkWrapInfo = (ShrinkWrapProcess.ShrinkWrapInfo)shrinkWrapProcess.process(wordFlex);
        text = shrinkWrapInfo.getText();
        int j = 0;
        float[] flexOffsets = shrinkWrapInfo.getFlexOffset();
        float y = lineMetrics.getAscent();
        float flexOffset = 0.0f;
        if (flexOffsets != null && flexOffsets.length > 0) {
            flexOffset += flexOffsets[0];
        }
        float offsetX = ComplexTextRenderer.calculateOffsetX(text, 0, info, fontMetrics, width, style.getHorizontalAlign(), flexOffset);
        float x = 0.0f;
        float sumWidth = 0.0f;
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            float tempX;
            char aChar = text.charAt(i);
            int nextRowStart = i;
            int charWidth = fontMetrics.charWidth(aChar);
            if (aChar == '\n') {
                tempX = x + (float)charWidth;
                ++nextRowStart;
            } else {
                tempX = x + (float)charWidth;
            }
            sumWidth += (float)charWidth;
            if (tempX > (float)width || aChar == '\n') {
                boolean noWrapScale = sumWidth > (float)width && rule == LineWrapRule.NoWrap;
                float tempFlex = 0.0f;
                if (flexOffsets != null && ++j < flexOffsets.length) {
                    flexOffset = tempFlex = flexOffsets[j];
                }
                offsetX = ComplexTextRenderer.calculateOffsetX(text, nextRowStart, info, fontMetrics, width, style.getHorizontalAlign(), tempFlex);
                x = 0.0f;
                tempX = charWidth;
                if ((y += info.getLineHeight()) + lineMetrics.getDescent() > (float)height || tempX > (float)width || noWrapScale) {
                    ext.dealOutSideRect(text, info, style, height, i);
                    return;
                }
            }
            ext.dealAChar(x + offsetX, y, aChar, charWidth);
            if (ext instanceof DrawingExtend && style.isUnderline()) {
                float ulOffset = lineMetrics.getUnderlineOffset();
                float ulThickness = lineMetrics.getUnderlineThickness();
                StandardUnderline.DefaultUnderline.drawUnderline(ext.getGraphics2D(), ulThickness, x + offsetX, x + offsetX + (float)charWidth, y + ulOffset);
            }
            ComplexTextRenderer.drawStrike(style, lineMetrics, ext, x + offsetX, charWidth, y);
            if (charWidth <= 0) continue;
            x = tempX + info.getWordSpacing() + flexOffset;
        }
        ext.dealThroughEnd(text, info, style, height, y, lineMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drawStrike(Style style, LineMetrics lineMetrics, IThroughStringAtRect ext, float x, int textWidth, float y) {
        if (ext instanceof DrawingExtend && style.isStrikeThrough()) {
            Graphics2D g2d = ext.getGraphics2D();
            Stroke saveStroke = g2d.getStroke();
            try {
                float strikeY = y + lineMetrics.getStrikethroughOffset();
                g2d.setStroke(new BasicStroke(lineMetrics.getStrikethroughThickness()));
                g2d.draw(new Line2D.Float(x, strikeY, x + (float)textWidth, strikeY));
            }
            catch (Exception exception) {
            }
            finally {
                g2d.setStroke(saveStroke);
            }
        }
    }

    private static void throughStringAtRect(String text, DrawingInfo info, Style style, int width, int height, FontMetrics fontMetrics, LineMetrics lineMetrics, IThroughStringAtRect ext) {
        int offsetX = ComplexTextRenderer.calculateOffsetX(text, 0, info, fontMetrics, width, style.getHorizontalAlign());
        float x = 0.0f;
        float y = lineMetrics.getAscent();
        StringBuilder sb = new StringBuilder();
        int sumChar = 0;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int ii = 0; ii < text.length() - 1; ++ii) {
            char aChar = text.charAt(ii);
            sb.append(aChar);
            int p = 0;
            if ((sumChar += fontMetrics.charWidth(aChar)) <= width) continue;
            if (String.valueOf(text.charAt(ii)).matches("[a-zA-Z]") && String.valueOf(text.charAt(ii + 1)).matches("[a-zA-Z]")) {
                p = sb.toString().lastIndexOf(" ");
                if (p == -1) {
                    sumChar = 12;
                    continue;
                }
                for (int jjj = 0; jjj < sb.toString().substring(p).length(); ++jjj) {
                    if (!String.valueOf(sb.toString().substring(p).charAt(jjj)).matches("[\\u4e00-\\u9fa5]")) continue;
                    p = ii;
                    break;
                }
                int offset = 0;
                for (int iii = 0; iii < sb.toString().substring(p).length(); ++iii) {
                    offset += fontMetrics.charWidth(sb.toString().substring(p).charAt(iii));
                }
                if (!Character.isWhitespace(text.charAt(p))) continue;
                map.put(p, sumChar);
                sumChar = 12;
                continue;
            }
            sumChar = 12;
        }
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            char aChar = text.charAt(i);
            float tempX = 0.0f;
            int nextRowStart = i;
            int charWidth = fontMetrics.charWidth(aChar);
            if (charWidth == 0) {
                tempX = aChar == '\n' ? (float)(width + 1) : x;
                ++nextRowStart;
            } else if (map.get(i) != null) {
                tempX = width + 1;
                ++nextRowStart;
                charWidth = 0;
            } else {
                tempX = x + (float)charWidth;
            }
            if (tempX > (float)width) {
                offsetX = ComplexTextRenderer.calculateOffsetX(text, nextRowStart, info, fontMetrics, width, style.getHorizontalAlign());
                x = 0.0f;
                tempX = charWidth;
                if ((y += info.getLineHeight()) + lineMetrics.getDescent() > (float)height || tempX > (float)width) {
                    ext.dealOutSideRect(text, info, style, height, i);
                    return;
                }
            }
            ext.dealAChar(x + (float)offsetX, y, aChar, charWidth);
            if (ext instanceof DrawingExtend && style.isUnderline()) {
                float ulOffset = lineMetrics.getUnderlineOffset();
                float ulThickness = lineMetrics.getUnderlineThickness();
                StandardUnderline.DefaultUnderline.drawUnderline(ext.getGraphics2D(), ulThickness, x + (float)offsetX, x + (float)offsetX + (float)charWidth, y + ulOffset);
            }
            ComplexTextRenderer.drawStrike(style, lineMetrics, ext, x, charWidth, y);
            if (charWidth <= 0) continue;
            x = tempX + info.getWordSpacing();
        }
        ext.dealThroughEnd(text, info, style, height, y, lineMetrics);
    }

    private static int calculateOffsetX(String text, int startIdx, DrawingInfo info, FontMetrics fontMetrics, int width, Styles.HorizontalAlignment horizontalAlignment) {
        return (int)ComplexTextRenderer.calculateOffsetX(text, startIdx, info, fontMetrics, width, horizontalAlignment, 0.0f);
    }

    private static float calculateOffsetX(String text, int startIdx, DrawingInfo info, FontMetrics fontMetrics, int width, Styles.HorizontalAlignment horizontalAlignment, float flexOffset) {
        int lineCharIndex;
        if (horizontalAlignment == Styles.HorizontalAlignment.LEFT) {
            return 0.0f;
        }
        float lineWidth = 0.0f;
        int charCount = text.length();
        for (lineCharIndex = startIdx; lineCharIndex < charCount; ++lineCharIndex) {
            char aChar = text.charAt(lineCharIndex);
            int charWidth = fontMetrics.charWidth(aChar);
            float addWidth = 0.0f;
            if (lineWidth > 0.0f && charWidth > 0) {
                addWidth = info.getWordSpacing();
            }
            if (lineWidth + (addWidth += (float)charWidth) > (float)width || aChar == '\n') break;
            lineWidth += addWidth;
        }
        float offsetX = horizontalAlignment == Styles.HorizontalAlignment.CENTER ? ((float)width - lineWidth) / 2.0f - (float)(lineCharIndex - startIdx - 1) * flexOffset / 2.0f : (float)width - lineWidth - (float)(lineCharIndex - startIdx - 1) * flexOffset;
        return offsetX;
    }

    static class DrawingExtend
    implements IThroughStringAtRect {
        private Graphics2D g2d;

        public DrawingExtend(Graphics2D g) {
            this.g2d = g;
        }

        @Override
        public Graphics2D getGraphics2D() {
            return this.g2d;
        }

        @Override
        public void dealAChar(float x, float y, char aChar, int charWidth) {
            if (charWidth > 0) {
                this.g2d.drawString(String.valueOf(aChar), x, y);
            }
        }

        @Override
        public void dealOutSideRect(String text, DrawingInfo info, Style style, int height, int throughingTextIdx) {
        }

        @Override
        public void dealThroughEnd(String text, DrawingInfo info, Style style, int height, float yEnd, LineMetrics lm) {
        }
    }

    static class CalculateExtend
    implements IThroughStringAtRect {
        private boolean onceMore;
        private Graphics2D g2d;
        private float cacheFitSize = -1.0f;
        private float cacheMinTooBigSize = Float.MAX_VALUE;
        private int cacheFitYEnd = 0;

        public CalculateExtend(Graphics2D g) {
            this.g2d = g;
        }

        @Override
        public Graphics2D getGraphics2D() {
            return this.g2d;
        }

        public void setOnceMore(boolean is) {
            this.onceMore = is;
        }

        public boolean isOnceMore() {
            return this.onceMore;
        }

        public int getUsedHeight() {
            return this.cacheFitYEnd;
        }

        @Override
        public void dealOutSideRect(String text, DrawingInfo info, Style style, int height, int throughingTextIdx) {
            if (Float.compare(info.getFontSizeF(), this.cacheMinTooBigSize) < 0) {
                this.cacheMinTooBigSize = info.getFontSizeF();
            }
            float newSize = (float)((double)info.getFontSizeF() * Math.sqrt((float)throughingTextIdx / (float)text.length()));
            info.updateFontSize(newSize, style, height, this.g2d);
            if (Float.compare(newSize, this.cacheFitSize) > 0 && Float.compare(newSize, this.cacheMinTooBigSize) < 0) {
                this.onceMore = true;
                log.debug("\u7a7a\u95f4\u4e0d\u591f\uff0c\u5c0f\u5c0f\u5c0f\u5230" + newSize);
            } else {
                log.debug("\u7a7a\u95f4\u4e0d\u591f\uff0c\u4f46\u6ca1\u5fc5\u8981\u518d\u5c0f\u5230" + newSize + "\uff0c\u5c31\u7528" + this.cacheFitSize);
            }
        }

        @Override
        public void dealAChar(float x, float y, char aChar, int charWidth) {
        }

        @Override
        public void dealThroughEnd(String text, DrawingInfo info, Style style, int height, float yEnd, LineMetrics lm) {
            float y = yEnd + lm.getDescent();
            if (Float.compare(info.getFontSizeF(), this.cacheFitSize) > 0) {
                log.debug("\u7f13\u5b58\u5408\u9002\u5b57\u53f7\u53ca\u7ed8\u5236\u72b6\u6001: " + this.cacheFitSize + " => " + info.getFontSizeF());
                this.cacheFitSize = info.getFontSizeF();
                this.cacheFitYEnd = (int)y + 1;
            }
            if (info.getFontSizeF() > 0.0f && Float.compare(info.getFontSizeF(), ComplexTextRenderer.getOriSize(style)) < 0) {
                float spaceUsedRate = y / (float)height;
                log.debug("\u7a7a\u95f4\u5360\u7528\u7387\uff1a" + spaceUsedRate);
                if ((double)spaceUsedRate < 0.9) {
                    float newSize = (float)((double)info.getFontSizeF() * Math.sqrt(1.0f / spaceUsedRate) + 0.5);
                    if (Float.compare(newSize, this.cacheFitSize) <= 0) {
                        log.debug("\u6ca1\u5fc5\u8981\u518d\u5927\u5230" + newSize + "\uff0c\u5c31\u7528" + this.cacheFitSize);
                    } else if (Float.compare(newSize, ComplexTextRenderer.getOriSize(style)) <= 0) {
                        if (Float.compare(newSize, this.cacheMinTooBigSize) >= 0) {
                            log.debug("\u5df2\u77e5\u6700\u5c0f\u7684\u592a\u5927\u5b57\u53f7" + this.cacheMinTooBigSize + "\u3002\u6ca1\u5fc5\u8981\u518d\u5927\u5230" + newSize + "\uff0c\u5c31\u7528" + this.cacheFitSize);
                        } else {
                            info.updateFontSize(newSize, style, height, this.g2d);
                            this.onceMore = true;
                            log.debug("\u5927\u5927\u5927\u5230" + newSize);
                        }
                    } else {
                        log.debug("\u65b0\u5b57\u53f7" + newSize + "\u4e0d\u80fd\u5927\u4e8e\u539f\u59cb\u5b57\u53f7" + ComplexTextRenderer.getOriSize(style));
                    }
                }
            }
        }
    }

    static interface IThroughStringAtRect {
        public void dealAChar(float var1, float var2, char var3, int var4);

        public void dealOutSideRect(String var1, DrawingInfo var2, Style var3, int var4, int var5);

        public void dealThroughEnd(String var1, DrawingInfo var2, Style var3, int var4, float var5, LineMetrics var6);

        public Graphics2D getGraphics2D();
    }

    public static class DrawingInfo {
        private String text;
        private float fontSize;
        private float lineHeight;
        private float wordSpacing;
        private float lineSpacing;

        private DrawingInfo(String text) {
            this.text = text;
        }

        public static DrawingInfo create(String text, int fontSize, float lineHeight, float wordSpacing, float lineSpacing) {
            return DrawingInfo.create(text, (float)fontSize, lineHeight, wordSpacing, lineSpacing);
        }

        public static DrawingInfo create(String text, float fontSize, float lineHeight, float wordSpacing, float lineSpacing) {
            DrawingInfo info = new DrawingInfo(text);
            info.fontSize = fontSize;
            info.lineHeight = lineHeight;
            info.wordSpacing = wordSpacing;
            info.lineSpacing = lineSpacing;
            return info;
        }

        public final String getText() {
            return this.text;
        }

        public final float getLineHeight() {
            return this.lineHeight;
        }

        @Deprecated
        public final int getFontSize() {
            return (int)this.fontSize;
        }

        public final float getFontSizeF() {
            return this.fontSize;
        }

        public final float getWordSpacing() {
            return this.wordSpacing;
        }

        public final float getLineSpacing() {
            return this.lineSpacing;
        }

        @Deprecated
        public final void updateFontSize(int fontSize, Style style, int rectHeight, Graphics2D g2d) {
            this.updateFontSize((float)fontSize, style, rectHeight, g2d);
        }

        public final void updateFontSize(float fontSize, Style style, int rectHeight, Graphics2D g2d) {
            this.fontSize = fontSize;
            this.lineHeight = ComplexTextRenderer.calculateLineHeight(this.text, ComplexTextRenderer.createFont(style, fontSize), this.lineSpacing, g2d);
        }
    }
}

