/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.splitrectangle;

import java.awt.FontMetrics;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ctrl.kdf.util.style.Style;

public class TriangleInfo {
    Point2D[] _points;
    Style _style;
    String _text;
    boolean _lean;
    boolean _autoZoom = true;
    boolean _drawBack;
    private WrapTextCalc wrapC = new WrapTextCalc();

    void copyFrom(TriangleInfo info, boolean onlyAttris) {
        this._style = info._style;
        this._text = info._text;
        this._lean = info._lean;
        this._autoZoom = info._autoZoom;
        this._drawBack = info._drawBack;
        if (!onlyAttris) {
            this._points = new Point2D.Double[info._points.length];
            System.arraycopy(this._points, 0, info._points, 0, this._points.length);
        }
    }

    TriangleInfo() {
    }

    public TriangleInfo(Point2D[] points) {
        if (points == null || points.length != 3) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u70b9\u7684\u6570\u76ee\u5fc5\u987b\u662f3\u3002", (String)"TriangleInfo_0", (String)"bos-print-core", (Object[])new Object[0]));
        }
        this._points = points;
    }

    void setPoints(Point2D[] points) {
        if (points == null || points.length != 3) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u70b9\u7684\u6570\u76ee\u5fc5\u987b\u662f3\u3002", (String)"TriangleInfo_0", (String)"bos-print-core", (Object[])new Object[0]));
        }
        this._points = points;
    }

    public void setText(String text) {
        this._text = text;
    }

    public void setLean(boolean lean) {
        this._lean = lean;
    }

    public void setAutoZoom(boolean autoZoom) {
        this._autoZoom = autoZoom;
    }

    public void setDrawBackground(boolean drawBack) {
        this._drawBack = drawBack;
    }

    public void setStyle(Style style) {
        this._style = style;
    }

    Shape getScaledAwtShape(double scale) {
        Point2D cp = this.getWeightPoint();
        double cx = cp.getX();
        double cy = cp.getY();
        Polygon p = new Polygon();
        for (int i = 2; i >= 0; --i) {
            double x = this._points[i].getX();
            double y = this._points[i].getY();
            x = cx + (x - cx) * scale;
            y = cy + (y - cy) * scale;
            p.addPoint((int)x, (int)y);
        }
        return p;
    }

    Point2D getWeightPoint() {
        double x = 0.0;
        double y = 0.0;
        for (int i = 2; i >= 0; --i) {
            x += this._points[i].getX();
            y += this._points[i].getY();
        }
        return new Point2D.Double(x /= 3.0, y /= 3.0);
    }

    double getSuggestLeanDrgee() {
        double drgee = 0.0;
        Point2D cp = this.getWeightPoint();
        Point2D _p1 = this._points[0];
        Point2D _p2 = this._points[1];
        Point2D _p3 = this._points[2];
        double opp1 = Math.pow(_p2.getX() - _p3.getX(), 2.0) + Math.pow(_p2.getY() - _p3.getY(), 2.0);
        double opp2 = Math.pow(_p1.getX() - _p3.getX(), 2.0) + Math.pow(_p1.getY() - _p3.getY(), 2.0);
        double opp3 = Math.pow(_p2.getX() - _p1.getX(), 2.0) + Math.pow(_p2.getY() - _p1.getY(), 2.0);
        drgee = opp1 < opp2 && opp1 < opp3 ? (_p1.getX() == cp.getX() ? (opp2 < opp3 ? (_p2.getY() - cp.getY()) / (_p2.getX() - cp.getX()) : (_p3.getY() - cp.getY()) / (_p3.getX() - cp.getX())) : (_p1.getY() - cp.getY()) / (_p1.getX() - cp.getX())) : (opp2 < opp1 && opp2 < opp3 ? (_p2.getX() == cp.getX() ? (opp1 < opp3 ? (_p1.getY() - cp.getY()) / (_p1.getX() - cp.getX()) : (_p3.getY() - cp.getY()) / (_p3.getX() - cp.getX())) : (_p2.getY() - cp.getY()) / (_p2.getX() - cp.getX())) : (_p3.getX() == cp.getX() ? (opp2 < opp1 ? (_p2.getY() - cp.getY()) / (_p2.getX() - cp.getX()) : (_p1.getY() - cp.getY()) / (_p1.getX() - cp.getX())) : (_p3.getY() - cp.getY()) / (_p3.getX() - cp.getX())));
        return drgee;
    }

    public Shape getAwtShape() {
        Polygon p = new Polygon();
        for (int i = 2; i >= 0; --i) {
            double x = this._points[i].getX();
            double y = this._points[i].getY();
            p.addPoint((int)x, (int)y);
        }
        return p;
    }

    public String getText() {
        return this._text;
    }

    public Style getStyle() {
        return this._style;
    }

    public boolean isLean() {
        return this._lean;
    }

    public boolean isAutoZoom() {
        return this._autoZoom;
    }

    public boolean isDrawBackground() {
        return this._drawBack;
    }

    double calcWrapTextRects(ArrayList upRects, ArrayList downRects, FontMetrics fm) {
        return this.wrapC.calcWrapTextRects(upRects, downRects, fm);
    }

    double calcWrapTextRects(ArrayList upRects, ArrayList downRects, double w, double h) {
        return this.wrapC.calcWrapTextRects(upRects, downRects, w, h);
    }

    class WrapTextCalc {
        WrapTextCalc() {
        }

        private double getMiny() {
            double y0 = TriangleInfo.this._points[0].getY();
            double y1 = TriangleInfo.this._points[1].getY();
            double y2 = TriangleInfo.this._points[2].getY();
            if (y0 < y1) {
                return y2 < y0 ? y2 : y0;
            }
            return y2 < y1 ? y2 : y1;
        }

        private int getUpIndex() {
            double y0 = TriangleInfo.this._points[0].getY();
            double y1 = TriangleInfo.this._points[1].getY();
            double y2 = TriangleInfo.this._points[2].getY();
            if (y0 < y1) {
                return y2 < y0 ? 2 : 0;
            }
            return y2 < y1 ? 2 : 1;
        }

        private double getMaxy() {
            double y0 = TriangleInfo.this._points[0].getY();
            double y1 = TriangleInfo.this._points[1].getY();
            double y2 = TriangleInfo.this._points[2].getY();
            if (y0 > y1) {
                return y2 > y0 ? y2 : y0;
            }
            return y2 > y1 ? y2 : y1;
        }

        private double calcDrgee(int index1, int index2) {
            double x1 = TriangleInfo.this._points[index1].getX();
            double y1 = TriangleInfo.this._points[index1].getY();
            double x2 = TriangleInfo.this._points[index2].getX();
            double y2 = TriangleInfo.this._points[index2].getY();
            if (x1 == x2) {
                return Double.POSITIVE_INFINITY;
            }
            return (y1 - y2) / (x1 - x2);
        }

        private int splitPointIndex() {
            double y0 = TriangleInfo.this._points[0].getY();
            double y1 = TriangleInfo.this._points[1].getY();
            double y2 = TriangleInfo.this._points[2].getY();
            if (y0 == y1) {
                return -3;
            }
            if (y1 == y2) {
                return -1;
            }
            if (y0 == y2) {
                return -2;
            }
            if (y0 < y1) {
                if (y0 > y2) {
                    return 0;
                }
                if (y1 < y2) {
                    return 1;
                }
                return 2;
            }
            if (y0 < y2) {
                return 0;
            }
            if (y1 > y2) {
                return 1;
            }
            return 2;
        }

        private int getRemainIndex(int index1, int index2) {
            for (int i = 0; i < 3; ++i) {
                if (i == index1 || i == index2) continue;
                return i;
            }
            return -1;
        }

        private int getRemainIndex1(int index) {
            for (int i = 0; i < 3; ++i) {
                if (i == index) continue;
                return i;
            }
            return -1;
        }

        double calcInterX(double drgee, int index, double y) {
            if (drgee == Double.POSITIVE_INFINITY) {
                return TriangleInfo.this._points[index].getX();
            }
            double x0 = TriangleInfo.this._points[index].getX();
            double y0 = TriangleInfo.this._points[index].getY();
            return x0 - (y0 - y) / drgee;
        }

        boolean compare(double drgee1, double drgee2) {
            if (drgee1 == Double.POSITIVE_INFINITY) {
                return drgee2 > 0.0;
            }
            if (drgee2 == Double.POSITIVE_INFINITY) {
                return drgee1 < 0.0;
            }
            if (drgee1 < 0.0 && drgee2 > 0.0) {
                return true;
            }
            if (drgee1 > 0.0 && drgee2 < 0.0) {
                return false;
            }
            return drgee1 > drgee2;
        }

        double calcWrapTextRects(ArrayList upRects, ArrayList downRects, FontMetrics fm) {
            return this.calcWrapTextRects(upRects, downRects, fm.getMaxAdvance(), fm.getHeight());
        }

        double calcWrapTextRects(ArrayList upRects, ArrayList downRects, double w, double h) {
            double maxx;
            double minx;
            double rx2;
            double lx2;
            double rx;
            double lx;
            int indexRight;
            int indexLeft;
            double drgeeRight;
            double drgeeLeft;
            double allUpWidth = 0.0;
            double allDownWidth = 0.0;
            double splity = -1.0;
            double drgeeSplit = -1.0;
            int indexSplit = -1;
            boolean hasSplit = false;
            boolean splitLeft = false;
            boolean upMin = false;
            boolean downMin = false;
            int spIndex = this.splitPointIndex();
            if (spIndex < 0) {
                boolean b;
                int tIndex = -(spIndex + 1);
                int index1 = this.getRemainIndex1(tIndex);
                int index2 = this.getRemainIndex(tIndex, index1);
                double drgee1 = this.calcDrgee(tIndex, index1);
                double drgee2 = this.calcDrgee(tIndex, index2);
                boolean bl = b = TriangleInfo.this._points[index1].getX() < TriangleInfo.this._points[index2].getX();
                if (b) {
                    drgeeLeft = drgee1;
                    drgeeRight = drgee2;
                } else {
                    drgeeLeft = drgee2;
                    drgeeRight = drgee1;
                }
                indexLeft = tIndex;
                indexRight = tIndex;
                if (tIndex == this.getUpIndex()) {
                    upMin = true;
                } else {
                    downMin = true;
                }
            } else {
                double drgee2;
                hasSplit = true;
                int upIndex = this.getUpIndex();
                int downIndex = this.getRemainIndex(upIndex, spIndex);
                double drgee1 = this.calcDrgee(upIndex, spIndex);
                boolean b = this.compare(drgee1, drgee2 = this.calcDrgee(upIndex, downIndex));
                if (b) {
                    splitLeft = true;
                    drgeeLeft = drgee1;
                    drgeeRight = drgee2;
                } else {
                    drgeeLeft = drgee2;
                    drgeeRight = drgee1;
                }
                indexLeft = upIndex;
                indexRight = upIndex;
                drgeeSplit = this.calcDrgee(spIndex, downIndex);
                indexSplit = spIndex;
                splity = TriangleInfo.this._points[spIndex].getY();
                upMin = true;
                downMin = true;
            }
            double miny = this.getMiny();
            double maxy = this.getMaxy();
            double cy = TriangleInfo.this.getWeightPoint().getY();
            if (cy - h / 2.0 < miny && cy + h / 2.0 > maxy) {
                return 0.0;
            }
            double lasty = cy + h / 2.0;
            while (lasty - h > miny) {
                if (hasSplit) {
                    if (splitLeft) {
                        if (lasty < splity) {
                            lx = this.calcInterX(drgeeLeft, indexLeft, lasty);
                            rx = this.calcInterX(drgeeRight, indexRight, lasty);
                        } else {
                            lx = this.calcInterX(drgeeSplit, indexSplit, lasty);
                            rx = this.calcInterX(drgeeRight, indexRight, lasty);
                        }
                        if (lasty - h < splity) {
                            lx2 = this.calcInterX(drgeeLeft, indexLeft, lasty - h);
                            rx2 = this.calcInterX(drgeeRight, indexRight, lasty - h);
                        } else {
                            lx2 = this.calcInterX(drgeeSplit, indexSplit, lasty - h);
                            rx2 = this.calcInterX(drgeeRight, indexRight, lasty - h);
                        }
                        minx = Math.max(lx, lx2);
                        maxx = Math.min(rx, rx2);
                        if (maxx - minx >= w) {
                            allUpWidth += maxx - minx;
                            upRects.add(0, new Rectangle2D.Double(minx, lasty - h, maxx - minx, h));
                        } else if (lasty - h < splity) {
                            break;
                        }
                    } else {
                        if (lasty < splity) {
                            lx = this.calcInterX(drgeeLeft, indexLeft, lasty);
                            rx = this.calcInterX(drgeeRight, indexRight, lasty);
                        } else {
                            rx = this.calcInterX(drgeeSplit, indexSplit, lasty);
                            lx = this.calcInterX(drgeeLeft, indexLeft, lasty);
                        }
                        if (lasty - h < splity) {
                            lx2 = this.calcInterX(drgeeLeft, indexLeft, lasty - h);
                            rx2 = this.calcInterX(drgeeRight, indexRight, lasty - h);
                        } else {
                            rx2 = this.calcInterX(drgeeSplit, indexSplit, lasty - h);
                            lx2 = this.calcInterX(drgeeLeft, indexLeft, lasty - h);
                        }
                        minx = Math.max(lx, lx2);
                        maxx = Math.min(rx, rx2);
                        if (maxx - minx >= w) {
                            allUpWidth += maxx - minx;
                            upRects.add(0, new Rectangle2D.Double(minx, lasty - h, maxx - minx, h));
                        } else if (lasty - h < splity) {
                            break;
                        }
                    }
                } else {
                    lx = this.calcInterX(drgeeLeft, indexLeft, lasty);
                    rx = this.calcInterX(drgeeRight, indexRight, lasty);
                    lx2 = this.calcInterX(drgeeLeft, indexLeft, lasty - h);
                    rx2 = this.calcInterX(drgeeRight, indexRight, lasty - h);
                    minx = Math.max(lx, lx2);
                    maxx = Math.min(rx, rx2);
                    if (maxx - minx >= w) {
                        allUpWidth += maxx - minx;
                        upRects.add(0, new Rectangle2D.Double(minx, lasty - h, maxx - minx, h));
                    } else if (upMin) break;
                }
                lasty -= h;
            }
            lasty = cy + h / 2.0;
            while (lasty + h < maxy) {
                if (hasSplit) {
                    if (splitLeft) {
                        if (lasty < splity) {
                            lx = this.calcInterX(drgeeLeft, indexLeft, lasty);
                            rx = this.calcInterX(drgeeRight, indexRight, lasty);
                        } else {
                            lx = this.calcInterX(drgeeSplit, indexSplit, lasty);
                            rx = this.calcInterX(drgeeRight, indexRight, lasty);
                        }
                        if (lasty + h < splity) {
                            lx2 = this.calcInterX(drgeeLeft, indexLeft, lasty + h);
                            rx2 = this.calcInterX(drgeeRight, indexRight, lasty + h);
                        } else {
                            lx2 = this.calcInterX(drgeeSplit, indexSplit, lasty + h);
                            rx2 = this.calcInterX(drgeeRight, indexRight, lasty + h);
                        }
                        minx = Math.max(lx, lx2);
                        maxx = Math.min(rx, rx2);
                        if (maxx - minx >= w) {
                            allDownWidth += maxx - minx;
                            downRects.add(new Rectangle2D.Double(minx, lasty, maxx - minx, h));
                        } else if (lasty + h > splity) {
                            break;
                        }
                    } else {
                        if (lasty < splity) {
                            lx = this.calcInterX(drgeeLeft, indexLeft, lasty);
                            rx = this.calcInterX(drgeeRight, indexRight, lasty);
                        } else {
                            rx = this.calcInterX(drgeeSplit, indexSplit, lasty);
                            lx = this.calcInterX(drgeeLeft, indexLeft, lasty);
                        }
                        if (lasty + h < splity) {
                            lx2 = this.calcInterX(drgeeLeft, indexLeft, lasty + h);
                            rx2 = this.calcInterX(drgeeRight, indexRight, lasty + h);
                        } else {
                            rx2 = this.calcInterX(drgeeSplit, indexSplit, lasty + h);
                            lx2 = this.calcInterX(drgeeLeft, indexLeft, lasty + h);
                        }
                        minx = Math.max(lx, lx2);
                        maxx = Math.min(rx, rx2);
                        if (maxx - minx >= w) {
                            allDownWidth += maxx - minx;
                            downRects.add(new Rectangle2D.Double(minx, lasty, maxx - minx, h));
                        } else if (lasty + h > splity) {
                            break;
                        }
                    }
                } else {
                    lx = this.calcInterX(drgeeLeft, indexLeft, lasty);
                    rx = this.calcInterX(drgeeRight, indexRight, lasty);
                    lx2 = this.calcInterX(drgeeLeft, indexLeft, lasty + h);
                    rx2 = this.calcInterX(drgeeRight, indexRight, lasty + h);
                    minx = Math.max(lx, lx2);
                    maxx = Math.min(rx, rx2);
                    if (maxx - minx >= w) {
                        allDownWidth += maxx - minx;
                        downRects.add(new Rectangle2D.Double(minx, lasty, maxx - minx, h));
                    } else if (downMin) break;
                }
                lasty += h;
            }
            if (allDownWidth == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return allUpWidth / allDownWidth;
        }
    }
}

