/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureTextLine;
import kd.bos.print.core.ctrl.kdf.util.render.layout.TextLineBreaker;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.swing.KDFont;

public final class Tools {
    private static final int DPI = 96;

    public static String htmlCode(String source) {
        if (StringUtil.isEmptyString((String)source)) {
            return source;
        }
        source = source.replaceAll("&", "&amp;");
        source = source.replaceAll("<", "&lt;");
        source = source.replaceAll(">", "&gt;");
        source = source.replaceAll("\"", "&quot;");
        return source;
    }

    public static String htmlDecode(String source) {
        source = source.replaceAll("&lt;", "<");
        source = source.replaceAll("&gt;", ">");
        source = source.replaceAll("&quot;", "\"");
        source = source.replaceAll("&euro;", "?");
        source = source.replaceAll("&amp;", "&");
        return source;
    }

    public static Dimension getTextAreaSize(String source, Style style, FontRenderContext frc) {
        if (source == null || source.length() == 0) {
            return new Dimension(0, 0);
        }
        SureTextLine stl = new SureTextLine(source, style.getFont(), frc);
        return new Dimension((int)(stl.getAdvance() * 254.0 / 96.0), (int)(stl.getHeight() * 254.0 / 96.0));
    }

    public static Dimension getBreakedTextAreaSize(String source, Style style, FontRenderContext frc) {
        if (source == null || source.length() == 0) {
            return new Dimension(0, 0);
        }
        TextLineBreaker tlb = new TextLineBreaker(source, style.getFont(), frc);
        double mWidth = 0.0;
        double mHeight = 0.0;
        KDFont ft = style.getKDFont();
        while (tlb.hasNext()) {
            String line = tlb.nextRowString();
            Rectangle2D r2d = ft.getStringBounds(line, frc);
            double t = r2d.getWidth();
            if (t > mWidth) {
                mWidth = t;
            }
            t = r2d.getHeight();
            mHeight += t;
        }
        return new Dimension((int)(mWidth * 254.0 / 96.0), (int)(mHeight * 254.0 / 96.0));
    }

    public static String[] getBreakedTextLines(int widthLimit, String source, Style style, FontRenderContext frc) {
        if (source == null || source.length() == 0) {
            return new String[0];
        }
        TextLineBreaker tlb = new TextLineBreaker(source, style.getFont(), frc);
        double width = (double)(widthLimit * 96) / 254.0;
        ArrayList<String> al = new ArrayList<String>();
        while (tlb.hasNext()) {
            al.add(tlb.nextRowString(width));
        }
        return al.toArray(new String[0]);
    }

    public static Dimension getBreakedTextAreaSize(int widthLimit, String source, Style style, FontRenderContext frc) {
        if (source == null || source.length() == 0) {
            return new Dimension(0, 0);
        }
        TextLineBreaker tlb = new TextLineBreaker(source, style.getFont(), frc);
        double width = (double)(widthLimit * 96) / 254.0;
        double mWidth = 0.0;
        double mHeight = 0.0;
        KDFont ft = style.getKDFont();
        while (tlb.hasNext()) {
            String line = tlb.nextRowString(width);
            Rectangle2D r2d = ft.getStringBounds(line, frc);
            double t = r2d.getWidth();
            if (t > mWidth) {
                mWidth = t;
            }
            t = r2d.getHeight();
            mHeight += t;
        }
        return new Dimension((int)(mWidth * 254.0 / 96.0), (int)(mHeight * 254.0 / 96.0));
    }

    public static float getBreakedTextAreaSize2(int widthLimit, String source, Style style, FontRenderContext frc) {
        if (source == null || source.length() == 0) {
            return 0.0f;
        }
        TextLineBreaker tlb = new TextLineBreaker(source, style.getFont(), frc);
        double width = widthLimit;
        double mWidth = 0.0;
        double mHeight = 0.0;
        KDFont ft = style.getKDFont();
        while (tlb.hasNext()) {
            String line = tlb.nextRowString(width);
            Rectangle2D r2d = ft.getStringBounds(line, frc);
            double t = r2d.getWidth();
            if (t > mWidth) {
                mWidth = t;
            }
            t = r2d.getHeight();
            mHeight += t;
        }
        return (float)mHeight;
    }

    public static Color parseColor(String strColor) {
        Color color = null;
        try {
            String strR = strColor.substring(1, 3);
            String strG = strColor.substring(3, 5);
            String strB = strColor.substring(5, 7);
            color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16));
        }
        catch (Exception err) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u989c\u8272\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6b63\u786e\u683c\u5f0f\u5982\uff1a#00ff99", (String)"Tools_0", (String)"bos-print-core", (Object[])new Object[0]), err);
        }
        return color;
    }
}

